(*$V-,R-,S-,B-,I-,F+*)
PROGRAM PibCat;

(*----------------------------------------------------------------------*)
(*                                                                      *)
(*    Program: PIBCAT --- Catalog files on a disk.                      *)
(*                                                                      *)
(*    Author:  Philip R. Burns.                                         *)
(*                                                                      *)
(*    Version: 1.7.   March 31, 1989.                                   *)
(*                                                                      *)
(*    Usage:                                                            *)
(*                                                                      *)
(*       PIBCAT v /c=format /e=filespec /f=filespec /i=indent /l        *)
(*                /m=margin /n /o=filename /p=pagesize /s=filename      *)
(*               /t=timezone /x /2                                      *)
(*                                                                      *)
(*                                                                      *)
(*            v               volume (drive letter) to catalog          *)
(*                            (default is current drive)                *)
(*                            If given as ?, this text is displayed.    *)
(*            /a              Requests that PibCat output be appended   *)
(*                            to the file specified by "/o=".  Default  *)
(*                            is to overwrite the the output file.      *)
(*            /c=format       Produce condensed listing suitable for    *)
(*                            input to a database manager or sorting    *)
(*                            program.  Two formats are available:  a   *)
(*                            columnar format specified as "/c=column"  *)
(*                            or a comma-delimited format specified as  *)
(*                            "/c=comma".  Specifying "/c" without a    *)
(*                            format produces the columnar format.      *)
(*                            This option overrides all other formatting*)
(*                            options.                                  *)
(*            /e=filespec     DOS file spec to match when listing       *)
(*                            entries in .ARC/.DWC/.LBR/.MD/.PAK/.ZIP/  *)
(*                            .ZOO files                                *)
(*                            (default is *.* -- list all entries).     *)
(*            /f=filespec     DOS file spec to match when listing files *)
(*                            (default is *.* -- list all files)        *)
(*            /i=indent       # columns to space for library entries    *)
(*                            (default is 0)                            *)
(*            /l              display long file names in .ZOO and .MD   *)
(*                            files (default is to display short file   *)
(*                            names only)                               *)
(*            /m=margin       left margin to leave (default is 0)       *)
(*            /n              expand libraries after main catalog       *)
(*                            listing rather than immediately after     *)
(*                            library file name (default is to expand   *)
(*                            immediately following file name).         *)
(*            /o=filename     write catalog listing to file "filename"  *)
(*                            (default is "CATALOG.LIS")                *)
(*            /p=pagesize     paginate listing using "pagesize" lines   *)
(*                            (default is no pagination)                *)
(*            /s=filename     write status information to "filename"    *)
(*                            (default is DOS standard output)          *)
(*            /t=timezone     number of hours local time lags/leads     *)
(*                            Greenwich Mean Time [GMT] (default is 7)  *)
(*            /x              don't list library file contents          *)
(*                            (default is to list contents)             *)
(*            /2              Opens files without SHARE for DOS v2.x    *)
(*                            compatibility (default is to open files   *)
(*                            with share for DOS v3.1 and above)        *)
(*                                                                      *)
(*    Aborting:  Hit ^C to abort catalog listing.                       *)
(*                                                                      *)
(*    Output:                                                           *)
(*                                                                      *)
(*       For each selected file, the file name, size in bytes, and time *)
(*       and date of creation are displayed.  The same information is   *)
(*       given for members of .ARC, .DWC, .LBR, .MD, and .ZOO files.    *)
(*                                                                      *)
(*    Restrictions:                                                     *)
(*                                                                      *)
(*       None.  I contribute this program and all source code to the    *)
(*       public domain.                                                 *)
(*                                                                      *)
(*       I do ask as a matter of courtesy that you give me credit if    *)
(*       you use this code in your own applications.                    *)
(*                                                                      *)
(*    Acknowledgments:                                                  *)
(*                                                                      *)
(*       The archive search code is based upon TPARCV.PAS written by    *)
(*       Michael Quinlan and ARCV.ASM written by Vern Buerg.            *)
(*                                                                      *)
(*       The library search code is based upon LU.PAS written by        *)
(*       Steve Freeman.                                                 *)
(*                                                                      *)
(*       Stephen Falatko suggested and coded the enhancement to list    *)
(*       the contents of .ARC, .LBR files immediately following their   *)
(*       appearance in the main catalog listing.  I've altered the      *)
(*       display to make it easier to pick those entries which are .ARC *)
(*       and .LBR contents.                                             *)
(*                                                                      *)
(*       Dave Seidman provided a mechanism for getting the volume label *)
(*       under MS DOS 2.x.                                              *)
(*                                                                      *)
(*       The format for the .ZOO files was taken from the "C" source    *)
(*       code to ZOO written by Rahul Dhesi.                            *)
(*                                                                      *)
(*       The format for the .MD files was extracted from the code       *)
(*       provided by Mike Davenport.                                    *)
(*                                                                      *)
(*       The format for the .DWC files was extracted from the code      *)
(*       provided by Dean W. Cooper for his DWC program.                *)
(*                                                                      *)
(*       The format for the .ZIP files comes from the APPNOTE.TXT file  *)
(*       provided by Phil Katz with his PKZIP/PKUNZIP utilities, and    *)
(*       from Ken Brown's ZIPV program (written in C).                  *)
(*                                                                      *)
(*       The format for the extended .ARC headers comes from technical  *)
(*       note TM0401.TXT provided by SEA.                               *)
(*                                                                      *)
(*       The format for the .LZH and .LZS files comes from a note by    *)
(*       Robert A. Freed.                                               *)
(*                                                                      *)
(*    Note:                                                             *)
(*                                                                      *)
(*      The routines for processing the various library files are all   *)
(*      extremely similar.  I could have merged them into one big       *)
(*      routine to avoid the duplicate code.  However, I felt it was    *)
(*      a better idea to leave them separate, even with the extensive   *)
(*      code duplication, so that you could extract the ones you wanted *)
(*      without having to wade through stuff unrelated to the library   *)
(*      format of interest to you.                                      *)
(*                                                                      *)
(*----------------------------------------------------------------------*)

                                   (* Global declarations *)
(*$I PIBCAT.GLO    *)
                                   (* General service subroutines *)
(*$I PIBCATS1.PAS  *)
(*$I PIBCATS2.PAS  *)
                                   (* Initialization and display  *)
(*$I PIBCATS3.PAS  *)

(*----------------------------------------------------------------------*)
(*          Include code to process library files.                      *)
(*----------------------------------------------------------------------*)

                                   (* .ARC/.PAK display routines    *)
(*$I PIBCATA.PAS *)
                                   (* .DWC display routines         *)
(*$I PIBCATD.PAS *)
                                   (* .ZIP display routines         *)
(*$I PIBCATK.PAS *)
                                   (* .LBR display routines         *)
(*$I PIBCATL.PAS *)
                                   (* .MD display routines          *)
(*$I PIBCATM.PAS *)
                                   (* .LHZ display routines         *)
(*$I PIBCATY.PAS *)
                                   (* .ZOO display routines         *)
(*$I PIBCATZ.PAS *)

(*----------------------------------------------------------------------*)
(*          File display, sorting, listing control routines.            *)
(*----------------------------------------------------------------------*)

(*$I PIBCATS4.PAS *)

(*---------------------- Main Program of PIBCAT ------------------------*)

BEGIN (* PibCat *)
                                   (* Initialize program.  If initialization *)
                                   (* goes OK, then perform cataloguing.     *)
   IF Initialize THEN
      Perform_Cataloguing;
                                   (* Close output file and terminate.       *)
   Terminate;

END   (* PibCat *).
