/*
 *              ***************
 *              * X R F 0 . C *
 *              ***************
 *
 * This is the mainline program for the C cross referencer and lister.
 * It handles the following tasks:
 *
 *      - Scans the command line
 *      - Opens the appropriate files
 *      - Calls some initialization functions
 *      - Invokes line by line processing
 *      - Prints the cross-reference index
 *      - Finishes up processing as appropriate
 *
 *
 * Usage:
 *
 *	xrf [-s] [-n] [-o out_file] in_files
 *
 *	Flags:
 *		-s	Spool out_file to printer QUEUE
 *		-n	Narrow (80 column) output, normal is 132 column.
 *		-i	Maximum size Symbols, else truncated to minimum size.
 *		-p	Print C source (with linenumbers) as well.
 *		-c	Concatanate C source files (treat as one).
 *		-v	Verbose mode (get chatty)
 *
 *		-o file	Write output to the indicated file.  If -o is not
 *			specified, output will be to the first in_file
 *			with the filetype set to ".x"
 *
 * Written By:
 *              Bob Denny
 *              Creative System Design Co.
 *              3452 E. Foothill Blvd. << Suite 601 >>
 *              Pasadena, Ca.  91107
 *              (213) 355-6836
 * Modified for MSDOS By:
 *
 *		Mike Cole
 *		Digital Equipment Co.
 *		PC Customer Information & Support Centre,
 *		Jays Close,
 *		Basingstoke,
 *		Hampshire  RG22 4DE,
 *		ENGLAND.		(44) 256-59200
 *
 *
 * Experimental Version         X1.0             5-May-80
 * Split off initialization     X1.1             7-May-80
 * Prototype.                   Y1.2             9-May-80
 * Release.                     V1.3             9-May-80
 * Chg. for DECUS OTS. & Cmplr. V1.4             1-Jul-80
 * Add support for RT-11        V1.5             3-Jul-80
 * Conditionalized spool call	V1.6 MM		 9-Jul-80
 * Added narrow, outfile, etc.	V1.7 MM		10-Jul-80
 * Added multiple infiles	V1.8 MM		22-Jul-80
 * Fspool now in the library	V1.9 MM		 2-Aug-80
 * Modify for CI86 under MSDOS  V1.10MC		 3-Dec-84
 * add Print spooler (-s opt)   V1.11MC		 4-Jan-85
 * add -i, -p options           V1.12MC		 4-Jan-85
 * add -c option                V1.13MC		 8-Jan-85
 * add -v option                		 8-Jan-85
 * allow for mixed case keys    V1.14MC		12-Jan-85
 * & flag functions with '()'   		12-Jan-85
 *
 *****************************************************************************
 */

#include <stdio.h>                              /* RSX-11M Std. I/O Def's */
#include "xrf.h"                                /* Global definitions */

int pageno;                                     /* Current listing page no. */


main ( argc, argv )
char *argv[];
   {                                            /* Start the main prog. */
   register int i;                      /* Arg count */
   register int c;                      /* Switch character code */
   register int f;			/* fnd -i sw */
   register char *p;                    /* Fast arg pointer */
   char *in_file;                       /* Source file name string */
   char *out_file;			/* Cref file name string */
   int splflg = 0;                      /* Spool file flag */
   int nofiles;				/* Flag "got a file" */
   char *klower();			/* make a max len lower case key*/
   char keystr[8+NCPS+NCPS+1];		/* constructed key hold */

   fprintf(stderr, "C program Cross Referencer from DECUSC\n");

   out_file = NULL;				/* No output file yet */
   lastsym[0]='\0';                             /* no prev symbol [XRF3] */
   date(thedate);				/* get date & time */
   time(thetime);

   for( i=1; i<argc; ++i )                      /* For each token */
      {
      p = argv[i];                              /* p --> i'th arg token */
      if( *p++ == '-' )                         /* if it's a switch token */
         {
         while( c = *p++ )                      /* Each char is a switch */
            switch(tolower(c))                  /* Process 'em */
               {
	       case 'o':			/* Output file */
		  argv[i] = 0;
		  if (++i >= argc)
			useage();
		  out_file = argv[i];
		  argv[i] = 0;
		  goto nextarg;

	       case 'n':			/* Narrow output */
		  linewidth=80;
		  break;

	       case 'i':			/* Large symbol size */
		  symbolsize=LCPS;
		  break;

               case 'p':                        /* Print source listing */
                  prnflg++;
                  break;

               case 'c':                       /* Concatanate source file(s) */
                  conflg++;
                  break;

               case 's':                        /* Spool listing */
                  splflg++;
                  break;

               case 'v':                        /* Verbose mode */
                  verbose++;
                  break;

               default :                        /* Bad switch, give help */
                  useage();
               }
	 argv[i] = 0;				/* Drop this one */
         }
nextarg:;
      }                                         /* Done with cmd string */
   if(conflg)					/* Set references */
      rperline=(linewidth-symbolsize-10-FFLAG)/RSIZE; /* with pname */
    else
      rperline=(linewidth-symbolsize-1-FFLAG)/RSIZE;  /* w/out pname */
   nofiles = 1;
   myfree();                                    /* Clear out storage */
   root = NULL;                                 /* No tree yet */

   for( i = 1; i < argc; i++){
      if ((in_file = argv[i]) == 0)continue;   /* no more filenames */
      initinfile(in_file);
      while (nextinfile()){
         if (nofiles){
 	   initoutfile(out_file);
           nofiles = 0;
	   }
         lineno = pageno = 0;                   /* Init. page & line number */
	 if(!conflg){                           /* if NO concatanation ... /*
           myfree();                               /* Clear out storage */
           root = NULL;                            /* No tree yet */
           lastsym[0]='\0';                        /* no prev symbol [XRF3] */
           }
         if(prnflg)newpage();                   /* Start first page */
         while(fgets(scanbf, LWIDTH, src) != NULL) /* Get a line of source */
            {
            ++lineno;                           /* Increment line number */
            scanp = scanbf;                     /* Reset scan pointer */
            while(getid()){                      /* scanp --> id or NULL */
               concat(keystr,klower(idbuf),idbuf,progname,0);/*construct key*/
               root = search(keystr, root);      /* Process identifier */
               }                                /* Till done with this line */
            if(prnflg)lstline();                /* List this line */
            }                                   /* Till end of source file */
         if(conflg) strcpy(scanbf, "listing: ");
             else   concat(scanbf, "list of: ",progname," ",0);
         concat(pghead, "\fCross Reference ",scanbf,
                   		"\t",thedate," ",thetime,"\tPage ", 0);
         if(!conflg){                        /* process if NOT concat */
             newpage();                         /* Start index on new page */
             prtree(root);                      /* Print the index */
             }
          }
      }
   if(conflg){                                /* process now if concat */
         newpage();                             /* Start index on new page */
         prtree(root);                          /* Print the index */
         }
   if (nofiles)useage();
      else if(splflg)fspool(lst);               /* If we're to spool, */
   exit();                                      /* Exit closing files */
   }                                            /***** END MAIN *****/



/* make a fixed length [CPS] lower case key from .. */
/* ... mixed case variable length  key*/
/* lose function marker */
static char ktemp[NCPS+1];

char *klower(c1)
char *c1;
{  int i=0;
   while(*c1)
     if(*c1!='('&&*c1!=')')ktemp[i++]=tolower(*c1++); /* move in key as LC */
      else c1++;				/* unless procid    */
   while(i<CPS)ktemp[i++]=' ';			/* add trail spaces */
   ktemp[i]='\0';				/* add terminator */
   return ktemp;
}


/*********************************************************/
/* Listing control routines. Newpage also used by prtree.*/
/*********************************************************/

newpage()                                       /* Start new page */
   {
   ++pageno;                                    /* Increment page number */
   linpg = 0;                                   /* Reset line-in-page count */
   fprintf(lst,"%s%d\n\n", pghead, pageno);     /* Output page heading */
   }

lstline()                                       /* Write listing line out */
   {
   if(++linpg > MAXLIN)
      newpage();
   fprintf(lst, "%4d:\t%s", lineno, scanbf);
   }
