/*
==============================================================================
		      WordUp Graphics Toolkit Version 5.0
			     Demonstration Program 9                          
									      
  Shows how the block functions work.
									      
  *** PROJECT ***                                 
  This program requires the file WGT5_WC.LIB to be linked.                    
									      
  *** DATA FILES ***                                                          
  NONE                                                                        
							   WATCOM C++ VERSION 
==============================================================================
*/

#include <wgt5.h>


void main(void)
{
  short i, x, y;
  short oldmode;
  color palette[256];
  block screen1;                  // a full screen
  block part1;                    // part of the screen

  printf ("WGT Example #9\n\n");
  printf ("This program will use wnewblock to grab a bitmap from the screen.\n");
  printf ("A small bitmap will be randomly pasted onto the screen until you press\n");
  printf ("a key. The original screen is then restored. Press a key to end the program.\n");
  printf ("\n\nPress any key to continue.\n");
  getch ();

  if ( !vgadetected () )
  {
    printf("Error - VGA card required for any WGT program.\n");
    exit (0);
  }
  oldmode = wgetmode ();
  vga256 ();

  for (i = 1; i < 200; i++)
  {
    wsetcolor (i);
    wline (0, 0, 319, i);
    wline (319, 199, 0, 199-i);
  }

  screen1 = wnewblock (0, 0, 319, 199);     /* capture the entire screen */
  part1 = wnewblock (0, 0, 150, 150);       /* get a part of the screen */
  /* Note that wnewblock allocates the memory for the block */

  wcls (0);

  do {
    x = rand() % 320;
    y = rand() % 200;
    wputblock (x, y, part1, 0);             /* put the part somewhere */
  } while (!kbhit ());

  getch ();
  wputblock (0, 0, screen1, 0);             /* replace the mess with the */
					    /* original screen */
  getch ();                                 /* get the key */
  wfreeblock (screen1);     /* *** make sure to free the memory! */
  wfreeblock (part1);

  wsetmode (oldmode);
}
