/*
==============================================================================
		      WordUp Graphics Toolkit Version 4.5
			     Demonstration Program 52

  A full FLI/FLC animation player. Allows filenames with wildcards and a
  selection of memory or disk playback. Resolution of the animation is
  obtained from the FLIC.  If the flic is larger than the visual screen,
  the animation will only show the top left corner.

  If the flic is too large (ie 640x480), the program will quit without
  any error messages.

  *** PROJECT ***
  This program requires the WGT45.LIB, WGTVESA.LIB, and WGTFLIC.LIB files to be linked.

  *** DATA FILES ***
  Any FLI or FLC file (or files).
==============================================================================
*/

#include <dos.h>
#include <stdlib.h>
#include <stdio.h>
#include <io.h>
#include <wgt45.h>
#include <wgtflic.h>
#include <wgtvesa.h>

#define ESC             27              /* ESCAPE KEY */

char         ch;                        /* Keyboard input */
int          playmode;                  /* Memory or disk playback */
int          filefound;                 /* 1 if the animation file was found */
int          oldmode;                   /* Previous video mode */
int          status;                    /* Status of FLI/FLC */
int          flic_mode;
int          video_mode;
block 	     flicbuffer;


long filesize (char *filename)
/* Return the length of a file */
{
FILE *tempfile;
long length;

  tempfile = fopen (filename, "rb");
  if (tempfile != NULL)
    {
     length = filelength (fileno (tempfile));
     fclose (tempfile);
     return length;
    }
 return 0; /* file not found */
}


void main (int argc, char *argv[])
{
  unsigned totl;

  if ((argc < 2) || (argc > 5))         /* Display how to use this program */
  {
    printf ("\nWGT52 - Plays FLI and FLC files from either memory or disk\n");
    printf ("USAGE:   PLAYFLIC filename [play_mode] [video_mode] [speed]\n");
    printf ("play_mode can be:\n");
    printf (" 0 - Play from disk (default)\n");
    printf (" 1 - Play from EMS\n");

    printf ("video_mode can be:\n");
    printf (" 0 - 640x350\n");
    printf (" 1 - 640x400\n");
    printf (" 2 - 640x480\n");
    printf (" 3 - 800x600\n");
    printf (" 4 - 1024x768\n");
    printf (" 5 - 1280x1024\n");
    printf (" 6 - 1600x1200\n");
    printf ("\n320x200 will be used if this parameter is left out.\n");
    printf ("\nSpeed can range from 0 to 9. \n");

    printf ("\nPress any key\n");

    getch ();
    exit (1);
  }

  if (argc > 2)
    flic_mode = atoi (argv[2]);         /* Get playmode from command line */
  else flic_mode = FLIC_DISK;           /* Or default to disk */

  if (argc > 3)
    video_mode = atoi (argv[3]);         /* Get video_mode from command line */
  else video_mode = -1;                  /* Or default to 320x200 */
  
  if (flic_mode > 1)
    flic_mode = FLIC_DISK;

  if (video_mode >= 0)
    {
     if (wvesa_detected ())        /* Look for VESA driver */
        printf ("SVGA detected.\n");
     else
       {
        printf ("SVGA support not found. Please check for VESA driver presence.\n");
        exit (1);
       }
    }

  if (flic_mode == FLIC_MEMORY)
    {                      /* Make sure EMS is present and working correctly */
     if (!wems_present ())
       {
	printf ("\n EMS not found!\n");
	exit (1);
       }
     if (!wems_init ())
       {
	printf ("\nEMS initialization error!\n");
	exit (1);
       }
    }

  oldmode = wgetmode ();                /* Preserve initial video mode */
  vga256 ();                            /* Go to graphics mode */

  if (video_mode >= 0)
    {
     switch (video_mode)
      {
       case 0: video_mode = V640x350; break;
       case 1: video_mode = V640x400; break;
       case 2: video_mode = V640x480; break;
       case 3: video_mode = V800x600; break;
       case 4: video_mode = V1024x768; break;
       case 5: video_mode = V1280x1024; break;
       case 6: video_mode = V1600x1200; break;
      }

     if (!wvesa_supported (video_mode))
       {
        wsetmode (oldmode);
        printf ("Supported failed.\n");
        exit (-1);
       }

     if (!wvesa_getmodeinfo (video_mode))
       {
        wsetmode (oldmode);
        printf ("Getmodeinfo failed.\n");
        exit (-1);
       }

     if (!wvesa_init (video_mode))
       {
        wsetmode (oldmode);
        printf ("Unable to initialize graphics mode.\n");
        exit (1);
       }
   }

   if (!wems_open (filesize (argv[1]) / 16384L + 4))
   /* Allocate FLI/FLC memory buffer, add 4 pages to allow for remainder */
     {
      wsetmode (oldmode);
      printf ("\nNot enough EMS memory to load this animation!\n");
      exit (1);
     }

  if (openflic (argv[1], flic_mode, 1) == FLIC_OK) /* See if we opened file ok */
   {
    flicbuffer = wallocblock (flichdr.width, flichdr.height);
    flicscreen = flicbuffer;              /* Set to visual screen */

    if (argc > 4)
      flichdr.speed = atoi (argv[4]);         /* Get playmode from command line */


    do {
      status = nextframe ();                  /* Show frame of animation */
      if ((status != FLIC_OK) && (status != FLIC_DONE))
	break;                                /* Abort if error */
//      delay (flichdr.speed);                  /* Delay proper amount */

      wnormscreen ();
      if (video_mode >= 0)
        wvesa_putblock (0, 0, flicbuffer, 0);
      else
        wputblock (0, 0, flicbuffer, 0);

    } while (!kbhit ());                      /* Continue until keypress */
   }
  /* NOTE: If you don't want the flic to loop, remove the check for
	   FLIC_DONE. This will abort playback when the animation is done */

  while (kbhit())                             /* Get key from buffer */
    ch = getch ();

  closeflic ();                               /* Close current animation */
  wems_close ();				/* Free the EMS memory */

  wsetmode (oldmode);                           /* and video mode */
}
