/*
ͻ
                     WordUp Graphics Toolkit Version 4.5                    
                            Demonstration Program 11                        
                                                                            
Shows the use of wgetblockwidth and wgetblockheight, and demonstrates       
the resize procedure.                                                       
                                                                            
  PROJECT                                                             
 This program requires the file WGT45.LIB to be linked.          	     
                                                                            
  DATA FILES                                                          
 WGT1.BLK, WGT1.PAL                                                         
                                                                            
ͼ
*/

#include <wgt45.h>


#define TIMERSPEED 60
int timer;
int size;
int direction = -1;

void far timer_routine (void)
{
  timer++;
}


void main(void)
{
short i, x, y;
short oldmode;
block part1;                    /* part of the screen */
color pal[256];

  printf ("WGT Example #11\n\n");
  printf ("This program will load a bitmap from a file and display it on the screen.\n");
  printf ("It will then switch back to text mode and display how big the picture is.\n");
  printf ("Graphics mode is entered and the image is resized until a key is\n");
  printf ("pressed.\n");
  printf ("\n\nPress any key to continue.\n");
  getch ();

  if (!vgadetected ())
    {
     printf ("Error - VGA card required for any WGT program.\n");
     exit (0);
    }

  oldmode = wgetmode ();
  vga256 ();

  part1 = wloadblock ("wgt1.blk");
  wloadpalette ("wgt1.pal", pal);
  wsetpalette (0, 255, pal);

  wnormscreen ();
  wputblock (0, 0, part1, 0);


  getch ();
  wcls (0);
  x = wgetblockwidth (part1);
  y = wgetblockheight (part1);

  wsetmode (oldmode);               
  printf ("Block width : %i\n",x);  
  printf ("Block height: %i\n",y);
  printf ("Block size is %u bytes.",x*y+4);  /* Add 4 bytes for width and height */
  printf ("\nPress any key to resize...\n");
  getch ();
  vga256 ();
  wsetpalette (0, 255, pal);

  timer = 0;
  size = 50;
  winittimer ();
  wstarttimer (timer_routine, TIMERSPEED);

  wclip (0, 0, 319, 199);
  do {
    if (direction > 0)
      {
       size += timer * 2;
       timer = 0;
       if (size > 50)
         direction = -1;
      }   
    else 
      {
       size -= timer * 2;
       timer = 0;
       if (size < -1000)
         direction = 1;
      }   

    wresize (size, size, 319 - size, 199 - size, part1, NORMAL);
  
  } while (!kbhit ());
  getch ();

  wstoptimer (); 
  wdonetimer ();

  wfreeblock (part1);
  wsetmode (oldmode);
}


