/* gaussjordan4.c                   freeware                   xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
AB()
{
fraction InnerProduv;

double pbU1 [MXR][MXC*TWOCOL];matrix mU1={MXR,MXC*TWOCOL,&pbU1[0][0]};
double pbU2 [MXR][MXC*TWOCOL];matrix mU2={MXR,MXC*TWOCOL,&pbU2[0][0]};
double pbU3 [MXR][MXC*TWOCOL];matrix mU3={MXR,MXC*TWOCOL,&pbU3[0][0]};
double pbU4 [MXR][MXC*TWOCOL];matrix mU4={MXR,MXC*TWOCOL,&pbU4[0][0]};

double pbV1 [MXR][MXC*TWOCOL];matrix mV1={MXR,MXC*TWOCOL,&pbV1[0][0]};
double pbV2 [MXR][MXC*TWOCOL];matrix mV2={MXR,MXC*TWOCOL,&pbV2[0][0]};
double pbV3 [MXR][MXC*TWOCOL];matrix mV3={MXR,MXC*TWOCOL,&pbV3[0][0]};
double pbV4 [MXR][MXC*TWOCOL];matrix mV4={MXR,MXC*TWOCOL,&pbV4[0][0]};

double pvaT[MXR][MXC*TWOCOL];matrix mvaT={MXR,MXC*TWOCOL,&pvaT[0][0]};
double pvbT[MXR][MXC*TWOCOL];matrix mvbT={MXR,MXC*TWOCOL,&pvbT[0][0]};
double pvcT[MXR][MXC*TWOCOL];matrix mvcT={MXR,MXC*TWOCOL,&pvcT[0][0]};

    mU1.rows = 3;           mU1.cols = 2*TWOCOL;
    mU2.rows = 3;           mU2.cols = 2*TWOCOL;
    mU3.rows = 3;           mU3.cols = 2*TWOCOL;
    mU4.rows = 3;           mU4.cols = 2*TWOCOL;

    mV1.rows = 3;           mV1.cols = 2*TWOCOL;
    mV2.rows = 3;           mV2.cols = 2*TWOCOL;
    mV3.rows = 3;           mV3.cols = 2*TWOCOL;
    mV4.rows = 3;           mV4.cols = 2*TWOCOL;

   mvaT.rows = 3;          mvaT.cols = 2*TWOCOL;
   mvbT.rows = 3;          mvbT.cols = 2*TWOCOL;
   mvcT.rows = 3;          mvcT.cols = 2*TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */
  rndmF(&mU1,2,1);
  rndmF(&mU2,2,1);
  rndmF(&mU3,2,1);
  rndmF(&mU4,2,1);

   clrscrn();
   printf(" Consider these vectors generated randomly by the computer\n");
   printmF(&mU1);
   printmF(&mU2);
   printmF(&mU3);
   printmF(&mU4);

   printf("\n");
   InnerProduv = innerprod_Mnm(&mU1,&mU2);
   printf("   <U1,U2> = %4.0lf/%-.0lf ",InnerProduv.numer,InnerProduv.denom);
   InnerProduv = innerprod_Mnm(&mU1,&mU3);
   printf("   <U1,U3> = %4.0lf/%-.0lf ",InnerProduv.numer,InnerProduv.denom);
   InnerProduv = innerprod_Mnm(&mU1,&mU4);
   printf("   <U1,U4> = %4.0lf/%-.0lf \n",InnerProduv.numer,InnerProduv.denom);
   InnerProduv = innerprod_Mnm(&mU2,&mU3);
   printf("   <U2,U3> = %4.0lf/%-.0lf ",InnerProduv.numer,InnerProduv.denom);
   InnerProduv = innerprod_Mnm(&mU2,&mU4);
   printf("   <U2,U4> = %4.0lf/%-.0lf \n",InnerProduv.numer,InnerProduv.denom);
   InnerProduv = innerprod_Mnm(&mU3,&mU4);
   printf("   <U3,U4> = %4.0lf/%-.0lf \n",InnerProduv.numer,InnerProduv.denom);
   getchar();

   clrscrn();

        copymF(&mU1,&mV1);         /*v1*/

    projwn_Mnm(&mU2,&mV1, &mvbT);
         submF(&mU2,&mvbT,&mV2);   /*v2*/

    projwn_Mnm(&mU3,&mV1, &mvbT);
         submF(&mU3,&mvbT,&mvaT);
    projwn_Mnm(&mU3,&mV2, &mvbT);
         submF(&mvaT,&mvbT,&mV3);  /*v3*/

    projwn_Mnm(&mU4,&mV1, &mvbT);
         submF(&mU4,&mvbT,&mvaT);
    projwn_Mnm(&mU4,&mV2, &mvbT);
         submF(&mvaT,&mvbT,&mvcT);
    projwn_Mnm(&mU4,&mV3, &mvbT);
         submF(&mvcT,&mvbT,&mV4);  /*v4*/

   printf("\n If these vectors are linear independent,");
   printf("\n and if we apply the Gram-Schmidt process on them,");
   printf("\n we obtain these orthogonal vectors.\n");
   getchar();

   clrscrn();
   printf("\n If V2 or V3 or V4 = 0 : U1,U2,U3,U4 are linear dependent.\n");
   printmF(&mV1);
   printmF(&mV2);
   printmF(&mV3);
   printmF(&mV4);

   InnerProduv = innerprod_Mnm(&mV1,&mV2);
   printf("\n   <V1,V2> = %.0lf/%-.0lf ",InnerProduv.numer,InnerProduv.denom);
   InnerProduv = innerprod_Mnm(&mV1,&mV3);
   printf("   <V1,V3> = %.0lf/%-.0lf ",InnerProduv.numer,InnerProduv.denom);
   InnerProduv = innerprod_Mnm(&mV1,&mV4);
   printf("   <V1,V4> = %.0lf/%-.0lf \n",InnerProduv.numer,InnerProduv.denom);
   InnerProduv = innerprod_Mnm(&mV2,&mV3);
   printf("   <V2,V3> = %.0lf/%-.0lf ",InnerProduv.numer,InnerProduv.denom);
   InnerProduv = innerprod_Mnm(&mV2,&mV4);
   printf("   <V2,V4> = %.0lf/%-.0lf \n",InnerProduv.numer,InnerProduv.denom);
   InnerProduv = innerprod_Mnm(&mV3,&mV4);
   printf("   <V3,V4> = %.0lf/%-.0lf ",InnerProduv.numer,InnerProduv.denom);
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.  ");
  printf("\n\n\n\n                                          \n");
  printf("          The Gram-Schmidt process,               \n");
  printf("        with  the inner product in M3x2           \n");
  printf("        *******************************             ");
  printf("\n\n\n \n\n\n\n\n\n\n\n                             ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press return to continue                         ");
  printf("\n                                                  ");
  getchar();
}


/* --------------------------------- MAIN ----------------------------------- */
int main()
{
time_t t;
/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{


  AB();


  printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}


