/* .c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
AB()
{
double pbT[3][3*TWOCOL]=
{
   1,1,   0,1,   2,1,
   0,1,   1,1,   0,1,
   0,1,   0,1,   1,1,
};
matrix mT={3,3*TWOCOL,&pbT[0][0]};

double pbABC[3][4*TWOCOL]=
{
  2,1,   6,1,   7,1,   2,1,
  2,1,   5,1,   3,1,   2,1,
  1,1,   1,1,   1,1,   1,1,
};
matrix mABC={3,4*TWOCOL,&pbABC[0][0]};

double pbT_ABC[3][4*TWOCOL];matrix mT_ABC={3,4*TWOCOL,&pbT_ABC[0][0]};
/*-------------------------------- PROGRAM ---------------------------------- */
  clrscrn();
  printf("\n                                              T");
  printmF3(&mT);

  printf("\n\n                                          ABC");
  printmF3(&mABC);
  gnpltvectcol2d("u",&mABC);

  multmF(&mT,&mABC,&mT_ABC);
  printf("\n\n                                        T(ABC)");
  printmF3(&mT_ABC);
  gnpltvectcol2d("v",&mT_ABC);
  gnpltaxis(     "aa2d.plt");

  printf("\n\n To see the result in Gnuplot (gp373w32.exe) :           \n\n");
  printf("  * open the file aa2d.plt with Gnuplot. Gnuplot draw ABC and T(ABC)\n");
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.  ");
  printf("\n\n\n                                              ");
  printf("\n       Horizontal shift (right) c > 0 :           ");
  printf("\n       ******************************             ");
  printf("\n\n                                                ");
  printf("\n\n                                                ");
  printf("\n                | 1  0  c |                       ");
  printf("\n      T(ABC)  = | 0  1  0 |  ABC                  ");
  printf("\n                | 0  0  1 |                       ");
  printf("\n\n\n\n\n                                          ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press return to continue                        \n");
  getchar();
}


/* --------------------------------- MAIN ----------------------------------- */
int main()
{
/*-------------------------------- PROGRAM ---------------------------------- */
  hello();

  AB();


  printf("\n Press Return to stop\n");
  getchar();

  return 0;
}












