/* .c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
AB(
int n,
int vectrow)
{
fraction Norm_uplsv;
fraction Norm_u;
fraction Norm_v;
fraction Norm_u_pls_v;

double pbu    [MXR][MXC*TWOCOL];matrix mu    ={MXR,MXC*TWOCOL,&pbu    [0][0]};
double pbv    [MXR][MXC*TWOCOL];matrix mv    ={MXR,MXC*TWOCOL,&pbv    [0][0]};
double puplsv [MXR][MXC*TWOCOL];matrix muplsv={MXR, MXC*TWOCOL,&puplsv[0][0]};

if     (vectrow)
  {
           mu.rows = 1;           mu.cols = n*TWOCOL;
           mv.rows = 1;           mv.cols = n*TWOCOL;
       muplsv.rows = 1;       muplsv.cols = n*TWOCOL;
  }
else if(!vectrow)
   {
           mu.rows = n;           mu.cols = 1*TWOCOL;
           mv.rows = n;           mv.cols = 1*TWOCOL;
       muplsv.rows = n;       muplsv.cols = 1*TWOCOL;
   }
/*-------------------------------- PROGRAM ---------------------------------- */
  clrscrn();

  rndv_uDv0F(&mu,&mv,5,3);
  printf("                                 u");
  printmF3(&mu);
  printf("                                 v");
  printmF3(&mv);

  addmF(&mu,&mv,&muplsv);
  printf("\n\n                             u + v");
  printmF3(&muplsv);

  Norm_uplsv = normP2(&muplsv);               /* It is the square of the norm.*/

  printf("\n\n\n         ||u + v||**2 = %.0lf/%-.0lf\n\n",
            Norm_uplsv.numer,
            Norm_uplsv.denom);
  getchar();

  clrscrn();

  printf("                                 u");
  printmF3(&mu);
  printf("                                 v");
  printmF3(&mv);

  Norm_u = normP2(&mu);                       /* It is the square of the norm.*/
  Norm_v = normP2(&mv);

  printf("\n\n\n  ||u||**2 = %.0lf/%-.0lf    ||v||**2 = %.0lf/%-.0lf\n\n",
            Norm_u.numer,
            Norm_u.denom,
            Norm_v.numer,
            Norm_v.denom);

  Norm_u_pls_v = addF(Norm_u,Norm_v);

  printf("\n  ||u||**2 + ||v||**2 = %.0lf/%-.0lf \n\n",
            Norm_u_pls_v.numer,
            Norm_u_pls_v.denom);
  getchar();

  clrscrn();
  printf("\n    If u and v are orthogonal in R**n     ");
  printf("\n    with the Euclidean inner product :\n\n\n");
  printf("          ||u+v||**2  =  ||u||**2 + ||v||**2\n\n\n");
  printf("         ||u + v||**2 = %.0lf/%-.0lf\n\n\n",
            Norm_uplsv.numer,
            Norm_uplsv.denom);

  printf("  ||u||**2 + ||v||**2 = %.0lf/%-.0lf \n\n ",
            Norm_u_pls_v.numer,
            Norm_u_pls_v.denom);

}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.  ");
  printf("\n\n                                                ");
  printf("\n     If u and v are orthogonal in R**n            ");
  printf("\n     with the Euclidean inner product :           ");
  printf("\n                                                  ");
  printf("\n     ||u+v||**2  =  ||u||**2 + ||v||**2           ");
  printf("\n     **********************************           ");
  printf("\n\n\n                                              ");
  printf("\n The size of u, v : 2x1 ... 4x1.                \n");
  printf("\n     ex : \"pythgCF.exe\"                       \n");
  printf("\n You can choose the size :                      \n");
  printf("\n     ex : \"pythgCF.exe 2\" -> 2x1                ");
  printf("\n          \"pythgCF.exe 4\" -> 4x1              \n");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press a key to continue                          ");
  printf("\n                                                  ");
  getchar();
}


/* --------------------------------- MAIN ----------------------------------- */
int main(int argc, char *argv[])
{
time_t t;
int    n;
int    vectrow = 1;
/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{
if( argc == 2 && atoi(argv[1]) )
 {n = atoi(argv[1]); if( n > 5){n=5;}}
else
 {    n=rndpI(5);}
   if(n<2){n=2;}

if     ( vectrow){vectrow = 0;}
else if(!vectrow){vectrow = 1;}


  AB(n,vectrow);


  printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}












