/* .c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
AB(
int n,
int vectrow)
{
fraction InnerProduct_uu;

double pbu    [MXR][MXC*TWOCOL];matrix mu    ={MXR,MXC*TWOCOL,&pbu    [0][0]};

if     (vectrow)
  {
           mu.rows = 1;           mu.cols = n*TWOCOL;
  }
else if(!vectrow)
   {
           mu.rows = n;           mu.cols = 1*TWOCOL;
   }
/*-------------------------------- PROGRAM ---------------------------------- */
  rndmF(&mu,5,3);

  clrscrn();
  printf("                                 u");
  printmF3(&mu);
  InnerProduct_uu = innerprod(&mu,&mu);
  printf("\n  Properties of Euclidian inner product in R**n   ");
  printf("\n\n     u.u  >=  0              \n\n");
  printf("\n\n     u.u   =  %6.0lf/%-6.0lf \n\n\n",
            InnerProduct_uu.numer,
            InnerProduct_uu.denom);
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.  ");
  printf("\n\n                                                ");
  printf("\n  Properties of Euclidian inner product in R**n   ");
  printf("\n                                                  ");
  printf("\n                u.u  >=  0                        ");
  printf("\n                **********                        ");
  printf("\n\n\n                                              ");
  printf("\n The size of u, v : 2x1 ... 4x1.                \n");
  printf("\n     ex : \"euinprddCF.exe\"                    \n");
  printf("\n You can choose the size :                      \n");
  printf("\n     ex : \"euinprddCF.exe 2\" -> 2x1             ");
  printf("\n          \"euinprddCF.exe 4\" -> 4x1           \n");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press a key to continue                          ");
  printf("\n                                                  ");
  getchar();
}


/* --------------------------------- MAIN ----------------------------------- */
int main(int argc, char *argv[])
{
time_t t;
int    n;
int    vectrow = 1;
/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{
if( argc == 2 && atoi(argv[1]) )
 {n = atoi(argv[1]); if( n > 5){n=5;}}
else
 {    n=rndpI(5);}
   if(n<2){n=2;}

if     ( vectrow){vectrow = 0;}
else if(!vectrow){vectrow = 1;}


  AB(n,vectrow);


  printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}












