/*
   This Microsoft C program is used by TechniLib to test TXMS.  It is
included as a simple demonstration of TXMS programming.  The program was
designed for the large memory model.
*/

#include <stdio.h>
#include <txms.h>

typedef unsigned int uint;
typedef unsigned long ulong;

ulong dosmemory[1024];    //4K conventional memory for testing transfers

void main(void)
{
  uint errcode, freemem, maxfreeblock;
  uint handle1, handle2;
  ulong i;

/*
.............................................................................
Initialize TXMS
.............................................................................
*/

  if(errcode = initxms())
  {
    printf("Initialization error: %X\n",errcode);
    exit(1);
  }

/*
.............................................................................
Get amount of free XMS memory and size of largest available block
.............................................................................
*/

  if(errcode = getfreexmsmem(&freemem,&maxfreeblock))
  {
    printf("Memory measurement error: %X\n",errcode);
    exit(1);
  }

  printf("Free XMS memory:         %5u kilobytes\n",freemem);
  printf("Largest free XMS block:  %5u kilobytes\n",maxfreeblock);


/*
.............................................................................
Allocate 2 XMS blocks, each having 4K bytes (disregard measurments above)
.............................................................................
*/

  if(errcode = getxmsmem(4, &handle1))
  {
    printf("Memory allocation error: %X\n",errcode);
    exit(1);
  }


  if(errcode = getxmsmem(4, &handle2))
  {
    printf("Memory allocation error: %X\n",errcode);
    exit(1);
  }

/*
.............................................................................
Initialize dosmemory to 0,1,2,,, and then transfer to first XMS block
.............................................................................
*/

  for(i = 0; i < 1024; i++)
    dosmemory[i] = i;

  if(errcode = movexmsmem(4096, 0, (ulong)&dosmemory, handle1, 0))
    printf("Error transferring conventional to extended: %X\n",errcode);

/*
.............................................................................
Transfer first XMS block to second XMS block
.............................................................................
*/

  if(errcode = movexmsmem(4096, handle1, 0, handle2, 0))
    printf("Error transferring within extended: %X\n",errcode);

/*
.............................................................................
Transfer second XMS block back to dosmemory and verify contents
.............................................................................
*/

  for(i = 0; i < 1024; i++)
    dosmemory[i] = 0;

  if(errcode = movexmsmem(4096, handle2, 0, 0, (ulong)&dosmemory))
    printf("Error transferring extended to conventional 1: %X\n",errcode);

  for(i = 0; i < 1024; i++)
  {
    if(dosmemory[i] != i)
    {
      errcode = 1;
      break;
    }
  }
  if(errcode)
    printf("Error: Invalid memory transfer 1\n");

/*
.............................................................................
Transfer fraction of first XMS block to dosmemory and verify contents
.............................................................................
*/

  for(i = 0; i < 1024; i++)
    dosmemory[i] = 0;

  if(errcode = movexmsmem(2048, handle1, 2048, 0, (ulong)&dosmemory))
    printf("Error transferring extended to conventional 1: %X\n",errcode);

  for(i = 0; i < 512; i++)
  {
    if(dosmemory[i] != i + 512)
    {
      errcode = 1;
      break;
    }
  }
  if(errcode)
    printf("Error: Invalid memory transfer 2\n");

/*
.............................................................................
Release XMS memory blocks
.............................................................................
*/

  if(errcode = freexmsmem(handle1))
    printf("Memory release error: %X\n",errcode);

  if(errcode = freexmsmem(handle2))
    printf("Memory release error: %X\n",errcode);


}
