/* unPACK v1.00

v1.00 - 32bit version to extract from PAK files only
Note : Can not extract from PAH files.

*/

#include <qlib.h>
#include <dos.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include "misc.h"

void cleanup(void) {}

struct bufs{
  byte fn[13];  //0-12
  word fh;      //always 0
  dword off;    //offset
  dword siz;    //size of file
} sample;

struct bufs *buf;

dword coff;  //current offset
dword siz;
int hi,hihdr,ho,t;
byte str[80];
byte *tbuf;
dword a;
word cnt;
dword head1=0x1a4b4150;   //"PAK",26
dword head2=0x1a484150;   //"PAH",26
byte fi[80];
byte fihdr[80];
dword d1;
word w1;
word nof;
byte mode;

void main(byte argc,byte **args) {

  dword siz;

  if (argc<2 || argc>3) {
    printf(" unPACK v1.00 (32bit) by : Peter Quiring\n");
    printf(" Usage: unPACK filein[.PAK] [header_filein]\n");
    exit(0);
  }

  buf=(void*)GetRam(sizeof(sample)*65000);
  tbuf=GetRam(bufsiz);

  strcpy(fi,args[1]);
  strupr(fi);

  if (argc==2) mode=0;
  else {
    mode=1;
    strcpy(fihdr,args[2]);
    strupr(fihdr);
  }

  hi=open(fi,O_BINARY | O_RDONLY);
  if (hi==-1) {
    strcat(fi,".PAK");
    hi=open(fi,O_BINARY | O_RDONLY);
    if (hi==-1) error("Unable to open PAK file");
  }

  hihdr=open(fihdr,O_BINARY | O_RDONLY);
  if (hi==-1) error("Unable to open header file");

  read(hi,&d1,4);
  if (d1==head1) {
    if (mode==1) error("File is PAK, no header file required");
  } else
  if (d1==head2) {
    if (mode==0) error("Header file required for PAH files");
  } else error("File type unknown");

  nof=0;
  if (mode==0) {
    read(hi,&nof,2);
    coff=6;
  } else {
    read(hihdr,&nof,2);
    //coff not needed
  }

  if (!nof) error("No files within file");

  printf("Extracting files...\n");
  while (nof) {
    //get name/offset
    if (mode==0) {
      lseek(hi,coff,SEEK_SET);
      coff+=sizeof(sample);
      read(hi,&sample,sizeof(sample));
    } else {
      read(hihdr,&sample,sizeof(sample));
    }
    lseek(hi,sample.off,SEEK_SET);
    printf("Extracting %s...",sample.fn);
    t=open(sample.fn,O_BINARY | O_CREAT | O_TRUNC | O_WRONLY, S_IWRITE);
    if (t==-1) error("Unable to creat file");
    while (sample.siz) {
      if (sample.siz > bufsiz) a=read(hi,buf,bufsiz);
        else a=read(hi,buf,sample.siz);
      if (a) write(t,buf,a);
      sample.siz-=a;
    }
    printf("\n");
    close(t);
    nof--;
  }

  close(hi);
  close(hihdr);
  printf("\nComplete!\n");
}
