include src\qlib.inc
include dpmi.inc

.code

;this converts a physical addr into a linear addr
_DPMI_phys_alloc proc,loc:dword,siz:dword
  .if (!siz) || (!loc)
    mov eax,NULL
    ret
  .endif
  pushad
  mov ax,800h
  mov ebx,loc
  mov cx,bx
  shr ebx,16    ;bx:cx
  mov esi,siz
  mov di,si
  shr esi,16    ;si:di
  int 31h
  .if carry?
    popad
    mov eax,NULL
    ret
  .endif
  shl ebx,16
  mov bx,cx
  mov [esp+7*4],ebx  ;save EAX for return
  popad
  ret
_DPMI_phys_alloc endp

_DPMI_phys_free proc,lin:dword
  pushad   ;FIX : v2.00 Beta #5
  mov ax,801h
  mov ebx,lin
  mov cx,bx
  shr ebx,16     ;bx:cx
  int 31h
  popad
  .if carry?
    mov eax,ERROR
    ret
  .endif
  xor eax,eax
  ret
_DPMI_phys_free endp

_endseg

end



