include src\qlib.inc
include process.inc

;_c_exit is in c0.asm

  atexit_siz equ 32    ;# of atexit()'s that can be called

.data
  _atexit_entries dd atexit_siz dup (0)  ;procs to call to uninit stuff

.code
_cexit proc
;FIX : v2.11 b4 : go in reverse order
  pushad
  mov eax,offset _atexit_entries + (atexit_siz*4) - 4
  mov ecx,atexit_siz
@@:
  mov ebx,[eax]
  .if ebx
    push eax
    push ecx
    call ebx
    pop ecx
    pop eax
  .endif
  sub eax,4
  dec ecx
  jnz @b
  call _c_exit
  popad
  ret
_cexit endp

atexit proc uses ecx,a:dword
  mov eax,offset _atexit_entries
  mov ecx,atexit_siz
@@:
  .if !dptr[eax]
    mov ecx,a
    mov [eax],ecx
    xor eax,eax
    ret
  .endif
  add eax,4
  dec ecx
  jnz @b
  mov eax,ERROR
  ret
atexit endp

exit proc,el:byte
  mov ds,cs:seldata
  mov es,seldata
  mov fs,seldata
  mov gs,seldata

  call _cexit  ;this will uninit everything

  callp _dos_exit,el
exit endp

_exit proc,el:byte
  ;NOTE : This is _NOT_ the same as exit()
  ;This does not call _cexit()

  mov ds,cs:seldata
  mov es,seldata
  mov fs,seldata
  mov gs,seldata

  call _c_exit  ;this will uninit c0 stuff only

  callp _dos_exit,el
_exit endp

_dos_exit proc,el:byte
  mov al,el
  mov ah,4ch
  int 21h
_dos_exit endp

_endseg

end

