#ifndef __LEFILE_H_
#define __LEFILE_H_

#include <qlib.h>

#define LE_MAGIC 0x454C

struct t_exehead
{
  word sig;
  word pagemod,pagecnt;
  word relocnt;
  word hdrsize;
  word minmem,maxmem;
  word reloss,exesp;
  word chksum;
  word exeip,relocs;
  word reltabofs,ovrnum;
};

struct t_lehead
{
  dword sig,                 // must be 0x454C since order is little endian
        formatlevel;
  word  cputype,
        targetsystem;
  dword modversion,
        modtype,
        modpages;            // # of physical pages
  dword entrysection,
        entryoffset,
        stacksection,
        stackESP;
  dword pagesize,
        byteslastpage,
        fixupsize,
        fixupchecks;
  dword loadersize,loaderchecks;
  dword objecttable,objectentries;
  dword objectpmtable,iteratedata;
  dword resourcetable,numresources;
  dword rnamestable,entrytable,
        moduledirtab,moduledirs;
  dword fixuppagetab,fixuprecords,
        impmodpagetab,impmodentries,
        impprcpagetab,pchecksumtab;
  dword datapages,preloadpages,
        nresnamtable,nresnamlen,
        nresnamcrc,autodata,
        debugstart,debugsize,
        prelinstpages,demdinstpages,
        extraheap,reserved1,reserved2,reserved3;
};

struct t_objecttable
{
  dword virtualsize,
        relocbase,
        objectflags,
        pagemapindex,
        pagemapsize,
        reserved;
};

struct t_objpmtable
{
  byte unknown;
  word fixuptabidx;
  byte type;
};

#endif