/*  test485.c (01/22/99)
**
**  Test program for 2-wire RS485.              
**                                              
**  This program assumes that RTS controls the  
**  UART transmitter, as is typical in 2-wire   
**  RS-485 circuits. Note that in a 2-wire      
**  setup, all data is echoed back locally.     
**                                               
**  Execute this program from the DOS command   
**  line (boot to DOS in Windows).  
**
*/

#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <dos.h>
#include <string.h>
#include <conio.h>

#include "pcl4c.h"

#define FALSE 0
#define TRUE !FALSE

/*** Global Variables ***/

int Port = COM1;          /* Port COM1 */
int BaudCode;             /* baud rate code ( index into BaudRate[] ) */
char *BaudRate[10] =  {"0","300","1200","2400","4800","9600",
                       "19200","38400","57600","115200"};
char *UartString[4] = {"8250/16450", "16550", "16650", "16750"};
char RxBuffer[1024+16];
char TxBuffer[512+16];
char *Alpha = "ABCDEFGHIJKLMNOPQRSTUVWXYZ\r\n";

/*** local prototypes */

int BaudMatch(char *);
int ErrorCheck(int);

/*** main ***/

void main(int argc, char *argv[])
{char c;
 int  i, rc;
 char far *Ptr;
 int  Seg;
 if(argc!=3)
   {printf("Usage: RS485 <port> <baud>\n");
    exit(1);
   }
 /* get port number from command line */
 Port = atoi(argv[1]) - 1;
 if((Port<COM1) || (Port>COM20))
     {printf("Port must be COM1 to COM20\n");
      exit(1);
     }
 /* get baud rate from command line */
 BaudCode = BaudMatch(argv[2]);
 if(BaudCode<0)
     {printf("Cannot recognize baud rate = %s\n",argv[2]);
      exit(1);
     }
     
 /* setup 1024 byte receive buffer */
 Ptr = (char far *)RxBuffer;
 Seg = FP_SEG(Ptr) + ((FP_OFF(Ptr)+15)>>4);
 ErrorCheck( SioRxBuf(Port,Seg,Size1024) );
 /* setup 512 byte transmit buffer */
 Ptr = (char far *)TxBuffer;
 Seg = FP_SEG(Ptr) + ((FP_OFF(Ptr)+15)>>4);
 ErrorCheck( SioTxBuf(Port,Seg,Size512) );
 /* set port parmameters */
 ErrorCheck( SioParms(Port,NoParity,OneStopBit,WordLength8) );
 /* reset the port */
 ErrorCheck( SioReset(Port,BaudCode) );
 /* Set FIFO level */
 i = SioFIFO(Port,LEVEL_4TH);
 printf("[%s]\n",UartString[i]);
 if(SioInfo('I')) printf("TX interrupts are enabled.\n");
 else printf("TX interrupts are NOT enabled.\n");
 printf("\nEnter terminal loop ( Type ^Z to exit )\n");
 /* enter terminal loop */
 while(TRUE)
     {if(SioBrkKey())
        {/* restore COM port status & exit */
         printf("BREAK\n");
         SioDone(Port);
         exit(2);
        }
      /* was key pressed ? */
      if(kbhit())
          {i = getch();
           if((char)i==0x1a)
             {/* restore COM port status & exit */
              SioDone(Port);
              exit(1);
             }
           else if((char)i=='#') 
             {/* set RTS */
              SioRTS(Port,'S');
              /* transmit Alphabet */
              SioPuts(Port,Alpha,28);
              /* wait till all data has been sent */
              SioEmpty(Port);
              /* clear (drop) RTS */
              SioRTS(Port,'C');
             }
           else if((char)i=='?') 
             {
              printf("[RTS=%d]",SioRTS(Port,'R'));
             }             
           else 
            {/* set RTS */
             SioRTS(Port,'S');
             /* send character */
             SioPutc(Port,(char)i);
             /* wait till all data has been sent */
             SioEmpty(Port);
             /* clear (drop) RTS */
             SioRTS(Port,'C');
            }
          } /* end if */
      /* any incoming over serial port ? */
      i = SioGetc(Port,0);
      if(i>-1) putch((char)i);
     } /* end while */
} /* end main */

int ErrorCheck(int Code)
{/* trap PCL error codes */
 if(Code<0)
     {printf("ERROR %d:",Code);
      SioError(Code);
      SioDone(Port);
      exit(1);
     }
 return(0);
} /* end ErrorCheck */


int BaudMatch(char *P)
{int i;
 /* find baud rate in table */
 for(i=0;i<10;i++) if(strcmp(BaudRate[i],P)==0) return(i);
 return(-1);
}

