/*===================================================================
 integral.c

 Version 1.0

 Written by:
   Brent Worden
   WordenWare
   email:  brent@worden.org

 Copyright (c) 2000-2001 WordenWare

 Created:  January 7, 2000
 Revised:  
===================================================================*/

#include <math.h>
#include "integral.h"
#include "numerror.h"

double trap(Function func, double a, double b, int n, double s)
{
	double ret;
	int it, j;
	double x, tnm, sum, del;

	if(n <= 1){
		ret = 0.5 * (b - a) * (func(a) + func(b));
	} else {
		for(it = 1, j = 1; j < n - 1; ++j){
			it <<= 1;
		}
		tnm = it;
		del = (b - a) / tnm;
		x = a + .5 * del;
		for(sum = 0.0, j = 1; j <= it; ++j, x += del){
			sum += func(x);
		}
		ret = .5 * (s + (b - a) * sum / tnm);
	}
	return ret;
}

NUMERICS_EXPORT double simpsons(Function func, double a, double b, double tol, int nmax)
{
	int j = 1;
	double y1, y2, yt1, yt2;

	yt1 = trap(func, a, b, j, 0);
	y1 = 4.0 * yt1 / 3.0;
	do {
		++j;
		yt2 = yt1;
		y2 = y1;
		yt1 = trap(func, a, b, j, yt1);
		y1 = (4.0 * yt1 - yt2) / 3.0;
	} while(j < nmax && (fabs(y1 - y2) > tol * fabs(y2)));

	if(j < nmax){
		return y1;
	} else {
		NUMERICS_ERROR("simpsons", "Failed to converge.");
		return 0.0;
	}
}

NUMERICS_EXPORT double trapezoid(Function func, double a, double b, double tol, int nmax)
{
	int j = 1;
	double y1, y2;

	y1 = trap(func, a, b, j, 0);
	do {
		++j;
		y2 = y1;
		y1 = trap(func, a, b, j, y1);
	} while(j < nmax && (fabs(y1 - y2) > tol * fabs(y2)));

	if(j < nmax){
		return y1;
	} else {
		NUMERICS_ERROR("trapizoid", "Failed to converge.");
		return 0.0;
	}
}

/*===================================================================
 Revision History

 Version 1.0 - 01/07/2000 - New.
===================================================================*/
