/* .c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xahfile.h"


/* --------------------------------- FUNCTION ------------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
AmnsB_BmnsA(int n)
{
fraction two;

double pbA       [MXR][MXC*TWOCOL];matrix mA        ={MXR,MXC*TWOCOL,&pbA       [0][0]};
double pbB       [MXR][MXC*TWOCOL];matrix mB        ={MXR,MXC*TWOCOL,&pbB       [0][0]};
double pbAmnsB   [MXR][MXC*TWOCOL];matrix mAmnsB    ={MXR,MXC*TWOCOL,&pbAmnsB   [0][0]};
double pbAmnsB_p2[MXR][MXC*TWOCOL];matrix mAmnsB_p2 ={MXR,MXC*TWOCOL,&pbAmnsB_p2[0][0]};
double pbA_p2    [MXR][MXC*TWOCOL];matrix mA_p2     ={MXR,MXC*TWOCOL,&pbA_p2    [0][0]};
double pbB_p2    [MXR][MXC*TWOCOL];matrix mB_p2     ={MXR,MXC*TWOCOL,&pbB_p2    [0][0]};
double pbAB      [MXR][MXC*TWOCOL];matrix mAB       ={MXR,MXC*TWOCOL,&pbAB      [0][0]};
double pb2AB     [MXR][MXC*TWOCOL];matrix m2AB      ={MXR,MXC*TWOCOL,&pb2AB     [0][0]};
double pbT1      [MXR][MXC*TWOCOL];matrix mT1       ={MXR,MXC*TWOCOL,&pbT1      [0][0]};
double pbT2      [MXR][MXC*TWOCOL];matrix mT2       ={MXR,MXC*TWOCOL,&pbT2      [0][0]};

                     mA.rows=n;                   mA.cols=n*TWOCOL;
                     mB.rows=n;                   mB.cols=n*TWOCOL;
                 mAmnsB.rows=n;               mAmnsB.cols=n*TWOCOL;
              mAmnsB_p2.rows=n;            mAmnsB_p2.cols=n*TWOCOL;
                  mA_p2.rows=n;                mA_p2.cols=n*TWOCOL;
                  mB_p2.rows=n;                mB_p2.cols=n*TWOCOL;
                    mAB.rows=n;                  mAB.cols=n*TWOCOL;
                   m2AB.rows=n;                 m2AB.cols=n*TWOCOL;
                    mT1.rows=n;                  mT1.cols=n*TWOCOL;
                    mT2.rows=n;                  mT2.cols=n*TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */

 two.numer = 2;
 two.denom = 1;

  rndmI(&mA, 9);
  rndmI(&mB, 9);

  clrscrn();
  printf("                                                       A :");
  printmI(&mA);
  printf("                                                       B :");
  printmI(&mB);
  getchar();

  clrscrn();
  printf("                                                       A :");
  printmI(&mA);
  printf("                                                       B :");
  printmI(&mB);
  printf("                                                     A-B :\n");
  submF(&mA, &mB,&mAmnsB);
  printmI(       &mAmnsB);
  getchar();

  clrscrn();
  printf("                                                 A-B     :\n");
  printmI(       &mAmnsB);
  printf("                                                (A-B)**2 :\n");
  multmF(&mAmnsB,&mAmnsB,&mAmnsB_p2);
  printmI(               &mAmnsB_p2);
  getchar();

  clrscrn();
  printf("                                                       A :");
  printmI(&mA);
  printf("                                                    A**2 :\n");
  multmF(&mA,&mA,&mA_p2);
  printmI(       &mA_p2);
  getchar();

  clrscrn();
  printf("                                                       A :");
  printmI(&mA);
  printf("                                                       B :");
  printmI(&mB);
  printf("                                                      AB :\n");
  multmF(&mA,&mB,&mAB);
  printmI(       &mAB);
  getchar();

  clrscrn();
  printf("                                                      AB :\n");
  printmI(&mAB);
  printf("                                                     2AB :\n");
  smultmF(two,&mAB,&m2AB);
  printmI(&m2AB);
  getchar();

  clrscrn();
  printf("                                                       B :");
  printmI(&mB);
  printf("                                                    B**2 :\n");
  multmF(&mB,&mB,&mB_p2);
  printmI(       &mB_p2);
  getchar();

  clrscrn();
  printf("                                       A**2 - 2AB + B**2 :\n");
  submF(&mA_p2,&m2AB,&mT1);
  addmF(&mB_p2,&mT1,&mT2);
  printmI(          &mT2);
  printf("\n                                                (A-B)**2 :\n");
  printmI(               &mAmnsB_p2);
  printf("\n     (A-B)**2 !=  A**2- 2AB +B**2.          \n");
  printf("     (A-B)**2  =  A**2- 2AB +B**2. (Only when A and B commute)\n\n");
  printf("     (A-B)**2  =  A**2-AB-BA+B**2. (See :           idmbi.exe)\n");
}


void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.\n");
  printf("\n                                                  ");
  printf("\n          (A-B)**2 != A**2- 2AB +B**2            ");
  printf("\n          ***************************          \n");
  printf("\n          (A-B)**2  = A**2-AB-BA+B**2           ");
  printf("\n          ***************************          \n");
  printf("\n The size of mA, mB      : 1x1 ... 4x4.         \n");
  printf("\n     ex : \"idmbi.exe\"                         \n");
  printf("\n You can choose the size :                      \n");
  printf("\n     ex : \"idmbi.exe 2\" -> 2x2                  ");
  printf("\n          \"idmbi.exe 1\" -> 1x1                  ");
  printf("\n          \"idmbi.exe 4\" -> 4x4                  ");
  printf("\n\n                                                ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  getchar();
}


/* --------------------------------- MAIN ----------------------------------- */
main(int argc, char *argv[])
{
time_t t;
int    n;
/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{
if( argc == 2 && atoi(argv[1]) )
 {n = atoi(argv[1]); if( n > 4){n=4;} }
else
 {    n=rndpI(4);  }
   if(n<1){n=1;}


  AmnsB_BmnsA(n);


printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}












