/* gjid03.c                         freeware                   xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xahfile.h"

/* ------------------------------ FUNCTION -------------------------  */
/* Do    :                                      */
/*                             */
/* Call  :                                                            */
/* Debug :
/* -------------------------------------------------------------------------- */
invB(int n)
{
double pbA      [n][n*TWOCOL];matrix mA        ={n,n*TWOCOL,&pbA      [0][0]};
double pbB      [n][n*TWOCOL];matrix mB        ={n,n*TWOCOL,&pbB      [0][0]};
double pbAB     [n][n*TWOCOL];matrix mAB       ={n,n*TWOCOL,&pbAB     [0][0]};
double pTrpsA    [n][n*TWOCOL];matrix mTrpsA    ={n,n*TWOCOL,&pTrpsA    [0][0]};
double pTrpsB    [n][n*TWOCOL];matrix mTrpsB    ={n,n*TWOCOL,&pTrpsB    [0][0]};
double pTrps_AB  [n][n*TWOCOL];matrix mTrps_AB  ={n,n*TWOCOL,&pTrps_AB  [0][0]};

double pTrpsBTrpsA [n][n*TWOCOL];
matrix mTrpsBTrpsA={n, n*TWOCOL,&pTrpsBTrpsA[0][0]};

double pTrps_AB_mns_TrpsBTrpsA [n][n*TWOCOL];
matrix mTrps_AB_mns_TrpsBTrpsA={n, n*TWOCOL,&pTrps_AB_mns_TrpsBTrpsA[0][0]};

/*-------------------------------- PROGRAM ---------------------------------- */
 randmF(&mA,9,4);
 randmF(&mB,9,4);

 clrscrn();
 printf("                                                         A :\n");
 printmF(&mA);
 printf("                                                         B :\n");
 printmF(&mB);
 printf("                                                        AB :\n");
 multmF(&mA,&mB,&mAB);
 printmF(       &mAB);
 getchar();

 clrscrn();
 printf("                                                       AB  :\n");
 printmF(   &mAB);
 printf("                                             transpose(AB) :\n");
 transposeF(&mAB,&mTrps_AB);
 printmF(        &mTrps_AB);
 getchar();

 clrscrn();
 printf("                                                        A  :\n");
 printmF(&mA);
 printf("                                              transpose(A) :\n");
 transposeF(&mA,&mTrpsA);
 printmF(       &mTrpsA);
 getchar();

 clrscrn();
 printf("                                                        B  :\n");
 printmF(&mB);
 printf("                                              transpose(B) :\n");
 transposeF(&mB,&mTrpsB);
 printmF(       &mTrpsB);
 getchar();


 clrscrn();
 printf("                                              transpose(B) :\n");
 printmF(&mTrpsB);
 printf("                                              transpose(A) :\n");
 printmF(&mTrpsA);
 printf("                               transpose(B) * transpose(A) :\n");
 multmF(&mTrpsB,&mTrpsA,&mTrpsBTrpsA);
 printmF(&mTrpsBTrpsA);
 getchar();

 clrscrn();
 printf("                                             transpose(AB) :\n");
 printmF(           &mTrps_AB);
 printf("                               transpose(B) * transpose(A) :\n");
 printmF(&mTrpsBTrpsA);
 printf("             transpose(AB) - (transpose(B) * transpose(A)) :\n");
 submF(&mTrps_AB,&mTrpsBTrpsA, &mTrps_AB_mns_TrpsBTrpsA);
 printmF(&mTrps_AB_mns_TrpsBTrpsA);
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.\n");
  printf("\n                                                  ");
  printf("\n  transpose(AB) = (transpose(B) * transpose(A))   ");
  printf("\n  ********************************************  \n");
  printf("\n The size of mA : 2x2 ... 4x4.                  \n");
  printf("\n           ex : \"trpef.exe\"                   \n");
  printf("\n You can choose the size :                      \n");
  printf("\n           ex : \"trpef.exe 2\" -> mA 2x2         ");
  printf("\n                \"trpef.exe 3\" -> mA 3x3         ");
  printf("\n                \"trpef.exe 4\" -> mA 4x4         ");
  printf("\n                                                  ");
  printf("\n                                                  ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press a key to continue                          ");
  printf("\n                                                  ");

  getchar();
}

/* --------------------------------- MAIN ----------------------------------- */
main(int argc, char *argv[])
{
time_t t;
int    n;
int    i;

  srand(time(&t));

  hello();

do
{
  if(argc ==2 && atoi(argv[1]))
    {
    n = atoi(argv[1]);
    if( n< 2){n=2;}
    if( n> 4){n=4;}
    }
  else
    {
    n = (int) fabs(randF(5));
    if(n<2){n=2;}
    }

  invB(n);
  printf("\n Press 'X' Return to stop\n");

} while(toupper(getchar())!='X');

  return 0;
}

