/* Copyright 1995-96 Jon Griffiths.  See the file "jlib.doc" for details. */

#include <i86.h>
#include <string.h>
#include <stdio.h>
#include <jlib.h>

typedef struct{
  USHORT  seg,sel;
} rptr;

void far *__jlib_dos_alloc(rptr * rp,unsigned int size);
void __jlib_dos_free(rptr *rp);

typedef struct{
  char     signature[4];
  USHORT   version,OEMname_offset,OEMname_segment;                 
  UBYTE    capabilities[4];
  USHORT   modes_offset,modes_segment;   /* supported VESA and OEM modes */
  UBYTE    reserved[238];
} vesainfo;

typedef struct{
  USHORT   attributes;
  UBYTE    Aattributes,Battributes;
  USHORT   granularity,size,segA,segB;
  UBYTE    foobar[4];    /*void     (far *setpage)(); */
  USHORT   scan_line_bytes;
  USHORT   pixel_width;  /* OEM */
  USHORT   pixel_height;
  UBYTE    cpixel_width,cpixel_height,mem_planes,bpp,num_banks,mem_model;
  UBYTE    bank_size,image_pages,res1;
  UBYTE    rmask;  /* VBE 1.2+ */
  UBYTE    rfp,gmask,gfp,bmask,bfp,res_mask,res_fp,direct_col,res2[216];
}vesamodedata;

typedef struct{
        unsigned int edi,esi,ebp,reserved,ebx,edx,ecx,eax;
        USHORT   flags,es,ds,fs,gs,ip,cs,sp,ss;
} rm_regs;

char version_string[] = "WATCOM C VESA";
int          __jlib_mouse_visible=0;
static UBYTE __jlib_previous_mode=0x3;       /* previous text mode */
static UBYTE __jlib_screen_initted=0;
rptr vesa_info_rp,vesa_mode_data_rp;
vesainfo far *vesa_info=NULL;
vesamodedata far *vesa_mode_data=NULL;
int vesa_remains,vesa_granularity,vesa_gran_mul,vesa_gran1024,vesa_pages,vesa_width;

/*+------------------------------------------------------------------------+*/
/*| Set the VESA video mode.                                               |*/
/*+------------------------------------------------------------------------+*/
int screen_set_video_mode(void)
{
  union REGS regs,r;
  struct SREGS sregs;
  rm_regs rmregs;

  if(__jlib_screen_initted){
     return 1;
  }

  /* save text mode */
  r.h.ah = 0x0f;
      
  int386 (0x10,&r,&r);
      
  __jlib_previous_mode = r.h.al;

 if((vesa_info=(vesainfo far *)__jlib_dos_alloc(&vesa_info_rp,sizeof(vesainfo)))==NULL){
    jlib_exit("DOS Memory Allocation Failure.");
 }

 memset(&rmregs,0,sizeof(rmregs));
 memset(&regs,0,sizeof(regs));
 memset(&sregs,0,sizeof(sregs));
 segread(&sregs);
 rmregs.eax = 0x4f00;
 rmregs.es = vesa_info_rp.seg;
 rmregs.ds = vesa_info_rp.seg;
 regs.x.eax = 0x300;
 regs.x.ebx = 0x10;
 regs.x.ecx = 0;
 sregs.es = FP_SEG(&rmregs);
 regs.x.edi = FP_OFF(&rmregs);
 int386x(0x31,&regs,&regs,&sregs);       /* Get VESA info  */

 if(rmregs.eax != 0x4f){
    return 0;                           /* no VESA support */
 }

 memset(&regs,0,sizeof(regs));
 regs.w.ax = 0x4f02;
 regs.w.bx = VESA_MODE;
 int386(0x10,&regs,&regs);
 if(regs.w.ax != 0x004f){
    return 0;
 }

 if((vesa_mode_data=(vesamodedata far *)__jlib_dos_alloc(&vesa_mode_data_rp,sizeof(vesamodedata)))==NULL){
    jlib_exit("DOS Memory Allocation Failure.");
 }

 memset(&rmregs,0,sizeof(rmregs));
 rmregs.es = vesa_mode_data_rp.seg;
 rmregs.ds = vesa_mode_data_rp.seg;
 rmregs.edi = 0;
 rmregs.eax = 0x4f01;
 rmregs.ecx = VESA_MODE;
 memset(&regs,0,sizeof(regs));
 memset(&sregs,0,sizeof(sregs));
 segread(&sregs);
 regs.x.eax = 0x300;
 regs.x.ebx = 0x10;
 regs.x.edi = (unsigned int)&rmregs;
 int386x(0x31,&regs,&regs,&sregs);
 if(regs.h.al != 0){
    __jlib_dos_free(&vesa_info_rp);
    return 0;
 }

 vesa_granularity= vesa_mode_data->granularity;
 vesa_width=vesa_mode_data->pixel_width;
 if(vesa_width==0){
    vesa_width=vesa_mode_data->scan_line_bytes;
 }
 __jlib_dos_free(&vesa_mode_data_rp);
 __jlib_dos_free(&vesa_info_rp);

 vesa_gran_mul=64/vesa_granularity;
 vesa_gran1024=vesa_granularity*1024;
 vesa_pages=(SCREEN_WIDTH*SCREEN_HEIGHT)/(vesa_gran1024);
 vesa_remains=(SCREEN_WIDTH*SCREEN_HEIGHT)-(vesa_pages*vesa_gran1024);
 
 __jlib_screen_initted=1;
 return 1;
}

void screen_restore_video_mode(void)
{
  union REGS r;

  if(__jlib_screen_initted){
      /* reset video mode */
      r.x.eax = __jlib_previous_mode;
   
      int386 (0x10, &r, &r);
      __jlib_screen_initted=0;
  }
}


/*+------------------------------------------------------------------------+ */
/*|Return the current page number.                                         | */
/*+------------------------------------------------------------------------+ */
int screen_get_page (void)
{
   return 1;
}


/*+------------------------------------------------------------------------+ */
/*|set the given  page number.                                             | */
/*+------------------------------------------------------------------------+ */
void screen_set_page (int page)
{
 /* do nothing */
}


/*+------------------------------------------------------------------------+ */
/*|Show the current drawing page.                                          | */
/*+------------------------------------------------------------------------+ */
void screen_show_page (int page)
{
   /* do nothing */
}


/*+------------------------------------------------------------------------+ */ 
/*|Wait for the retrace beam to move offscreen.                            | */ 
/*+------------------------------------------------------------------------+ */ 
void screen_wait_vsync (void)
{
   /* not implememted yet */
}


/*+------------------------------------------------------------------------+ */ 
/*|Fill the screen with a given color.                                     | */ 
/*+------------------------------------------------------------------------+ */ 
void screen_fill (UBYTE color)
{
 int i;
 
 __cld();
 for(i=0;i<vesa_pages;i++){
    vesa_set_page(i*vesa_gran_mul);
    MEM_STORE_LONG(VIDEO_START,color,vesa_gran1024);
 }
 vesa_set_page(vesa_pages);
 MEM_STORE_LONG(VIDEO_START,color,vesa_remains);

}


/*+------------------------------------------------------------------------+ */ 
/*|Clear the screen.                                                       | */ 
/*+------------------------------------------------------------------------+ */ 
void screen_clear (void) 
{
 screen_fill(0); 
}


int get_best_copy_method (void *addr1, void *addr2, unsigned int len)
{
 return ALIGNMENT_STATE_1;
}


static void far * __jlib_dos_alloc(rptr * rp,unsigned int size)
{
 union REGS regs;

 size = ((size + 15) & 0xfffffff0);    /* Round up to nearest paragraph */
 memset(&regs,0,sizeof(regs));
 regs.w.ax = 0x100;
 regs.w.bx = (USHORT)(size >> 4);      /* Conv bytes to pages */
 int386(0x31,&regs,&regs);
 if(regs.x.cflag == 0){
   rp->seg=regs.w.ax;
   rp->sel=regs.w.dx;
   return (MK_FP(regs.w.dx,0));
 }
 return NULL;
}

static void __jlib_dos_free(rptr *rp)
{
  union REGS regs;
  regs.w.ax = 0x101;
  regs.w.dx = rp->sel;
  int386(0x31,&regs,&regs);
}

