/* Copyright 1995-96 Jon Griffiths.  See the file "jlib.doc" for details. */

#include <jlib.h>
#include <stdio.h>


/*+------------------------------------------------------------------------+ */
/*|blit a fullscreen buffer to the screen                                  | */
/*+------------------------------------------------------------------------+ */
JINLINE void screen_blit_fs_buffer (buffer_rec * buff)
{
 UBYTE *out=B_BUFF_PTR(buff);
 int i;
 
 __cld();
 for(i=0;i<vesa_pages;i++){
    vesa_set_page(i*vesa_gran_mul);
    FAST_LONG_COPY((int *)out,(int *)VIDEO_START,vesa_gran1024);
    out+=vesa_gran1024;
 }

 vesa_set_page(vesa_pages);
 FAST_LONG_COPY((int *)out,(int *)VIDEO_START,vesa_remains);
 
}

/*+------------------------------------------------------------------------+ */
/*|blit part of a buffer to the screen without clipping.                   | */
/*+------------------------------------------------------------------------+ */
void screen_blit_buff_toNC (int x, int y, buffer_rec * sbuff,
			 int sbx1, int sby1, int sbx2, int sby2)
{
   int v_len = sby2 - sby1+1, h_len = sbx2 - sbx1+1;
   UBYTE *src = B_BUFF_PTR (sbuff) + (B_X_SIZE (sbuff) * sby1) + sbx1;
   UBYTE *dest = (UBYTE *)VIDEO_START;
   int width = B_X_SIZE (sbuff);
   int offset,page;

    __cld();

   offset=y*vesa_width+x;
   if(offset==0){
      page=0;
   }
   else{
      page=offset/(vesa_gran1024);
      offset=offset%(vesa_gran1024);
   }
   vesa_set_page(page*vesa_gran_mul);
   for (; v_len != 0; v_len--){
                if (offset + h_len > (vesa_gran1024))
                        if (offset >= (vesa_gran1024)) {
                                page++;
                                vesa_set_page(page*vesa_gran_mul);
                                offset=offset%(vesa_gran1024);
			}
                        else { 
                                FAST_LONG_COPY(src,dest+offset,vesa_gran1024-offset);
                                page++;
                                vesa_set_page(page*vesa_gran_mul);
                                FAST_LONG_COPY(src+vesa_gran1024-offset,dest,
                                        (offset+h_len)%vesa_gran1024);
                                offset = (offset + vesa_width)%vesa_gran1024;
				src += width;
				continue;
                        }      
                FAST_LONG_COPY(src,(UBYTE *)(VIDEO_START+offset), h_len);
                src+=width;
                offset = ((int)offset+vesa_width);
    }

}


/*+------------------------------------------------------------------------+ */
/*|blit part of a buffer to the screen with clipping.                      | */
/*+------------------------------------------------------------------------+ */
void screen_blit_buff_to (int x, int y, buffer_rec * sbuff,
			  int sbx1, int sby1, int sbx2, int sby2)
{

   int v_len,h_len;
   UBYTE *src;
   UBYTE *dest=(UBYTE *)VIDEO_START;
   int width,height;
   int offset,page;

   width = B_MAX_X(sbuff);
   height = B_MAX_Y(sbuff);
   src = B_BUFF_PTR(sbuff);

    __cld();

   if (sbx1 > sbx2){
        JLIB_SWAP (sbx1, sbx2);
   }

   if (sby1 > sby2){
        JLIB_SWAP (sby1, sby2);
   }

   /* clip src buffer */
   if((sbx1>width) ||(sby1>height) || (sbx2<0) || (sby2<0)){
      return;
   }

   if(sbx1<0){
      sbx1=0;
   }
   if(sby1<0){
      sby1=0;
   }
   if(sbx2>width){
      sbx2=width;
   }
   if(sby2>height){
      sby2=height;
   }

   /* clip to screen */
   if ((x > SCREEN_MAX_X) || (y > SCREEN_MAX_Y)){
	return;
   }

   if(x<0){
      sbx1-=x;
      x=0;
      if(sbx1>sbx2){
         return;
      }
   }
   if(y<0){
      sby1-=y;
      y=0;
      if(sby1>sby2){
         return;
      }
   }

   v_len=sby2 - sby1+1;
   h_len = sbx2 - sbx1+1;

   if ((x + h_len) > SCREEN_WIDTH){
	h_len = SCREEN_WIDTH - x;
   }

   if ((y + v_len) > SCREEN_HEIGHT){
	v_len = SCREEN_HEIGHT - y;
   }

   width++; /* from max x to buffer width */

   src += (width * sby1) + sbx1;

   offset=y*vesa_width+x;
   if(offset==0){
      page=0;
   }
   else{
      page=offset/(vesa_gran1024);
      offset=offset%(vesa_gran1024);
   }
   vesa_set_page(page*vesa_gran_mul);
   for (; v_len != 0; v_len--){
                if (offset + h_len > (vesa_gran1024))
                        if (offset >= (vesa_gran1024)) {
                                page++;
                                vesa_set_page(page*vesa_gran_mul);
                                offset=offset%(vesa_gran1024);
			}
                        else { 
                                FAST_LONG_COPY(src,dest+offset,vesa_gran1024-offset);
                                page++;
                                vesa_set_page(page*vesa_gran_mul);
                                FAST_LONG_COPY(src+vesa_gran1024-offset,dest,
                                        (offset+h_len)%vesa_gran1024);
                                offset = (offset + vesa_width)%vesa_gran1024;
				src += width;
				continue;
                        }      
                FAST_LONG_COPY(src,(UBYTE *)(VIDEO_START+offset), h_len);
                src+=width;
                offset = ((int)offset+vesa_width);
    }
}



