/* Copyright 1995-96 Jon Griffiths.  See the file "jlib.doc" for details. */
#include <jlib.h>


/*+------------------------------------------------------------------------+*/
/*|plot a dot at (x, y) with color c with clipping in a buffer             |*/
/*+------------------------------------------------------------------------+*/
JINLINE void buff_draw_point (buffer_rec * buff, int x, int y, UBYTE c)
{
   JLIB_ENTER("buff_draw_point");

#ifndef JLIB_PRODUCTION
   jlib_check_buffer(buff);
#endif

   if ((x > B_MAX_X(buff)) || (y > B_MAX_Y(buff)) || (x < 0) || (y < 0)){
      JLIB_LEAVE;
      return;
   }

   *(B_OFFSET(buff,y)+x) = c;

   JLIB_LEAVE;
}


/*+------------------------------------------------------------------------+*/
/*|plot a dot at (x, y) with color c without clipping in a buffer          |*/
/*+------------------------------------------------------------------------+*/
JINLINE void buff_draw_pointNC (buffer_rec * buff, int x, int y, UBYTE c)
{
   JLIB_ENTER("buff_draw_pointNC");

   *(B_OFFSET(buff,y)+x) = c;

   JLIB_LEAVE;
}


/*+------------------------------------------------------------------------+*/
/*|get a dot at (x, y) with clipping from a buffer                         |*/
/*+------------------------------------------------------------------------+*/
JINLINE UBYTE buff_get_point (buffer_rec * buff, int x, int y)
{
   JLIB_ENTER("buff_get_point");

#ifndef JLIB_PRODUCTION
   jlib_check_buffer(buff);
#endif

   if ((x > B_MAX_X(buff)) || (y > B_MAX_Y(buff)) || (x < 0) || (y < 0)){
      JLIB_LEAVE;
      return 0;
   }

   JLIB_LEAVE;
   return *(B_OFFSET(buff,y)+x);
}


/*+------------------------------------------------------------------------+*/
/*|get a dot at (x, y) without clipping from a buffer                      |*/
/*+------------------------------------------------------------------------+*/
JINLINE UBYTE buff_get_pointNC (buffer_rec * buff, int x, int y)
{
   return *(B_OFFSET(buff,y)+x);
}
