/* Copyright 1995-96 Jon Griffiths.  See the file "jlib.doc" for details. */
#include <jlib.h>


/*+------------------------------------------------------------------------+*/
/*|draw a box with corners x1, y1 to x2 , y2 in color c without clipping   |*/
/*+------------------------------------------------------------------------+*/
JINLINE void buff_draw_boxNC (buffer_rec * buff, int x1, int y1, int x2, int y2, UBYTE c)
{
   int width = B_X_SIZE(buff);
   int boxwidth = x2 - x1 + 1;
   UBYTE *buffer = B_OFFSET(buff,y1) + x1;

   JLIB_ENTER("buff_draw_boxNC");

   y2 -= y1;

   /* draw top line */
   if(boxwidth < 17){
      MEM_STORE_SHORT(buffer,c,boxwidth);
   }
   else{
      MEM_STORE_LONG(buffer,c,boxwidth);
   }
   boxwidth--;

   /* draw the 2 vertical sides at the same tip */
   for (; y2 != 0; y2--) {
      buffer += width;
      *buffer = c;
      buffer[boxwidth] = c;
   }

   /* draw bottom line  */
   boxwidth++;
   if(boxwidth < 17){
      MEM_STORE_SHORT(buffer,c,boxwidth);
   }
   else{
      MEM_STORE_LONG(buffer,c,boxwidth);
   }

   JLIB_LEAVE;
}


/*+------------------------------------------------------------------------+*/
/*|draw a box with corners x1, y1 to x2 , y2 in color c with clipping      |*/
/*+------------------------------------------------------------------------+*/
void buff_draw_box(buffer_rec * buff, int x1, int y1, int x2, int y2, UBYTE c)
{
   UBYTE *buffer;
   int width,height,boxwidth,status=0;
   
   JLIB_ENTER("buff_draw_box");

#ifndef JLIB_PRODUCTION
   jlib_check_buffer(buff);
#endif

   width = B_MAX_X(buff);
   height = B_MAX_Y(buff);

   if (x1 > x2) {
     JLIB_SWAP(x1,x2);
   }
   if (y1 > y2) {
     JLIB_SWAP(y1,y2);
   }

   if (x2 > width) {
      x2 = width;
      status |= C_RIGHT;
   }
   else{
      if (x2 < 0) {
        JLIB_LEAVE;
        return;
      }
   }

   if (y2 > height) {
      y2 = height;
      status |= C_DOWN;
   }
   else{
      if (y2 < 0) {
        JLIB_LEAVE;
        return;
      }
   }
   
   if (x1 < 0) {
      x1 = 0;
      status |= C_LEFT;
   }
   else{
      if (x1 > width) {
        JLIB_LEAVE;
        return;
      }
   }

   if (y1 < 0) {
      y1 = 0;
      status |= C_UP;
   }
   else{
      if (y1 > height) {
        JLIB_LEAVE;
        return;
      }
   }

   /* Not clipped */
   if(!status){
      buff_draw_boxNC(buff,x1,y1,x2,y2,c);
      JLIB_LEAVE;
      return;
   }

   boxwidth = x2 - x1 + 1;

   /* draw top line */
   if(!(status & C_UP)){
     buffer = B_OFFSET(buff,y1) + x1;

     if(boxwidth < 17){
        MEM_STORE_SHORT(buffer,c,boxwidth);
     }
     else{
        MEM_STORE_LONG(buffer,c,boxwidth);
     }
   }
   
   if((status&C_DOWN)==0){
     buffer = B_OFFSET(buff,y2) + x1;

     if(boxwidth < 17){
        MEM_STORE_SHORT(buffer,c,boxwidth);
     }
     else{
        MEM_STORE_LONG(buffer,c,boxwidth);
     }
   }

   buffer = B_OFFSET(buff,y1) + x1;

   y2 -= y1 + 1;

   width++;
   height++;

   switch(status & 0x3){
    case 0:
       /* draw both sides */
       boxwidth--;
       for(; y2 > 0; y2--) {
         *buffer = c;
          buffer[boxwidth] = c;
          buffer += width;
       }
    case C_LEFT:
       /* draw right side */
       buffer += boxwidth;
       for(; y2 > 0; y2--) {
         *buffer = c;
          buffer += width;
       }
       break;
    case C_RIGHT:
       /* draw left side */
       for(; y2 > 0; y2--) {
         *buffer = c;
          buffer += width;
       }
       break;
    default:
       break;
   }

   JLIB_LEAVE
}


