/* Copyright 1995-96 Jon Griffiths.  See the file "jlib.doc" for details. */

#include <stdio.h>
#include <stdlib.h>
#include <jlib.h>

#define MESSAGE "This is an info box.\nInfo boxes can be great sources of\ninformation if they are used\ncorrectly."
#define SHORT_MESS "Short messages need less lines."

#define SAFE_CLEAR            \
     mouse_hide_pointer();    \
     screen_clear();          \
     mouse_show_pointer();

/* simple popup() demo */

int main(void)
{
 UBYTE *pal,c1,c2;

 JLIB_DEBUG_OFF
 
 /* set up the screen */
 screen_set_video_mode();

 pal = pal_load("demo10.pal");
 if(pal == NULL){
   jlib_exit("Palette load failed.");
 }

 c2=pal_closest_color_rgb(pal,255,255,255);
 c1=pal_closest_color_rgb(pal,20,80,80);
 
 mouse_present(); /* it doesn't actually matter if mouse is there or not */
 mouse_show_pointer();
 kb_init();
  
 popup_about(c1,c2);

 SAFE_CLEAR;
 
 popup_info(MESSAGE,c1,c2);

 SAFE_CLEAR;
  
 popup_info(SHORT_MESS,c1,c2);


 kb_closedown();
 mouse_closedown();

 /* return to text mode and exit */
 screen_restore_video_mode();
 return(0);
}
