; strrchr
;   AAA=str
;   BBB=008
;   F=0
;   O=0
; str00800.asm

.xlist
INCLUDE CLIBC_16.INC
.list

IFDEF CLIBC_16_EXTERN_PTRS
 IF CLIBC_16_EXTERN_PTRS EQ CLIBC_16_EXTERN_PTRS_YES

CLIBC_16_EXTERN_PTRS_SEG_NAME SEGMENT
EXTERNDEF C p_fn_strrchr:FN_CALL PTR
p_fn_strrchr P_FN_CALL strrchr
CLIBC_16_EXTERN_PTRS_SEG_NAME ENDS

 ENDIF
ENDIF

;strrchr() -- Search string for char, in reverse
;char __near * fn_call strrchr(const char __near * const, const int chr);
; GIVEN:
;   p_str	near pointer, offset from ds
;   chr 	character to search for
;RETURNS: (char *)
;   pointer	near pointer, offset from ds
;		to '\0' if character not found
;		to character if found
; NOTES:
;   will search for '\0', and find it at end of string
BEGIN_CODE_SEGMENT <STRING>
strrchr PROC FN_CALL C USES si, p_str:NEAR16 PTR BYTE, chr:WORD
	    mov si, [p_str]	    ;ds:si = p_Str, source
	    mov ax, [chr]
	    xchg al, ah
	    mov bx, -1

@@loop:     lods BYTE PTR ds:[si]   ;Load char
            cmp al,ah               ;Is it the char?
	    jne @F
		mov bx,si		    ;BX = position
	    @@:
	    test al,al	     ;Loop while not zero
	    jnz @@loop

	    dec si
	    mov ax, si

	    cmp bx, -1
	    je @F
		dec bx	; because lods incs si
		mov ax, bx
@@:	    ret
strrchr ENDP
END_CODE_SEGMENT <STRING>
END
