; @strcpy_dss
;   AAA=str
;   BBB=000
;   F=1
;   O=2
; str00012.asm

.xlist
INCLUDE CLIBC_16.INC
.list

IFDEF CLIBC_16_EXTERN_PTRS
 IF CLIBC_16_EXTERN_PTRS EQ CLIBC_16_EXTERN_PTRS_YES

CLIBC_16_EXTERN_PTRS_SEG_NAME SEGMENT
EXTERNDEF C p_fn_fc_strcpy:FN_CALL PTR
p_fn_fc_strcpy_dss P_FN_CALL @strcpy_dss
CLIBC_16_EXTERN_PTRS_SEG_NAME ENDS

 ENDIF
ENDIF

;strcpy_dss() -- Copies string 2 to string 1, including null term char
;char __near * __fastcall fn_call dss_strcpy(char const __near *, const char __near * const);
; __fastcall
; GIVEN:
;   BX		p_str1, offset from ss
;   AX		p_str2, offset from ds
; RETURNS:
;   AX		p_str1, offset from ss
BEGIN_CODE_SEGMENT <STRING>
@strcpy_dss PROC FN_CALL USES cx bx si di es
	    mov di, bx	    ;es:di = p_str1 = destination
	    mov si, ax	    ;ds:si = p_str2 = source

	    mov ax, ss
	    mov es, ax

	    mov cx, ds

	    cmp ax, cx	    ; check to see if ds==es
	    jne @@cont
	    cmp si,di
	    jne @@cont
	    mov ax, di
	    jmp @@exit	    ; they are equal, so done
@@cont:
	    mov bx, di		    ; save destination offset

@@loop:	    lods BYTE PTR ds:[si]   ;Load char
	    stos BYTE PTR es:[di]   ;Store char
	    test al,al		    ;Loop while not zero
	    jnz @@loop
@@done:
	    mov ax, bx
@@exit:
	    ret 		    ;Return AX points to copied string
@strcpy_dss ENDP
END_CODE_SEGMENT <STRING>
END
