INCLUDE CLIBC_16.INC

; skiptosp
; char __near * fn_call skiptosp(const char __near * const);
; GIVEN:
;   p_str	near pointer, (source) offset from ds
; RETURNS: (char __near *)
;   pointer	near pointer, offset from ds
;		pointer to the first white space character in the string
;		if no more white space characters in the string,
;		  then points to terminating '\0'
; NOTES:
;   see isspace for definition of white space character

CLIBC_16_CS SEGMENT
skiptosp PROC FN_CALL C USES si, p_str:NEAR16 PTR BYTE
    mov si, [p_str]
@@luup:
    lods BYTE PTR ds:[si]
    test al, al
    jz @@done
    cmp al, 09h
    jl @@luup
    cmp al, 0Dh
    jbe @@done
    cmp al, 20h
    jne @@luup
@@done:
    dec si
    mov ax, si
    ret
skiptosp ENDP

; __fastcall
;   bx	    p_str, offset from ds
; char __near * __fastcall fn_call skiptosp(const char __near * const);
@skiptosp PROC FN_CALL USES si
    mov si, bx
@@luup:
    lods BYTE PTR ds:[si]
    test al, al
    jz @@done
    cmp al, 09h
    jl @@luup
    cmp al, 0Dh
    jbe @@done
    cmp al, 20h
    jne @@luup
@@done:
    dec si
    mov ax, si
    ret
@skiptosp ENDP

; skiptosp_sss
; char __near * fn_call skiptosp_sss(const char __near * const);
; GIVEN:
;   p_str	near pointer, (source) offset from ss
; RETURNS: (char __near *)
;   pointer	near pointer, offset from ss
;		pointer to the first white space character in the string
;		if no more white space characters in the string,
;		  then points to terminating '\0'
; NOTES:
;   see isspace for definition of white space character

skiptosp_sss PROC FN_CALL C USES ds si, p_str:NEAR16 PTR BYTE
    mov ax, ss
    mov ds, ax
    mov si, [p_str]
@@luup:
    lods BYTE PTR ds:[si]
    test al, al
    jz @@done
    cmp al, 09h
    jl @@luup
    cmp al, 0Dh
    jbe @@done
    cmp al, 20h
    jne @@luup
@@done:
    dec si
    mov ax, si
    ret
skiptosp_sss ENDP

; __fastcall
;   bx	    p_str, offset from ss
; char __near * __fastcall fn_call skiptosp_sss(const char __near * const);
@skiptosp_sss PROC FN_CALL USES si
    mov si, bx
@@luup:
    lods BYTE PTR ds:[si]
    test al, al
    jz @@done
    cmp al, 09h
    jl @@luup
    cmp al, 0Dh
    jbe @@done
    cmp al, 20h
    jne @@luup
@@done:
    dec si
    mov ax, si
    ret
@skiptosp_sss ENDP
CLIBC_16_CS ENDS
END
