INCLUDE CLIBC_16.INC


;strupr() -- Convert string to uppercase
;char __near * __near strupr(char __near * const);
; GIVEN:
;   p_str	near pointer, (source) offset from ds
; RETURNS: (char __near *)
;   pointer	near pointer, offset from ds (p_str)

_TEXT SEGMENT
strupr PROC NEAR16 C uses es si di, p_str:NEAR16 PTR BYTE

	    mov ax, ds
	    mov es, ax

	    mov si, [p_str]	    ;ds:si = p_str
	    mov di, [p_str]	    ;es:di = p_str

@@loop:	    lods BYTE PTR ds:[si]   ;Load char
	    cmp al,'a'		    ;Check for lowercase
	    jb @F
            cmp al,'z'
	    ja @F
		sub al,20h	    ;Convert to uppercase
@@:
	    stos BYTE PTR es:[di]   ; Store char
	    test al,al		    ;Check for null
	    jnz @@loop

	    mov ax, [p_str]	; return p_str
	    ret

strupr ENDP

; __fastcall
;   bx	    p_str, (source) offset from ss
;char __near * __fastcall __near strupr(char __near * const);
@strupr PROC NEAR16 USES es ds si di

	    mov si, bx		    ;ds:si = p_str
	    mov di, bx		    ;es:di = p_str
	    mov ax, ds
	    mov es, ax


@@loop:	    lods BYTE PTR ds:[si]   ;Load char
	    cmp al,'a'		    ;Check for lowercase
	    jb @F
            cmp al,'z'
	    ja @F
		sub al,20h	    ;Convert to uppercase
@@:
	    stos BYTE PTR es:[di]   ; Store char
	    test al,al		    ;Check for null
	    jnz @@loop

	    mov ax, bx		; return p_str
	    ret

@strupr ENDP

;strupr_sss() -- Convert string to uppercase
;char __near * __near strupr_sss(char __near * const);
; GIVEN:
;   p_str	near pointer, (source) offset from ss
; RETURNS: (char __near *)
;   pointer	near pointer, offset from ss (p_str)
strupr_sss PROC NEAR16 C uses ds es si di, p_str:NEAR16 PTR BYTE

	    mov ax, ss
	    mov es, ax
	    mov ds, ax

	    mov si, [p_str]	    ;ds:si = p_str
	    mov di, [p_str]	    ;es:di = p_str

@@loop:	    lods BYTE PTR ds:[si]   ;Load char
	    cmp al,'a'		    ;Check for lowercase
	    jb @F
            cmp al,'z'
	    ja @F
		sub al,20h	    ;Convert to uppercase
@@:
	    stos BYTE PTR es:[di]   ; Store char
	    test al,al		    ;Check for null
	    jnz @@loop

	    mov ax, [p_str]	; return p_str
	    ret

strupr_sss ENDP

; __fastcall
;   bx	    p_str, (source) offset from ss
;char __near * __fastcall __near strupr_sss(char __near * const);
@strupr_sss PROC NEAR16 USES es ds si di

	    mov si, bx		    ;ds:si = p_str
	    mov di, bx		    ;es:di = p_str
	    mov ax, ss
	    mov es, ax
	    mov ds, ax


@@loop:	    lods BYTE PTR ds:[si]   ;Load char
	    cmp al,'a'		    ;Check for lowercase
	    jb @F
            cmp al,'z'
	    ja @F
		sub al,20h	    ;Convert to uppercase
@@:
	    stos BYTE PTR es:[di]   ; Store char
	    test al,al		    ;Check for null
	    jnz @@loop

	    mov ax, bx		; return p_str
	    ret

@strupr_sss ENDP
_TEXT ENDS
END
