/* iscntrl.S, ilibc_64.a */
/* Byron Young, 2002 */

#include "ilibc_64/ilibc_64.inc"

	.file	"iscntrl.S"
	.pred.safe_across_calls p1-p5,p16-p63
	
#if ILIBC_64_EXTERN_PTRS==ILIBC_64_EXTERN_PTRS_YES
ilibc_64_extern_ptrs_define(iscntrl)
#endif

// iscntrl() -- Is a control character.
// GIVEN:
//	chr	character to use in comparison.
// RETURNS: (r8)
//	0	if condition false.
//	!0	if condition is true.
// NOTES:
//  only the last byte of chr is used for comparisons.
//  0x00-0x1F, 0x7F
ILIBC_64_PROCEDURE_SECTION_NAME
ilibc_64_proc_start(iscntrl)
ilibc_64_proc_prologue
ilibc_64_proc_body
ret_val==r8
chr==r32
tmp==r11
	mov tmp=0xFF
	and chr=tmp,chr
	mov ret_val=r0
	cmp.eq p30,p31=0x7F,chr
	(p30) br.cond.spnt Yes
	cmp.geu p30,p31=0x1F,chr
Yes:
	(p30) add ret_val=ret_val,r0,1	// ++ret_val
ilibc_64_proc_epilogue
	br.ret.sptk.many b0
ilibc_64_proc_end(iscntrl)
