	PAGE	55,132
	NAME	f_api
	TITLE	FOSSIL Interface Routines for Microsoft C and Turbo C
	SUBTTL	Copyright 1988 Marshall Presnell; All Rights Reserved

;************************************************************************; 
;*									*; 
;*	    Assembled with Microsoft Macro Assembler version 5		*; 
;*	       using MIXED.MAC mixed language macro package.		*; 
;*									*; 
;************************************************************************; 

; NOTE: These functions act... well.... strange. They DO load the proper
;	registers and execute the INT 14 call, but somehow I haven't 
;	figured out why the code doesn't hook the timer tick.....
;
;	Will examine it closer and make a later version available when I
;	figure the problem out. Or if YOU figure it out, send me a copy
;	(and an explanation!)

;========================================================================; 
;=----------------------------------------------------------------------=; 
;=-                                                                    -=; 
;=-	      THIS MODULE HAS BEEN RELEASED FOR USE IN C NEWS	       -=; 
;=-			      					       -=; 
;=-    	ANY QUESTIONS, COMMENTS, OR PROBLEMS SHOULD BE ADDRESSED TO    -=; 
;=-			      					       -=; 
;=-			     MARSHALL PRESNELL			       -=; 
;=-			     13652 LYNN STREET			       -=; 
;=-			   WOODBRIDGE, VA  22191		       -=; 
;=-			      					       -=; 
;=-			FIDONET ADDRESS 109/639.106		       -=; 
;=-								       -=; 
;=----------------------------------------------------------------------=; 
;========================================================================; 

	.8086
	INCLUDE	MIXED.MAC
	SETMODEL

	.CODE

;==========================================================================;
;									   ;
;		SYSTEM EQUATES FOR FOSSIL VERSION 5 INTERFACE		   ;
;									   ;
;==========================================================================;

SETBAUD		EQU	00H
TXCHAR		EQU	01H
RXCHAR		EQU	02H
STATUS		EQU	03H
INIT		EQU	04H
DEINIT		EQU	05H
DTR		EQU	06H
TTICK		EQU	07H
OUTFLUSH	EQU	08H
OUTPURGE	EQU	09H
INPURGE		EQU	0AH
TXNOWAIT	EQU	0BH
PEEK		EQU	0CH
KEYREADNOWAIT	EQU	0DH
KEYREAD		EQU	0EH
FLOWCONTROL	EQU	0FH
CONTROL_C_CHECK	EQU	10H
SETCURS		EQU	11H
GETCURS		EQU	12H
WRANSI		EQU	13H
WATCHDOG	EQU	14H
WRBIOS		EQU	15H
TTICK_FUNCTION	EQU	16H
REBOOT		EQU	17H
READBLOCK	EQU	18H
WRITEBLOCK	EQU	19H
BREAK		EQU	1AH
DATASTRUCTURE	EQU	1BH
INSTALLAPI	EQU	7EH
REMOVEAPI	EQU	7FH

;===========================================================================
;
;	int f_installapi(int api_byte, void (far * api)());
;

HPROC	<f_installapi>,<USES BX, DX>,APICODE:WORD, APIENTRY:PTR

	PUSH	ES			;Save ES
	PUSH	DS			; ... and DS

	MOV	AX, CS			;Load ES and DS with
	MOV	ES, AX			;the current code segment.
	MOV	DS, AX			;Assuming small model

	MOV	AX, APICODE		;Load AX with the API code value
	PLES	DX, APIENTRY		;Load ES:DX with entry point
	PUSH	ES			;Also make it addressable through
	POP	DS			; DS:DX

	MOV	AH, INSTALLAPI		;Load function code
	INT	14H			;Call FOSSIL
					;Check for successful install
	CMP	AX, 1954H		;Check for the magic number
	JZ	OK1			;Found it, OK so far
	MOV	AX, 1			;Didn't find it - exit with a 1 in AX
	JMP	COMXIT			;Go to common exit

OK1:	CMP	BH, 1			;Check return status code in BH
	JZ	OK2			;It's ok too !
	MOV	AX, 1			;No it's not - exit with 1 in AX
	JMP	COMXIT			;Go to common exit

OK2:	MOV	AX, 0			;Everything's FINE. Exit with a 0

COMXIT:	POP	DS			;Restore DS
	POP	ES			;Restore ES
	HRET				;Return AX errorcode to caller

HENDP	f_installapi

;===========================================================================
;
;	int f_removeapi(int api_byte, void (far * api)());
;

HPROC	<f_removeapi>,<USES BX, DX>,APICODE:WORD, APIENTRY:PTR

	PUSH	ES			;Save ES
	PUSH	DS			; ... and DS

	MOV	AX, CS			;Load ES and DS with
	MOV	ES, AX			;the current code segment.
	MOV	DS, AX			;Assuming small model

	MOV	AX, APICODE		;Load AX with the API code value
	PLES	DX, APIENTRY		;Load ES:DX with entry point
	PUSH	ES			;Also make it addressable through
	POP	DS			; DS:DX

	MOV	AH, REMOVEAPI		;Load function code
	INT	14H			;Call FOSSIL
					;Check for successful deinstall
	CMP	AX, 1954H		;Check for the magic number
	JZ	OK10			;Found it, OK so far
	MOV	AX, 1			;Didn't find it - exit with a 1 in AX
	JMP	COMEXT			;Go to common exit

OK10:	CMP	BH, 1			;Check return status code in BH
	JZ	OK20			;It's ok too !
	MOV	AX, 1			;No it's not - exit with 1 in AX
	JMP	COMEXT			;Go to common exit

OK20:	MOV	AX, 0			;Everything's FINE. Exit with a 0

COMEXT:	POP	DS			;Restore DS
	POP	ES			;Restore ES
	HRET				;Return AX errorcode to caller

HENDP	f_removeapi

	END

