
/*
 *      If you wish to use these macros copy them from [11,1]debug.h
 *
 */

/* debug.h - This contains the definition of the debugging macros denter,
 *      debug, and dleave.  In order to invoke the macros the preprocessor
 *      symbol DEBUG must be defined.  If the symbol DEBUG is not defined the
 *      macros are translated to the NULL statement ';'.  Once your debugging
 *      statements are in place, they do not have to be commented out, or
 *      deleted from your program in order to suppress the debugging output.
 *
 * Note one of the modules of your program must have the preprocessor symbol
 *      MAIN defined.  Logically this dictates the module containing the
 *      main() will be the one defining this symbol.  The debugging package
 *      sets up the GLOBAL symbols D_S and D_I.  D_S is the the string of
 *      blanks that the indents are taken from, and D_I is the current
 *      indentation level.
 *
 * Debugging output is directed to the pseudo file descriptor STDBUG.  The user
 *      should direct any of their own debugging output to this file using:
 *
 *              fprintf (STDBUG, fmt, args);
 *
 *      where the fmt is a valid printf family format string, and args is a
 *      list of arguements satisfying the fmt string.  The user can define
 *      STDERR to any fd, and the debugging output will be redirected to that
 *      file.
 *
 *      The denter, debug, and dleave are used as follows:
 *
 *      denter(str);
 *              This will display a message indented two more spaces than what
 *      currently indented.  When used with dleave, this macro provides a
 *      useful means of tracing the nesting of loops and functions.
 *
 *      debug(x);
 *
 *              This will ensure that indentation is correct and excute the
 *      function x only when DEBUG is defined.  The most comman usage is with
 *      the function fprintf as:
 *
 *              debug(fprintf(DEBUG,"%x=%d, y=%d\n", x, y));
 *
 *      dleave(str);
 *
 *              This will display a message undented two more spaces than what
 *      it is currently indented.  The dleave call will have no effect it is
 *      up against the left margin
 *
 *
 *      indent();
 *
 *              This will cause the debug output to be indented two more than
 *      it is already.
 *
 *      undent();
 *              This will cause the debug output to be undented two more than
 *      it is already.
 *
 */


#ifndef STDBUG
#define STDBUG  STDERR
#endif
/* The preprocessor symbol MAIN must be defined in only one of the modules that
 *      wish to use the debugging macros.  It causes the global variables D_I
 *      and D_S to be properly initialized.  If MAIN is not defined then the
 *      proper external reference to these variables is set.
 */

#define D_L 70

#ifdef MAIN

extern int  D_I = 0;

extern char D_S[] =
/*1234567890123456789012345678901234567890123456789012345678901234567890*/
 "                                                                      ";

#else

extern int D_I;
extern char D_S[];
#endif

#ifdef DEBUG

#define indent()        (D_I < 35 ? D_I++ : D_I)
#define undent()        (D_I > 0  ? --D_I : D_I)
#define INS_INDENT      fprintf(STDBUG, "%s", &D_S[D_L - indent()*2])
#define DEL_INDENT      fprintf(STDBUG, "%s", &D_S[D_L - undent()*2])
#define INDENT fprintf(STDBUG, "%s", &D_S[D_L-D_I*2])
#define denter(x) (INS_INDENT, fprintf(STDBUG, "entering: %s\n", x))
#define debug(x) (INDENT, x)
#define dleave(x) (DEL_INDENT, fprintf(STDBUG, "leaving:  %s\n", x))


/*      If DEBUG is not defined then replace the 'calls' to the debugging
 *      macros by null expressions. ie. ';'.
 */

#else
#define denter(x) ;
#define debug(x) ;
#define dleave(x) ;
#define indent() ;
#define undent() ;
#endif
.
 */

#else
#define denter(x) ;
#define debug(x) ;
#define dleave(x) ;
