/*         .c                       freeware                   xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"
#include    "f___1.h"
/* --------------------------------- MAIN ----------------------------------- */
int main(void)
{
double (*P_f)(double x);
double (*PDf)(double x);

double c = 1.;
double t;
/*-------------------------------- PROGRAM ---------------------------------- */
 P_f =  f;
 PDf = Df;

 clrscrn();
 printf("  f : x-> %s\n\n",   feq);
 printf(" Df : x-> %s\n\n\n",Dfeq);

 printf(" With c = %0.3lf, the equation of the tangent is :\n\n",c);
 printf("       Df(c) (x-c) + f(c) = ");
 eq_Tan(  c,
       (*P_f),
       (*PDf)
       );
 printf("\n\n\n");

 printf(" Find AM, the length of the under tangent.\n\n");

 t =((*P_f)(c));
 printf(" P(%6.3lf, %6.3lf)           P(           c, f(c))    \n", c, t);

 t = c-(((*P_f)(c))/((*PDf)(c))) ;
 printf(" A(%6.3lf, %6.3lf)           A(c-f(c)/Df(c),    0)    \n", t, 0.);
 printf(" M(%6.3lf, %6.3lf)           M(           c,    0)\n\n\n", c, 0.);

 t = (((*P_f)(c))*(1/((*PDf)(c))));
 printf(" AM = f(c)/Df(c) = %6.3lf\n\n\n", t);

                         /* plot [xmin:xmax] [ymin:ymax] */
  gplt_TanxM   (-4,      /* xmin  */
                 4,      /* xmax  */
                -9,      /* ymin  */
                 2,      /* ymax  */
                 c,
               feq,
         (*P_f),
         (*PDf));

 printf(" To see the graph, open the file \"f_Df.plt\" with Gnuplot.\n\n");
 printf(" Press return to continue\n");
 getchar();

 return 0;
}

