unit Pdrivers;

INTERFACE
	uses DOS;

 (*	drivers	*)

 const Star_SR9   = 1;
       IBM9	      = 2;	(* IBM GraphPrinter,IBM ProPrinter	*)
       EPSON9	   = 3;		(* EPSON (graphic mode: Esc,'K'/'L'/'Y'/'Z')	*)
       EPSON9II   = 3;     (* EPSON (graphic mode: Esc,'*',n) *)
		 PANASONIC9 = 4;     (* Panasonic KX-P1124 - not tested *)
		 IBM9c      = 5;     (* IBM ProPrinter (color) *)
		 EPSON9c    = 5;     (* EPSON (color) (graphic mode: Esc,'K'/'L'/'Y'/'Z') *)
		 EPSON9IIc  = 6;     (* EPSON (color) (graphic mode: Esc,'*',n) *)
		 EPSON24    = 7;     (* 24 pins EPSON compatible printer *)
		 IBM24      = 8;     (* 24 pins IBM compatible printer *)
		 EPSON24c   = 9;     (* 24 pins EPSON compatible color printer *)
									(*  not tested *)
		 IBM24c     = 10;     (* 24 pins IBM compatible color printer *)
									(*  not tested *)
		 PaintJet   = 11;    (* Paint Jet  *)
		 HPPaintJet = 12;    (* HP Paint Jet *)
		 HPLJ       = 13;    (* Laser Jet *)
		 HPLJII     = 14;    (* HP Laser Jet *)

 (* modes for particular drivers *)

   (* EPSON9   *)
      const  EPSON9_60x72     = 0;
      const  EPSON9_120x72    = 1;
      const  EPSON9_120x216   = 2;
      const  EPSON9_240x216   = 3;
   (* STAR_SR9    *)
      const  STAR_SR9_60x72       = 0;
      const  STAR_SR9_120x72      = 1;
      const  STAR_SR9_120x144     = 2;
      const  STAR_SR9_240x144     = 3;
   (* IBM9     *)
      const  IBM9_60x72       = 0;
      const  IBM9_120x72      = 1;
      const  IBM9_120x216     = 2;
      const  IBM9_240x216     = 3;
   (* EPSON24  *)
      const  EPSON24_60x180    = 0;
      const  EPSON24_120x180   = 1;
      const  EPSON24_180x180   = 2;
      const  EPSON24_360x180   = 3;
      const  EPSON24_360x360   = 4;
   (* IBM24    *)
      const  IBM24_60x180    = 0;
      const  IBM24_120x180   = 1;
      const  IBM24_180x180   = 2;
      const  IBM24_360x180   = 3;
   (* PaintJet   *)
      const  PaintJet_90x90       = 0;
      const  PaintJet_180x180     = 1;
      const  PaintJet_90x90c      = 2;
      const  PaintJet_180x180c    = 3;
   (* HPPJ   *)
      const  HPPJ_90x90       = 0;
      const  HPPJ_180x180     = 1;
      const  HPPJ_90x90c      = 2;
      const  HPPJ_180x180c    = 3;
   (* HP LaserJet   *)
      const  HPLJ_75x75      =  0;
      const  HPLJ_100x100    =  1;
      const  HPLJ_150x150    =  2;
      const  HPLJ_300x300    =  3;
   (* HPLJII   *)
      const  HPLJII_75x75      =  0;
      const  HPLJII_100x100    =  1;
      const  HPLJII_150x150    =  2;
      const  HPLJII_300x300    =  3;



Type IntegerArray=array[0..100] of integer;
     IntegerArrayPtr = ^IntegerArray;
     PRT__DriversHeadT = record
                Ident                    : integer;          (* file identification *)
                size                     : integer;            (* header size *)
                version                  : integer;
                minversion               : integer;
                DriversNo                : integer;
                DriversOffsetsIndex      : integer;
                DriversNamesIndex        : integer;
                DriversDefOffsets: array[1..224] of integer;
       end;


Const PRT__DriversPtr: pointer = nil;
		PRT__DriversHeadPtr: ^PRT__DriversHeadT = nil;      (* pointer to head of drivers file *)
		PRT__DriversNamesPtr: pointer = nil; (* pointer to names part of drivers file *)
		PRT__DriversNamesSize: integer = -1; (* size of names part of drivers file *)
		PRT__DriversFileName: string[12] ='Printers.def';
		PRT__CurDriverPtr: IntegerArrayPtr=nil;
		PRT__CurDriverNo: integer=-1;

Var
		PRT__DriversFile: file;  (* drivers file handle *)


Function PRT_GetDriversAddress: pointer;


IMPLEMENTATION

uses PRTGraph;

Function PRT_GetDriversAddress: pointer; External;
			{$L Drivers <------------------------------------------- }
			{ If you didn't compile file Drivers.asm you don't have
			  DRIVERS.OBJ  file. Delete or rename this file in that
			  case and make will take existing TPU file. }
			{ ------------------------------------------------------ }

END {unit Pdrivers}.