org 100h

;read data from hard disk into memory
    mov  bx,data_buffer
    mov  cx,1h
    mov  dx,80h  ;cx and dx are drive, cylinder, head, sector
    mov  ax,204h   ;al=04 is number of sectors to read
    int  13h
    jc  read_failed

;create/overwrite and open file for write, return filehandle in ax
    mov  ah,3Ch
    xor  cx,cx  ;cx=0 means no read only, hidden, system, etc attributes
    mov  dx,filename
    int  21h
    jc  open_failed

;write data to file
    mov  bx,ax   ;filehandle
    mov  ah,40h
    mov  cx,4*512   ;number of bytes to write
    mov  dx,data_buffer
    int  21h
    jc   write_failed

;make sure the correct number of bytes was written to the file
    cmp  ax,cx
    jne  write_incomplete

;close file
    ;don't bother to close the file; it should close automatically when
    ;we exit

;exit
    mov  ax,4C00h  ;00 is exit code
    int  21h


;errors
read_failed:
    mov  ax,4C01h
    int  21h
open_failed:
    mov  ax,4C02h
    int  21h
write_failed:
    mov  ax,4C03h
    int  21h
write_incomplete:
    mov  ax,4C04h
    int  21h

filename:  db 'mbs4s.bin',0
data_buffer:
