{$debug-}
{$line-}

{$include: 'types.int'}
{$include: 'globals.int'}
{$include: 'ident.int'}
{$include: 'utils.int'}
{$include: 'fs_pkg.int'}
{$include: 'database.int'}
{$include: 'load.int'}
{$include: 'sutils.int'}
{$include: 'script1.int'}

IMPLEMENTATION OF script1;

USES types,globals,ident,utils,fs_pkg,database,load,sutils;

{DLX Bulletin Board System V7.0

 FREEWARE NOTICE

 DLX V7.0 is placed in the public domain by its author, Richard Gillmann.
 Anyone who wishes to may run the program, copy it, or modify it for
 any purpose, including commercial gain.}

{***INTERFACE TO THE COM_PAX2 ASYNCHRONOUS COMMUNICATIONS PACKAGE***}
{$include: 'com_pax2.int'}

{***Interface to the assembler utilities packages***}
{$include: 'pasasm.int'}
{$include: 'newasm.int'}

procedure bbs1{consts s : lstring; var str : lstring};
var
  i,j : integer;
  next_state : task;
  p : para;
  c : char;
  fl : boolean;

begin
  next_state:=succ(q[wx].state);
  case q[wx].state of
  main_menu: prompt_with(main_menu_txt);
  main_fork:
    [next_state:=main_menu;
     if time_check(true) then
       [display(time_limit_txt); next_state:=snip]
     else if str=null then
        display(dunno_txt)
     else if str='VERSION' then {version}
       [p:=newpara('DLX 7.00');
        w^[wx].output:=p; w^[wx].crud:=true; myid;
        w^[wx].node_type:=nt_display; next_state:=main_menu]
{normal commands}
     else if str.len=1 and then str[1]=mn[4][1] then {?}
       display(main_menu_list_txt)
     else if str.len=1 and then str[1]=mn[4][2] then {A}
       [if q[wx].level>=priv_ans then
          [display(answer_again_txt); next_state:=answer]
        else
          display(read_access_txt)]
     else if str.len=1 and then str[1]=mn[4][3] {B} then
       [if q[wx].level>=priv_br then
          [q[wx].return_state:=main_menu;
           display(browse_head_txt); next_state:=browse_prompt]
        else
          display(read_access_txt)]
     else if str.len=1 and then str[1]=mn[4][4] then {C}
       [display(lounge_header_txt); next_state:=chat_menu]
     else if str.len=1 and then str[1]=mn[5][5] then {D}
       [display(dbw_txt); next_state:=db1]
     else if str.len=1 and then str[1]=mn[4][5] then {E}
       [if fs_openr(wx,'EXPLAIN')=0 then
          [q[wx].return_state:=main_menu; q[wx].bflag:=true;
           next_state:=display_file]
       else
         [fs_close(wx); next_state:=main_menu]]
     else if str.len=1 and then str[1]=mn[4][6] then {F}
       display(facts_txt)
     else if str.len=1 and then str[1]=mn[4][7] then {G}
       [q[wx].flag:=true; {allow return to main menu}
        next_state:=goodbye_menu]
     else if str.len=1 and then str[1]=mn[4][8] then {L}
       [display(libr_welcome_txt); next_state:=libr_menu]
     else if str.len=1 and then str[1]=mn[4][9] {M} then
       [if q[wx].level>=priv_ma then
          [q[wx].return_state:=main_menu;
           if business then
             [q[wx].index:=1;
              display(match_header_txt); next_state:=match_line]
           else
             [display(match_parameters_txt); next_state:=match]]
        else
          display(read_access_txt)]
     else if str.len=1 and then str[1]=mn[4][10] then {N}
       [if q[wx].level>=priv_bio then
          [if essay<>nil then
             [q[wx].return_state:=main_menu;
              display(bio_header_txt); next_state:=bio]
           else
             next_state:=main_menu]
        else
          display(read_access_txt)]
     else if str.len=1 and then str[1]=mn[5][6] then {O}
       [if q[wx].level>=priv_order then
          [if order<>nil then
             [q[wx].return_state:=main_menu;
              prompt_with(ordr_header_txt); next_state:=ordr]
           else
             next_state:=main_menu]
        else
          display(read_access_txt)]
     else if str.len=1 and then str[1]=mn[4][11] then {P}
       [if ivalue(q[wx].my.times_called)<many_calls
          then [display(pubmail_header_txt); next_state:=pubmail1]
          else [prompt_with(select_category_txt); next_state:=pubmail4]]
     else if str.len=1 and then str[1]=mn[4][12] then {R}
       [if q[wx].mbx_first=nil then
          next_state:=msgs_4u
        else
          [q[wx].count:=ivalue(q[wx].my.mbx_count); q[wx].current_msg:=0;
           display(msg_title_txt); next_state:=readmail_header]]
     else if str.len=1 and then str[1]=mn[5][1] then {S}
       [if q[wx].level>=priv_send then
          [if q[wx].holding then
             [if q[wx].hold_target=-1 then
                display(hold_error_txt)
              else
                [q[wx].return_state:=main_menu;
                 q[wx].correspondent:=q[wx].hold_target;
                 display(send_menu_list_txt); next_state:=sendmail_menu]]
           else
             [q[wx].return_state:=main_menu; q[wx].flag:=true;
              display(send_private_txt); next_state:=sendmail_prompt]]
        else
          display(read_access_txt)]
     else if str.len=1 and then str[1]=mn[5][2] {U} then
       [if q[wx].level>=priv_us then
          [q[wx].index:=userlog_next; q[wx].count:=0;
           display(userlog_head_txt); next_state:=userlog]
        else
          display(read_access_txt)]
     else if str.len=1 and then str[1]=mn[5][3] then {W}
       [q[wx].index:=number_of_lines; q[wx].return_state:=main_menu;
        display(who_header_txt); next_state:=who]
     else if str.len=1 and then str[1]=mn[5][4] {X}
             and then q[wx].level>=priv_x then
       [q[wx].cleanup:='X'; next_state:=cleanup1]
     else if str.len>2 and then
             str[1]=mn[7][2] {/} and then str[2]=mn[7][4] {P} then {/P}
       SlashP(s,str)
     else if eq(str,ss[40]) then {HELP}
       [if fs_openr(wx,'HELP')=0 then
          [q[wx].return_state:=main_menu; q[wx].bflag:=true;
           next_state:=display_file]
       else
         [fs_close(wx); next_state:=main_menu]]
     else if eq(str,ss[41]) then {NEWS}
       [if fs_openr(wx,'NEWS')=0 then
          [q[wx].return_state:=main_menu; q[wx].bflag:=true;
           next_state:=display_file]
        else
          [fs_close(wx); next_state:=main_menu]]
     else if eq(str,ss[42]) then {NOWRAP}
       [w^[wx].wrapat:=79; setwrap(79)]
     else if eq(str,ss[44]) then {NEWPASSWORD}
       [prompt_with(enter_pw_txt); next_state:=newpass]
     else if eq(str,ss[45]) or else eq(str,ss[46]) then {TIME, DATE}
       display(date_time_txt)
     else if eq(str,ss[47]) then {WRAP}
       [w^[wx].wrapat:=wrap_column; setwrap(wrap_column)]
{sysop commands}
     else if q[wx].level=9 and then str[1]='!' then begin
     if str='!C' and then (not q[wx].holding) then
       [q[wx].return_state:=main_menu; q[wx].flag:=false; {canned msg}
        display(send_private_txt); next_state:=sendmail_prompt]
     else if str='!D' then
       [q[wx].return_state:=main_menu;
        prompt_with(delete_user_txt); next_state:=delete_user]
     else if str='!J' then
       [prompt_with(send_junkmail_txt); next_state:=junk1]
     else if str='!K' then
       [prompt_with(kill_line_txt); next_state:=kill_line]
     else if str='!L' then
       [q[wx].return_state:=main_menu;
        prompt_with(change_level_txt); next_state:=change_level]
     else if str='!M' then
       [q[wx].return_state:=main_menu;
        prompt_with(change_mbx_txt); next_state:=change_mbx]
     else if str='!N' then
       [if allow_new
          then [allow_new:=false; display(nonew1s_txt)]
          else [allow_new:=true; display(new1s_txt)]]
     else if str='!O' then
       [q[wx].return_state:=main_menu;
        prompt_with(delete_old_txt); next_state:=delete_old]
     else if str='!R' then
       [prompt_with(recycle_txt); next_state:=recycle]
     else if str='!T' then
       [q[wx].return_state:=main_menu;
        prompt_with(reset_time_txt); next_state:=reset_time]
     else if str='!UA' then
       [prompt_with(unanswer_txt); next_state:=unans1]
     else if str='!UD' then
       [prompt_with(undel_user_txt); next_state:=undel_user]
     else if str='!X' then
       [q[wx].cleanup:='X'; q[wx].sysop:=true; next_state:=cleanup1]
     else if str='!DOWN' then
       [prompt_with(minutes_left_txt); next_state:=down1]
     else if str='!BYE' then
       [q[wx].cleanup:='Q'; next_state:=cleanup1]
     else if str='!DOS' or else crc_ls(str)=16#489A then
       [prompt_with(null_txt); next_state:=maint]
{unknown command}
     else [display(dunno_txt); if wx>0 then purge_com] end {sysop cmd}
     else [display(dunno_txt); if wx>0 then purge_com]];   {normal cmd}
  junk1: {To male, female, new, all}
    if str.len>0 then
      [p:=newpara(ss[21]); concat(p^.msg,': '); konkat(p^.msg,q[wx].my.name);
       cat(p^.msg,q[wx].my.userid); q[wx].msg_first:=p; q[wx].msg_last:=p;
       p:=newpara(ss[20]); concat(p^.msg,': '); konkat(p^.msg,s);
       if q[wx].msg_to=nill
         then q[wx].msg_to:=newpara(s)
         else kopylst(s,q[wx].msg_to^.msg);
       q[wx].msg_last^.link:=p; q[wx].msg_last:=p;
       p:=newpara(ss[23]); concat(p^.msg,': '); {Date: }
       cat(p^.msg,mydate); cat(p^.msg,mytime); q[wx].flag:=true; {not canned}
       q[wx].msg_last^.link:=p; q[wx].msg_last:=p; q[wx].return_state:=junk2;
       prompt_with(enter_subject_txt); next_state:=enter_subject]
    else
      next_state:=main_menu;
  junk2: {we come back here after composing the message}
    if q[wx].index>=largest_member_number then {message cancelled}
      next_state:=junk4
    else
      [kopylst(mailpath,str);
       if uc(q[wx].msg_to^.msg[1])<>mn[8][2] {N} then
         concat(str,d_junk)
       else
         [concat(str,d_new); q[wx].index:=largest_member_number];
       mail_delete(str); {old junk/newuser mail}
       q[wx].handle:=mult_open(str,0);
       if q[wx].handle<=0 then
         [q[wx].index:=largest_member_number;
          display(mail_not_sent_txt); next_state:=junk4]
       else
         [eval(encode(str,(q[wx].send_line_count+4):3));
          mail_writeln(q[wx].handle,str)]];
  junk3: {copy junk message to file, line by line}
    if q[wx].msg_first=nill then
      [mail_close(q[wx].handle); q[wx].handle:=0;
       if w^[wx].file_locked<>nill then w^[wx].file_locked^.msg:=null;
       if uc(q[wx].msg_to^.msg[1])=mn[8][2] {N} then
         q[wx].index:=largest_member_number;
       q[wx].msg_last:=nill; display(mail_sent_txt)]
    else
      [kopylst(q[wx].msg_first^.msg,str); mail_writeln(q[wx].handle,str);
       p:=q[wx].msg_first^.link; dispara(q[wx].msg_first);
       q[wx].msg_first:=p; next_state:=junk3];
  junk4: {mark members file, user by user}
    [q[wx].index:=q[wx].index+1;
     if q[wx].index<=largest_member_number then
       [if disk2u(q[wx].index) then
          [c:=uc(q[wx].msg_to^.msg[1]);
	   if ivalue(q[wx].your.userlevel) >= priv_junk and then
              (business or
	       ((c<>mn[2][1] {M}) and (c<>mn[2][2] {F})) or
               (c=q[wx].your.gender[1])) then {you get junk mail}
             [i:=on_line(q[wx].index);
              if i>=0 then
                q[i].my.junk[1]:='J'
              else if q[wx].your.junk[1]=' ' then
                [q[wx].your.junk[1]:='J';
                 if encode(str,(ivalue(q[wx].your.mbx_count)+1):1)
                   then kopystr(str,q[wx].your.mbx_count);
                 dbp_member(q[wx].index,q[wx].your)];
              display(junkmail_sent_txt); next_state:=junk4]
           else {you don't get junk mail}
             [i:=on_line(q[wx].index);
              if i>=0 then
                q[i].my.junk[1]:=' '
              else if q[wx].your.junk[1]='J' then
                [q[wx].your.junk[1]:=' ';
                 if encode(str,(ivalue(q[wx].your.mbx_count)-1):1)
                   then kopystr(str,q[wx].your.mbx_count);
                 dbp_member(q[wx].index,q[wx].your)];
              next_state:=junk4]]
        else
          next_state:=junk4]
     else
       [disparas(q[wx].msg_first); q[wx].msg_last:=nill;
        next_state:=main_menu]];
  chat_menu: prompt_with(lounge_menu_txt);
  chat_lounge:
    [next_state:=chat_menu;
     if time_check(true) then
       [display(time_limit_txt); next_state:=snip]
     else if str=null or else str[1]=mn[6][8] {Q} then
       [display(lounge_exit_txt); next_state:=main_menu]
     else if str[1]=mn[6][2] {A} then
       [q[wx].my.chat_ok[1]:=' '; display(ok_txt)]
     else if str[1]=mn[6][3] {B} then
       [if q[wx].level>=priv_br then
          [q[wx].return_state:=chat_menu;
           display(browse_head_txt); next_state:=browse_prompt]
        else
          display(read_access_txt)]
     else if str[1]=mn[6][4] {C} then
       [if q[wx].level>=priv_bchatted
         then [prompt_with(chat_target_txt); next_state:=chat]
         else display(read_access_txt)]
     else if str[1]=mn[6][11] {I} then
       display(chat_info_txt)
     else if str[1]=mn[6][12] {L} then
       [q[wx].my.chat_ok[1]:='L'; display(lochat_txt)]
     else if str[1]=mn[6][5] {N} then
       [q[wx].my.chat_ok[1]:='N'; display(nochat_txt)]
     else if str[1]=mn[6][6] {O} then
       [if q[wx].level>=priv_gchat then
          [if channels>1 then
             [prompt_with(which_channel_txt); next_state:=gchat_ch1]
           else
	     [q[wx].channel:=1; next_state:=gchat_ch2]]
        else
          display(read_access_txt)]
     else if str[1]=mn[6][7] {P} then
       [q[wx].my.chat_ok[1]:='P'; display(nopage_txt)]
     else if str[1]=mn[6][9] {T} then {440 Hz beep}
       [if q[wx].paging_beeps<3 then
          [q[wx].paging_beeps:=q[wx].paging_beeps+1;
           if beep_length>0 then
             [beep_on(1331);
              clock_reset; while clock<beep_length do ;
              beep_off];
           if q[wx].paging_beeps=1 then
             [i:=ord(w^[wx].stat_char^.msg.len)+1;
              if i<60 then i:=60;
              newstat(wx,i,blink,ss[34])]; {PAGE}
           display(chat_txt)]
        else
          next_state:=snip]
     else if str[1]=mn[6][10] {W} then
       [q[wx].index:=number_of_lines; q[wx].return_state:=chat_menu;
        display(who_header_txt); next_state:=who]
     else if str[1]=mn[6][1] {?} or else eq(str,ss[40]) then {HELP}
       display(lounge_help_txt)
     else if str.len>2 and then
             str[1]=mn[7][2] {/} and then str[2]=mn[7][4] {P} then {/P}
       SlashP(s,str)
     else
       [display(dunno_txt); next_state:=chat_menu]];
  chat:
    if ok2bother(s,i) and then i<>wx and then
       ((q[wx].level>=priv_chat) or (q[i].level>=priv_chat)) then
      [q[wx].index:=i;
       movel(adr q[i].my,adr q[wx].your,member_length);
       if w^[i].chat>=0 or else q[i].state2>0 or else
          ((q[wx].level<9) and
           ((not q[i].logged_in) or
            (q[i].level<priv_bchatted) or
            ((not chat_repeats) and ((q[i].userid=q[wx].last_chat) or
                                     (q[wx].userid=q[i].last_chat))) or
            (q[i].my.chat_ok[1]<>' ') or
            q[i].group_chat or
            ((q[i].state=display_file) and (q[i].return_state=whoelse)) or
            (q[i].state in [news..msgs_4u,
	    		    mail_gimme1..mail_gimme1j,
			    questionnaire..filing_it,
                            libr_transfer..libr_post_up,
                            sendmail_prompt..sendmail_cancel,
			    pubmail_send1..pubmail_send2,
			    ordr..ordr6,
                            bio..bio4,
			    snip..dummy]))) then
         [if (not q[i].logged_in) or else (q[i].my.chat_ok[1]='P') or else
             (q[i].level<priv_bchatted) or else
             ((not chat_repeats) and ((q[i].userid=q[wx].last_chat) or
                                      (q[wx].userid=q[i].last_chat))) then
            [prompt_with(lounge_menu_txt); next_state:=chat_lounge]
          else
            [notify(i,wanna_chat_txt);
             display(busy_txt); next_state:=chat_menu]]
       else
         [w^[wx].chat:=i; w^[i].chat:=wx;
	  w^[wx].more:=32000; w^[i].more:=32000; {no page pause in chat}
          q[wx].last_chat:=q[i].userid; q[i].last_chat:=q[wx].userid;
          if q[wx].level=9 and then ss[34].len>0 then
            [str.len:=ss[34].len; {PAGE}
             fillc(adr str[1],str.len,' '); q[i].paging_beeps:=0;
             for j:=60 to screen_cols-ord(str.len)+1 do
               if w^[i].stat_attr^.msg[j]=chr(blink) then
                 [newstat(i,j-1,iattr,str); break]];
          w^[wx].chat_warned:=false; w^[i].chat_warned:=false;
          w^[wx].chatintro:=zip(entering_chat_txt);
          w^[i].chatintro:=zip(entering_chat_txt);
          w^[wx].ch0:=jt; w^[i].ch0:=jt;
          if w^[i].output=nill then
            [w^[i].output:=zip(exiting_chat_txt); w^[i].crud:=true];
          display(exiting_chat_txt); next_state:=chat_menu]]
    else
      [display(bad_fileno_txt); next_state:=chat_menu];
  gchat_ch1:
    if time_check(true) then
      [display(time_limit_txt); next_state:=snip]
    else if number_query(s,1,channels,i)
      then q[wx].channel:=wrd(i)
      else [prompt_with(lounge_menu_txt); next_state:=chat_lounge];
  gchat_ch2: {announce entrance}
    [q[wx].group_chat:=true;
     if q[wx].userid>=log_lowest then
       for i:=0 to number_of_lines do
         if i<>wx and then gc(i) and then q[wx].channel=q[i].channel then
           notify(i,new_txt);
     disparas(q[wx].xstr); setwrap(wrap_column-10); eval(hard_cr);
     display(gce_txt)];
  gchat_menu: [prompt_with(null_txt); w^[wx].more:=-MAXINT];
  gchat:
    if time_check(true) then
      [display(time_limit_txt); next_state:=snip]
    else if str.len>1 and then str[1]=mn[7][2] {/} and then
            str[2]<>mn[7][4] {P} then
      [delete(str,1,1);
{/? help}
       if str[1]=mn[7][1] {?} or else eq(str,ss[40]) then {HELP}
         [display(gch_txt); next_state:=gchat_menu]
{/B browse}
       else if str[1]=mn[7][3] {B} and then q[wx].level>=priv_br then
         [q[wx].return_state:=gchat_menu;
          display(browse_head_txt); next_state:=browse_prompt]
{/Q quit}
       else if str[1]=mn[7][5] {Q} then
         [sayanora;
          prompt_with(lounge_menu_txt); next_state:=chat_lounge]
{/W who}
       else if str[1]=mn[7][6] {W} then
         [q[wx].index:=number_of_lines; q[wx].return_state:=gchat_menu;
          display(who_header_txt); next_state:=who]
{/X squelch}
       else if str[1]=mn[7][7] {X} then
         [delete(str,1,1);
          for i:=1 to ord(str.len) do
	    if str[i]>'9' or else str[i]<'0' then [str[0]:=chr(i-1); break];
          if decode(str,j) then
            if j=q[wx].squelch
              then q[wx].squelch:=0
              else q[wx].squelch:=j;
          display(squ_txt); next_state:=gchat_menu]
       else
         [display(gcx_txt); next_state:=gchat_menu]]
    else
      [if s<>null then
	 [p:=q[wx].xstr; fl:=true; q[wx].count:=0;
	  while p<>nill and then p^.link<>nill do
	    [p:=p^.link; q[wx].count:=q[wx].count+1];
	  if p=nill
	    then [q[wx].xstr:=newpara(s); q[wx].count:=1]
	    else [p^.link:=newpara(s); q[wx].count:=q[wx].count+2]];
       if hard_cr or else q[wx].count>(notify_max div 3) then
         [fl:=true;
	  if q[wx].xstr^.msg.len>1 and then q[wx].xstr^.msg[1]=mn[7][2] {/}
	     and then uc(q[wx].xstr^.msg[2])=mn[7][4] {P} then
{/P private}
            [copylst(q[wx].xstr^.msg,str); delete(str,1,2);
             for i:=1 to ord(str.len) do
	       if str[i]>'9' or else str[i]<'0' then
	         [str[0]:=chr(i-1); break];
             fl:=false;
	     if ok2bother(str,i) and then
		((q[wx].level=9) or
	          ((q[i].logged_in) and
		   ((q[i].my.chat_ok[1]=' ') or
	            ((q[i].my.chat_ok[1]<>'P') and p2chatoff) or
		    gc(i)))) then
		[fl:=true;
		 if q[wx].level=9 or else q[wx].userid<>q[i].squelch then
		   [p:=q[wx].xstr;
		    while q[wx].xstr<>nill do
		      [notify(i,gcl_txt);
		       spydump;
		       q[wx].xstr:=q[wx].xstr^.link];
		    q[wx].xstr:=p]]]
{normal group chat line}
	  else
            [p:=q[wx].xstr;
             while q[wx].xstr<>nill do
               [for i:=0 to number_of_lines do
                  if gc(i) and then q[wx].channel=q[i].channel and then
		     q[i].squelch<>q[wx].userid
		    then notify(i,gcl_txt);
		spydump;
	        q[wx].xstr:=q[wx].xstr^.link];
             q[wx].xstr:=p];
	  disparas(q[wx].xstr);
          if fl
            then [prompt_with(null_txt); next_state:=gchat]
            else [display(gcx2_txt); next_state:=gchat_menu]]
       else
         [prompt_with(null_txt); next_state:=gchat]];
  delete_user:
    if s=null then
      next_state:=q[wx].return_state
    else if number_query(s,1,largest_member_number,i) then
      [if disk2u(i)
         then prompt_with(user_delete_txt)
         else [display(bad_userid_txt); next_state:=q[wx].return_state]]
    else
      [display(bad_userid_txt); next_state:=q[wx].return_state];
  delete_user2:
    if nagree(s) then
      [display(user_deleted_txt); q[wx].your.active[1]:=' ';
       i:=on_line(ivalue(q[wx].your.userid));
       if i>=0 then
         [q[i].my.active[1]:=' '; w^[i].state:=stopping]
       else
         [kopystr('  3',q[wx].your.mbx_count);
          dbp_member(ivalue(q[wx].your.userid),q[wx].your)];
       mbx(mailpath,q[wx].your.userid,str); mail_delete(str);
       mbx(biopath,q[wx].your.userid,str); mail_delete(str);
       number_of_members:=number_of_members-1; next_state:=q[wx].return_state]
    else
      next_state:=q[wx].return_state;
  undel_user:
    if s=null then
      next_state:=main_menu
    else if number_query(s,1,largest_member_number,i) then
      [if not disk2u(i)
         then [q[wx].your.active[1]:='T'; prompt_with(user_undel_txt)]
         else [display(good_userid_txt); next_state:=main_menu]]
    else
      [display(bad_userid_txt); next_state:=main_menu];
  undel_user2:
    [next_state:=main_menu;
     if agree(s) then
       [dbp_member(ivalue(q[wx].your.userid),q[wx].your);
        number_of_members:=number_of_members+1;
        display(user_undeled_txt)]
     else
       q[wx].your.active[1]:=' '];
  end {case};
  q[wx].state:=next_state;
end {bbs1};

END.
