/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                                                                          */
/*      ------------         Bit-Bucket Software, Co.                       */
/*      \ 10001101 /         Writers and Distributors of                    */
/*       \ 011110 /          Freely Available<tm> Software.                 */
/*        \ 1011 /                                                          */
/*         ------                                                           */
/*                                                                          */
/*              (C) Copyright 1987-96, Bit Bucket Software Co.              */
/*                                                                          */
/*         This module was originally written by Vince Perriello            */
/*                                                                          */
/*                  BinkleyTerm Windows NT VFOSSIL module                   */
/*                                                                          */
/*                                                                          */
/*    For complete  details  of the licensing restrictions, please refer    */
/*    to the License  agreement,  which  is published in its entirety in    */
/*    the MAKEFILE and BT.C, and also contained in the file LICENSE.260.    */
/*                                                                          */
/*    USE  OF THIS FILE IS SUBJECT TO THE  RESTRICTIONS CONTAINED IN THE    */
/*    BINKLEYTERM  LICENSING  AGREEMENT.  IF YOU DO NOT FIND THE TEXT OF    */
/*    THIS  AGREEMENT IN ANY OF THE  AFOREMENTIONED FILES,  OR IF YOU DO    */
/*    NOT HAVE THESE FILES,  YOU  SHOULD  IMMEDIATELY CONTACT BIT BUCKET    */
/*    SOFTWARE CO.  AT ONE OF THE  ADDRESSES  LISTED BELOW.  IN NO EVENT    */
/*    SHOULD YOU  PROCEED TO USE THIS FILE  WITHOUT HAVING  ACCEPTED THE    */
/*    TERMS  OF  THE  BINKLEYTERM  LICENSING  AGREEMENT,  OR  SUCH OTHER    */
/*    AGREEMENT AS YOU ARE ABLE TO REACH WITH BIT BUCKET SOFTWARE, CO.      */
/*                                                                          */
/*                                                                          */
/* You can contact Bit Bucket Software Co. at any one of the following      */
/* addresses:                                                               */
/*                                                                          */
/* Bit Bucket Software Co.        FidoNet  1:104/501, 1:343/491             */
/* P.O. Box 460398                AlterNet 7:42/1491                        */
/* Aurora, CO 80046               BBS-Net  86:2030/1                        */
/*                                Internet f491.n343.z1.fidonet.org         */
/*                                                                          */
/* Please feel free to contact us at any time to share your comments about  */
/* our software and/or licensing policies.                                  */
/*                                                                          */
/*--------------------------------------------------------------------------*/

/* Include this file before any other includes or defines! */

/* #include "includes.h" */

#ifndef _WIN32
#pragma message("This Module For Windows NT")
#else

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <io.h>
#include <time.h>
#include <memory.h>
#include <windows.h>

#include "vfossil.h"

extern VIOMODEINFO vfos_mode;
extern int vfossil_installed;

static unsigned long saved_key = 0xFFFFFFFF;
static HANDLE hConsoleInput = INVALID_HANDLE_VALUE;
static HANDLE hConsoleOutput = INVALID_HANDLE_VALUE;

char
*SzVersionString(void)
{
	char *p;
	OSVERSIONINFO osvi;
	BOOL fResult;

	ZeroMemory (&osvi, sizeof (OSVERSIONINFO));
	osvi.dwOSVersionInfoSize = sizeof (OSVERSIONINFO);
	fResult = GetVersionEx (&osvi);
	if (!fResult || osvi.dwPlatformId == VER_PLATFORM_WIN32_NT)
		p = "Win NT";
	else if (osvi.dwPlatformId == VER_PLATFORM_WIN32_WINDOWS)
		p = "Win 95";
	else if (osvi.dwPlatformId == VER_PLATFORM_WIN32s)
		p = "Win32s";
	else p = "Win32?";

	return p;
}


void 
Make_Sound (char *WaveFile)
{
	if (WaveFile == NULL)
		return;
	PlaySound (WaveFile, 0L, (SND_FILENAME | SND_ASYNC | SND_NOWAIT));
}

short 
KBHit (void)
{
	int iKey = 0;
	INPUT_RECORD irBuffer;
	DWORD pcRead;

	if (saved_key != 0xFFFFFFFF)
	{
		return (short) (saved_key);
	}

	/* zero out input record structure */

	memset (&irBuffer, 0, sizeof (INPUT_RECORD));

	if (hConsoleInput == INVALID_HANDLE_VALUE)
	{
		hConsoleInput = GetStdHandle (STD_INPUT_HANDLE);
		if (hConsoleInput == INVALID_HANDLE_VALUE)
		{
			fprintf (stderr, "\nFailed to open console handle!\n");
			exit (3);
		}
	}

	if (WaitForSingleObject (hConsoleInput, 0L) == 0)
#if 0
	{
		ReadConsoleInput (hConsoleInput, &irBuffer, 1, &pcRead);
		if (irBuffer.EventType == KEY_EVENT && irBuffer.Event.KeyEvent.bKeyDown != 0)
			iKey = irBuffer.Event.KeyEvent.wVirtualKeyCode;
	}
#endif
	{
		ReadConsoleInput (hConsoleInput, &irBuffer, 1, &pcRead);
		if (irBuffer.EventType == KEY_EVENT &&
			irBuffer.Event.KeyEvent.bKeyDown != 0 &&
			irBuffer.Event.KeyEvent.wRepeatCount <= 1)
		{
			unsigned short vk;
			unsigned short vs;
			unsigned char uc;
			BOOL fShift;
			BOOL fAlt;
			BOOL fCtrl;

			vk = irBuffer.Event.KeyEvent.wVirtualKeyCode;
			vs = irBuffer.Event.KeyEvent.wVirtualScanCode;
			uc = irBuffer.Event.KeyEvent.uChar.AsciiChar;

			fShift = (irBuffer.Event.KeyEvent.dwControlKeyState & (SHIFT_PRESSED));
			fAlt = (irBuffer.Event.KeyEvent.dwControlKeyState & (RIGHT_ALT_PRESSED + LEFT_ALT_PRESSED));
			fCtrl = (irBuffer.Event.KeyEvent.dwControlKeyState & (RIGHT_CTRL_PRESSED + LEFT_CTRL_PRESSED));
#if 0
			printf ("VK=%x,VS=%x,uChar=%x\n", vk, vs, uc);
			printf ("SHIFT=%s,ALT=%s,CTRL=%s\n",
				fShift ? "ON" : "OFF",
				fAlt ? "ON" : "OFF",
				fCtrl ? "ON" : "OFF");
#endif
			/* The following is ugly, incomplete and nonportable.
            ** It mostly handles Fkeys; Alt+Fkeys; Shift+FKeys;
            ** Printable charactes; Alt+printable characters;
            ** Ctrl+printable characters.
            */

			if (uc == 0)							/* FKeys */
			{
				if (vk == 0x21)						/* PG UP */
				{
					if (fCtrl)						/* Special case     */
						vs = 0x84;					/* CTRL+PG UP       */
				}
				else if (vk == 0x22)				/* PG DN */
				{
					if (fCtrl)						/* Special case     */
						vs = 0x76;					/* CTRL+PG DN       */
				}
				else if (vk == 0x23)				/* END */
				{
					if (fCtrl)						/* Special case     */
						vs = 0x75;					/* CTRL+END         */
				}
				else if (vk == 0x24)				/* HOME */
				{
					if (fCtrl)						/* Special case     */
						vs = 0x77;					/* CTRL+HOME        */
				}
				else if (vk == 0x26)				/* UP AR */
				{
					if (fCtrl)						/* Special case     */
						vs = 0x8D;					/* CTRL+UP AR       */
				}
				else if (vk == 0x28)				/* DN AR */
				{
					if (fCtrl)						/* Special case     */
						vs = 0x91;					/* CTRL+DN AR       */
				}
				else if (vk >= 0x70 && vk <= 0x79)	/* FKeys */
				{
					if (fAlt)
						vs += 0x2d;					/* Hack Alt+FKey    */
					else if (fShift)
						vs += 0x19;					/* Hack Shift+Fkey  */
				}
				if (vk > 0x20 && vk < 0x92)			/* If it's OK   */
					iKey = (vs << 8);				/* use scan code    */
			}
			else
			{
				if (fAlt)							/* Hack Alt Key     */
					iKey = (vs << 8);
				else if (fCtrl)						/* Hack Ctrl Key    */
					iKey = (vk & 0xBF);
				else
					iKey = uc;
			}
#if 0
			printf ("iKey=%04x\n", iKey);
#endif
		}
	}

	if (iKey != 0)
		saved_key = iKey;
	return (short) (iKey);
}

short 
GetKBKey (void)
{
	int iKey;

	while (saved_key == 0xFFFFFFFF)
	{
		(void) KBHit ();
	}
	iKey = saved_key;
	saved_key = 0xFFFFFFFF;
	return (short) (iKey);
}

void 
vfossil_init (void)
{
	PVIOMODEINFO q = &vfos_mode;

	CONSOLE_SCREEN_BUFFER_INFO csbi;

	if (hConsoleOutput == INVALID_HANDLE_VALUE)
	{
		hConsoleOutput = GetStdHandle (STD_OUTPUT_HANDLE);
		if (hConsoleOutput == INVALID_HANDLE_VALUE)
		{
			fprintf (stderr, "\nFailed to open console handle!\n");
			exit (3);
		}
	}

	if (!GetConsoleScreenBufferInfo (hConsoleOutput, &csbi))
		return;

	memset ((void *) q, 0, sizeof (VIOMODEINFO));
	q->cb = sizeof (VIOMODEINFO);
	q->col = csbi.dwSize.X;
	q->row = csbi.dwSize.Y;
	vfossil_installed = 1;
}

void 
vfossil_cursor (int st)
{
	CONSOLE_CURSOR_INFO cci;

	if (hConsoleOutput == INVALID_HANDLE_VALUE)
		vfossil_init ();

	if (!GetConsoleCursorInfo (hConsoleOutput, &cci))
		return;

	if (cci.bVisible != (st != 0))
	{
		cci.bVisible = (st != 0);
		SetConsoleCursorInfo (hConsoleOutput, &cci);
	}
}

void 
vfossil_close (void)
{
#if 0
	if (hConsoleOutput != INVALID_HANDLE_VALUE)
	{
		vfossil_cursor (1);
		(void) CloseHandle (hConsoleOutput);
		hConsoleOutput = INVALID_HANDLE_VALUE;
	}
	vfossil_installed = 0;
#else
	vfossil_cursor (1);
#endif
}

void 
fossil_gotoxy (int col, int row)
{
	COORD dwCursorPosition;

	if (hConsoleOutput == INVALID_HANDLE_VALUE)
		vfossil_init ();

	dwCursorPosition.X = col;
	dwCursorPosition.Y = row;

	(void) SetConsoleCursorPosition (hConsoleOutput, dwCursorPosition);
}

int 
fossil_wherex (void)
{
	CONSOLE_SCREEN_BUFFER_INFO csbi;

	if (hConsoleOutput == INVALID_HANDLE_VALUE)
		vfossil_init ();

	if (!GetConsoleScreenBufferInfo (hConsoleOutput, &csbi))
		return 1;

	return csbi.dwCursorPosition.X;
}

int 
fossil_wherey (void)
{
	CONSOLE_SCREEN_BUFFER_INFO csbi;

	if (hConsoleOutput == INVALID_HANDLE_VALUE)
		vfossil_init ();

	if (!GetConsoleScreenBufferInfo (hConsoleOutput, &csbi))
		return 1;

	return csbi.dwCursorPosition.Y;
}

USHORT 
VioWrtTTY (PCH pchString, USHORT cbString, USHORT hvio)
{
	DWORD dwCount;
	DWORD dwWritten;
	BOOL fResult;

	if (hConsoleOutput == INVALID_HANDLE_VALUE)
		vfossil_init ();

	dwCount = cbString;
	fResult = WriteConsole (hConsoleOutput, pchString, dwCount, &dwWritten, NULL);
	return (fResult != TRUE);
}

/* Raise max to whatever you need. Change 500 to n and 1000 to 2n. */

USHORT 
VioWrtCellStr (PCH pchCellString, USHORT cbCellString, USHORT usRow, USHORT usColumn, USHORT hvio)
{
	DWORD dwWritten;
	BOOL fResult = TRUE;
	static char vchars[500];
	static WORD vattrs[500];
	COORD dwCursorPosition;

	int i, count;
	char *p;
	unsigned char *s = (unsigned char *) pchCellString;
	WORD *q;

	if (cbCellString > 1000)
		return 1;

	if (hConsoleOutput == INVALID_HANDLE_VALUE)
		vfossil_init ();

	dwCursorPosition.X = usColumn;
	dwCursorPosition.Y = usRow;

	count = cbCellString >> 1;
	for (p = vchars, q = vattrs, i = 0; i < count; i++)
	{
		*p++ = (char) (*s++);
		*q++ = (WORD) (*s++);
	}

	fResult = WriteConsoleOutputCharacter (
		hConsoleOutput,
		vchars,
		count,
		dwCursorPosition,
		&dwWritten);

	if (fResult)
	{
		fResult = WriteConsoleOutputAttribute (
			hConsoleOutput,
			vattrs,
			count,
			dwCursorPosition,
			&dwWritten);
	}
	return (fResult != TRUE);
}
#endif
