/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                                                                          */
/*      ------------         Bit-Bucket Software, Co.                       */
/*      \ 10001101 /         Writers and Distributors of                    */
/*       \ 011110 /          Freely Available<tm> Software.                 */
/*        \ 1011 /                                                          */
/*         ------                                                           */
/*                                                                          */
/*              (C) Copyright 1987-96, Bit Bucket Software Co.              */
/*                                                                          */
/*                  This module was written by Bob Hartman                  */
/*                                                                          */
/*                 BinkleyTerm Batch Receiver State Machine                 */
/*                                                                          */
/*                                                                          */
/*    For complete  details  of the licensing restrictions, please refer    */
/*    to the License  agreement,  which  is published in its entirety in    */
/*    the MAKEFILE and BT.C, and also contained in the file LICENSE.260.    */
/*                                                                          */
/*    USE  OF THIS FILE IS SUBJECT TO THE  RESTRICTIONS CONTAINED IN THE    */
/*    BINKLEYTERM  LICENSING  AGREEMENT.  IF YOU DO NOT FIND THE TEXT OF    */
/*    THIS  AGREEMENT IN ANY OF THE  AFOREMENTIONED FILES,  OR IF YOU DO    */
/*    NOT HAVE THESE FILES,  YOU  SHOULD  IMMEDIATELY CONTACT BIT BUCKET    */
/*    SOFTWARE CO.  AT ONE OF THE  ADDRESSES  LISTED BELOW.  IN NO EVENT    */
/*    SHOULD YOU  PROCEED TO USE THIS FILE  WITHOUT HAVING  ACCEPTED THE    */
/*    TERMS  OF  THE  BINKLEYTERM  LICENSING  AGREEMENT,  OR  SUCH OTHER    */
/*    AGREEMENT AS YOU ARE ABLE TO REACH WITH BIT BUCKET SOFTWARE, CO.      */
/*                                                                          */
/*                                                                          */
/* You can contact Bit Bucket Software Co. at any one of the following      */
/* addresses:                                                               */
/*                                                                          */
/* Bit Bucket Software Co.        FidoNet  1:104/501, 1:343/491             */
/* P.O. Box 460398                AlterNet 7:42/1491                        */
/* Aurora, CO 80046               BBS-Net  86:2030/1                        */
/*                                Internet f491.n343.z1.fidonet.org         */
/*                                                                          */
/* Please feel free to contact us at any time to share your comments about  */
/* our software and/or licensing policies.                                  */
/*                                                                          */
/*--------------------------------------------------------------------------*/

/* Include this file before any other includes or defines! */

#include "includes.h"

int BRInit (XMARGSP);
int BREnd (XMARGSP);
int BRTestSL (XMARGSP);
int BRCheckSL (XMARGSP);
int BRCheckFNm (XMARGSP);
int BRCheckFile (XMARGSP);
int BRFindType (XMARGSP);

typedef struct
{
	char *state_name;
	int (*state_func) (XMARGSP);
} BSTATES, *BSTATEP;

BSTATES Batch_Receiver[] =
{
	{"BRInit", BRInit},
	{"BREnd", BREnd},
	{"BR0", BRTestSL},
	{"BR1", BRCheckSL},
	{"BR2", BRCheckFNm},
	{"BR3", BRCheckFile},
	{"BR4", BRFindType},
};

int
BRInit (XMARGSP args)
{
	XON_DISABLE ();
	args->filename = calloc (1, 13);
	return ((int) args->control);
}

int
BREnd (XMARGSP args)
{
	free (args->filename);
	return ((int) args->control);
}

int
BRTestSL (XMARGSP args)
{
	if (!no_sealink)
		SENDBYTE (WANTCRC);

	args->T1 = timerset (1000);
	args->T2 = timerset (12000);

	return (BR1);
}

int
BRCheckSL (XMARGSP args)
{
	long BR1Timer;

	BR1Timer = timerset (200);
	while (!timeup (BR1Timer))
	{
		if (timeup (args->T2) || no_sealink)
		{
			args->result = Modem7_Receive_File (args->filename);
			return (BR2);
		}
		if ((args->CHR = PEEKBYTE ()) >= 0)
		{
			return (BR4);
		}
		if (timeup (args->T1))
		{
			args->result = Modem7_Receive_File (args->filename);
			return (BR2);
		}
		else
		{
			if (!CARRIER)
				return (CARRIER_ERR);
			else
				time_release ();
		}
	}

	SENDBYTE (WANTCRC);
	return (BR1);
}

int
BRCheckFNm (XMARGSP args)
{
	char buff1[20];
	char *p;
	int i;

	(void) memset (buff1, 0, 19);

	/* Was it the last file */
	if (args->result == EOT_RECEIVED)
	{
		return (SUCCESS);
	}
	/* Did we get a valid filename */
	else if (args->result == SUCCESS)
	{
		/* First set up the filename buffer */
		p = buff1;
		for (i = 0; i < 8; ++p, i++)
		{
			if (args->filename[i] != ' ')
			{
				*p = args->filename[i];
			}
			else
				break;
		}

		*p = '.';
		++p;
		*p = '\0';
		for (i = 8; i < 11; ++p, i++)
		{
			if (args->filename[i] != ' ')
			{
				*p = args->filename[i];
			}
			else
				break;
		}
		*p = '\0';

		/* Rename .REQ files */

		i = strlen (buff1) - 4;
		if ((i > 0) && (stricmp (&buff1[i], ".REQ") == 0))
		{
			buff1[i] = '\0';
			status_line (MSG_TXT(M_REC_REQ_AS), buff1, buff1, TaskNumber);
			sprintf (&buff1[i],".R%02x", TaskNumber);
		}

		(void) strcpy (args->filename, buff1);

		args->result = Xmodem_Receive_File (args->path, args->filename);
		return (BR3);
	}
	/* Otherwise, we have to exit */
	else
		return (args->result);
}

int
BRCheckFile (XMARGSP args)
{
	/* Was the file transfer good */
	if ((args->result == SUCCESS) || (args->result == SUCCESS_EOT))
	{
		return (BR0);
	}
	else
	{
		return (args->result);
	}
}

int
BRFindType (XMARGSP args)
{
	switch (args->CHR)
	{
	case SOH:
	case SYN:
		args->result = Batch_Xmodem_Receive_File (args->path, args->filename);
		return (BR3);

	case EOT:
		(void) TIMED_READ (0);
		SENDBYTE (ACK);
		return (SUCCESS);

		/*  NUL is a special case of "noise." We want to reset our timer if we
   *  see one.
   */

	case NUL:
		args->T1 = timerset (2000);

		/*  Fall-through after resetting timer */

	default:
		break;
	}

	(void) TIMED_READ (0);
	return (BR1);
}

int
Batch_Receive (char *where)
{
	XMARGS batch;
	int res;

	batch.result = 0;
	batch.path = where;
	res = state_machine ((STATEP) Batch_Receiver, &batch, 2);
	return (res);
}
