'
'  SIMPLE.BAS
'

$ERROR ALL ON
$LIB ALL OFF

DEFINT A-Z

$INCLUDE "PCL4PB.BI"
$LINK "PCL4PB.OBJ"

'declare variables
DIM RxBuffer(512+16) AS BYTE
DIM TxBuffer(512+16) AS BYTE
DIM BufSeg AS WORD
DIM Port AS INTEGER
DIM Code AS INTEGER
DIM I AS INTEGER
DIM L AS INTEGER
DIM LibVer AS INTEGER
DIM BaudCode AS INTEGER
DIM AnyKey AS STRING
DIM Rates(9) AS STRING
DIM UartString(4) AS STRING
DIM PARMS AS STRING
DIM ARG1 AS STRING
DIM ARG2 AS STRING

'init baud rate strings
Rates$(1) = "300"
Rates$(2) = "1200"
Rates$(3) = "2400"
Rates$(4) = "4800"
Rates$(5) = "9600"
Rates$(6) = "19200"
Rates$(7) = "38400"
Rates$(8) = "57600"
Rates$(9) = "115200"

'init UART type strings
UartString(0) = "8250/16450"
UartString(1) = "16550"
UartString(2) = "16650"
UartString(3) = "16750"

'get command line arguments
PARMS$ = RTRIM$(COMMAND$)
I = INSTR(PARMS$, " ")
IF I < 1 THEN
  PRINT "  Usage: SIMPLE <Port> <BaudRate>"
  PRINT "Example: SIMPLE 1 9600"
  END
END IF
L = LEN(PARMS$)
ARG1$ = LEFT$(PARMS$, I - 1)
ARG2$ = LTRIM$(RIGHT$(PARMS$, L - I))
BaudCode = -1

'Get COM port
Port = VAL(ARG1$) - 1

'Get baud code
FOR I = 1 TO 9
  IF Rates$(I) = ARG2$ THEN
     BaudCode = I
     EXIT FOR
  END IF
NEXT I

'Verify good baud rate
IF BaudCode = -1 THEN
  PRINT "Cannot recognize baud rate "; ARG2$
  STOP
END IF

' set parmameters for the port
Code = SioParms(Port,%NoParity,%OneStopBit,%WordLength8)

'setup RX buffer
BufSeg = 1 + VARSEG(RxBuffer(0)) + (VARPTR(RxBuffer(0)) \ 16)
Code = SioRxBuf(Port, BufSeg, %Size512)
IF Code < 0 THEN
  PRINT "Error "; Code; " returned from SioRxBuf()"
  Code = SioError(Code)
  STOP
END IF

IF SioInfo(ASC("I")) <> 0 THEN
  'setup TX buffer
  BufSeg = 1 + VARSEG(TxBuffer(0)) + (VARPTR(TxBuffer(0)) \ 16)
  Code = SioTxBuf(Port, BufSeg, %Size512)
  IF Code < 0 THEN
    PRINT "Error "; Code; " returned from SioTxBuf()"
    Code = SioError(Code)
    STOP
  END IF
END IF

'Reset port
Code = SioReset(Port, BaudCode)
IF Code < 0 THEN
  PRINT "Error "; Code; " returned from SioReset()"
  Code = SioError(Code)
  STOP
END IF

CLS
'display info
PRINT "SIMPLE 12/21/97"
PRINT "   Port : COM"; LTRIM$(STR$(1+Port))
PRINT "   Baud : ";Rates$(BaudCode)
LibVer = SioInfo(ASC("V"))
PRINT "Library : "; LTRIM$(STR$(LibVer \ 16)); ".";
PRINT LTRIM$(STR$(LibVer MOD 16))
PRINT "TX Intr : ";
IF SioInfo(ASC("I")) <> 0 THEN
   PRINT "enabled."
ELSE
   PRINT "not enabled."
END IF
'set DTR & RTS
Code = SioDTR(Port, %SET.LINE)
Code = SioRTS(Port, %SET.LINE)
' use FIFO if present
Code = SioFIFO(Port,%LEVEL.4TH)
PRINT "   UART : "; UartString(Code)
Code = SioFIFO(Port, %LEVEL.4TH)

PRINT
PRINT "Entering TERMINAL loop (^Z to quit)..."

DO
  'Anything incoming ?
  Code = SioGetc(Port, 1)
  IF Code = 13 THEN
    PRINT
  ELSEIF Code >= &H20 THEN
    PRINT CHR$(Code);
  END IF
  'Anything to send ?
  AnyKey$ = INKEY$
  IF AnyKey$ <> "" THEN
    'Exit if user types Control-Z
    IF AnyKey$ = CHR$(26) THEN EXIT DO
    Code = SioPutc(Port,ASC(AnyKey$))
  END IF
LOOP

Code = SioDone(Port)

END

 