10 ' 555 OSCILLATOR DESIGN
20 '
30 ' Michael A. Covington
40 ' 5339-14 North Rosemead Boulevard
50 ' San Gabriel, CA 91776
60 '
70 ' 24 July 1983
80 '
110 SCREEN 0,0,0 : WIDTH 80 : CLS : KEY OFF
120 LOCATE 10,29:  PRINT "555 OSCILLATOR DESIGN"
130 LOCATE 13,29:  PRINT "         by          "
140 LOCATE 16,29:  PRINT " Michael A. Covington"
150 LOCATE 25,26: PRINT "(Press any key to continue)";
160 IF INKEY$="" THEN 160
162 CLS: LOCATE  5,1 : PRINT,"This program helps you design astable multivi-"
164 PRINT,"brator circuits using the popular type 555 timer IC." : PRINT
166 PRINT,"The circuit diagram is given on the screen and you"
168 PRINT,"fill in values for the components; the frequency, "
170 PRINT,"period, on time, off time, and duty cycle are computed"
172 PRINT,"for you.  You can then change values if you wish."
174 PRINT
176 PRINT,"If you have an IBM Graphics Printer or a graphics"
178 PRINT,"screen dump program for your printer, you can get"
180 PRINT,"a hard copy of the circuit and its parameters at"
182 PRINT,"any time.
184 LOCATE 25,26: PRINT "(Press any key to continue)";
186 IF INKEY$="" THEN 186
200 REM  Draw diagram of 555 astable oscillator
205 ' outer boundaries of wiring
210 CLS : KEY OFF
220 LOCATE 1,12 : PRINT STRING$(42,196);
230 LOCATE 22,12 : PRINT STRING$(42,196);
240 FOR I=1 TO 22 : LOCATE I,12 : PRINT CHR$(179); : NEXT
242 LOCATE 1,12 : PRINT CHR$(218);
244 LOCATE 22,12 : PRINT CHR$(192);
248 ' outline of 555 itself
250 LOCATE 5,22 : PRINT STRING$(21,205);
260 LOCATE 18,22 : PRINT STRING$(21,205);
270 FOR I=5 TO 18 : LOCATE I,22 : PRINT CHR$(186); : NEXT
280 FOR I=5 TO 18 : LOCATE I,42 : PRINT CHR$(186); : NEXT
290 LOCATE 5,22 : PRINT CHR$(201);
300 LOCATE 5,42 : PRINT CHR$(187);
310 LOCATE 18,22 : PRINT CHR$(200);
320 LOCATE 18,42 : PRINT CHR$(188);
325 ' resistor
330 LOCATE 3,11 : PRINT CHR$(218);CHR$(193);CHR$(191);
340 FOR I=4 TO 5: LOCATE I,11 : PRINT CHR$(179); " "; CHR$(179); : NEXT
350 LOCATE 6,11 : PRINT CHR$(192);CHR$(194);CHR$(217);
360 ' resistor
370 LOCATE 9,11 : PRINT CHR$(218);CHR$(193);CHR$(191);
380 FOR I=10 TO 11 : LOCATE I,11 : PRINT CHR$(179);" ";CHR$(179); : NEXT
390 LOCATE 12,11 : PRINT CHR$(192);CHR$(194);CHR$(217)
400 ' capacitor
410 LOCATE 18,11 : PRINT CHR$(196);CHR$(193);CHR$(196);
420 LOCATE 19,11 : PRINT CHR$(196);CHR$(194);CHR$(196);
430 ' connect pin 1
440 LOCATE 17,32 : PRINT "1";
450 LOCATE 18,32 : PRINT CHR$(209);
460 FOR I=19 TO 21 : LOCATE I,32 : PRINT CHR$(179); : NEXT
470 LOCATE 22,32 : PRINT CHR$(193);
480 ' pin 2
490 LOCATE 16,12 : PRINT CHR$(195);STRING$(9,196);CHR$(182);"2";
500 ' pin 6
510 LOCATE 14,12 : PRINT CHR$(195);STRING$(9,196);CHR$(182);"6";
520 ' pin 7
530 LOCATE 8,12 : PRINT CHR$(195);STRING$(9,196);CHR$(182);"7";
540 ' pin 8
550 LOCATE 1,30 : PRINT CHR$(194);
560 FOR I=2 TO 4 : LOCATE I,30 : PRINT CHR$(179); : NEXT
570 LOCATE 5,30 : PRINT CHR$(207);
575 LOCATE 6,30 : PRINT "8";
580 ' pin 4
590 LOCATE 1,34 : PRINT CHR$(194);
600 FOR I=2 TO 4 : LOCATE I,34 : PRINT CHR$(179); : NEXT
610 LOCATE 5,34 : PRINT CHR$(207);
620 LOCATE 6,34 : PRINT "4";
630 ' pin 3
640 LOCATE  9,41 : PRINT "3";CHR$(199);STRING$(11,196);
650 ' various labels
660 LOCATE 10,30 : COLOR 0,7 : PRINT " 555 ";: COLOR 7,0
670 LOCATE 1,55 : PRINT "V+ (5-15v)";
680 LOCATE 9,55 : PRINT "Output";
690 LOCATE 22,55 : PRINT "V-";
700 LOCATE 4, 1 : PRINT "R1";
710 LOCATE 10, 1 : PRINT "R2";
720 LOCATE 18,1: PRINT "C";
800 REM  Get values and do calculations
805 LOCATE 25,1 : PRINT STRING$(79," ");
810 IF R1*R2*C <> 0 THEN LOCATE 25,40: PRINT "(Press RETURN to leave unchanged)";
812 '  Get value of R1
815 LOCATE 25,1 : PRINT STRING$(39," ");
817 IF R1>0 THEN LOCATE 25,10 : PRINT R1;
820 LOCATE 25,1 : PRINT "R1 ("+CHR$(234)+")  "; : INPUT;RESP
830 IF RESP>0 THEN R1=RESP
831 ' Verify that R1 is within safe range
832 IF R1>999 THEN 835
833 BEEP : LOCATE 24,1 : PRINT "R1 should normally be > 1000 ";CHR$(234);" to protect the discharge transistor.";
834 GOTO 812
835 LOCATE 24,1 : PRINT STRING$(79," ");  ' Clear error msg. if any
839 LOCATE 5,1 : PRINT STRING$(10," ");CHR$(179);" ";CHR$(179);"     ";
840 LOCATE 5,1 : PRINT R1;CHR$(234);
842 ' Get value of R2
845 LOCATE 25,1 : PRINT STRING$(39," ");
847 IF R2>0 THEN LOCATE 25,10 : PRINT R2;
850 LOCATE 25,1 : PRINT "R2 (";CHR$(234);")  "; : INPUT;RESP
860 IF RESP>0 THEN R2=RESP
869 LOCATE 11,1 : PRINT STRING$(10," ");CHR$(179);" ";CHR$(179);"     ";
870 LOCATE 11,1 : PRINT R2;CHR$(234);
872 ' Get value of C
875 LOCATE 25,1 : PRINT STRING$(39," ");
877 IF C>0 THEN LOCATE 25,10 : PRINT C;
880 LOCATE 25,1 : PRINT "C (";CHR$(230);"F)  "; : INPUT;RESP
890 IF RESP>0 THEN C=RESP
899 LOCATE 19,1 : PRINT STRING$(10," ");CHR$(196);CHR$(194);CHR$(196);"     ";
900 LOCATE 19,1 : PRINT C;CHR$(230);"F";
1000 ' Calculate output frequency, period, and duty cycle
1010 TH =  693 * (R1+R2) * (C/1000000!)   ' c is in microfarads
1020 TL =  693 * R2 * (C/1000000!)
1030 PERIOD = TH+TL
1031 FREQ = 1000 / PERIOD   ' times are in milliseconds
1032 IF TH+TL < .001 THEN UNIT$=CHR$(230)+"sec" ELSE UNIT$="msec"
1033 IF UNIT$<>"msec" THEN TL=TL*1000 : TH=TH*1000 : PERIOD=PERIOD*1000
1035 UNIT$=" "+UNIT$
1041 ' Print results
1045 RSF.N = 3  ' We will be rounding to 3 sig. figs.
1047 RSF.X = FREQ : GOSUB 40000
1049 LOCATE 11,45 : PRINT STRING$(35," ")
1050 LOCATE 11,45 : PRINT "Frequency   ";RSF.X$;" Hz";
1052 RSF.X = 100*(TH/PERIOD) : GOSUB 40000
1053 LOCATE 12,45 : PRINT STRING$(35," ")
1054 LOCATE 12,45 : PRINT "Duty cycle  ";RSF.X$;" % high";
1057 RSF.X = PERIOD : GOSUB 40000
1059 LOCATE 14,45 : PRINT STRING$(35," ")
1060 LOCATE 14,45 : PRINT "Period           ";RSF.X$;UNIT$  ;
1067 RSF.X = TH : GOSUB 40000
1069 LOCATE 15,45 : PRINT STRING$(35," ")
1070 LOCATE 15,45 : PRINT "Duration (high)  ";RSF.X$;UNIT$  ;
1077 RSF.X = TL : GOSUB 40000
1079 LOCATE 16,45 : PRINT STRING$(35," ")
1080 LOCATE 16,45 : PRINT "Duration (low)   ";RSF.X$;UNIT$  ;
1099 ' Prompt for another try
1100 LOCATE 25,1 : PRINT STRING$(79," ");
1110 LOCATE 25,1 : PRINT  "Another?  (Press Y or N)";
1120 R$=INKEY$ : IF R$="" THEN 1120
1130 IF R$="Y" OR R$="y" THEN 800
1140 IF R$<>"N" AND R$<>"n" THEN BEEP: GOTO 1120
1150 LOCATE 23,1 : KEY ON
1200 END
1300 '
1400 '
2000 GOTO 800
40000 '  RSFCONV -- Round to a specified number of significant
40010 '             digits and convert to a string
40020 '
40030 '  Michael A. Covington         7/9/83
40040 '  Copyright 1983
40050 '  All rights reserved
40060 '
40070 '  Accepts:  rsf.x  -- number to be converted
40080 '            rsf.n  -- desired number of significant digits
40090 '
40100 ' Returns:  rsf.x$ -- number converted to string
40110 '
40120 ' Return E format numbers without further processing
40130 RSF.Y$=STR$(RSF.X)
40140 IF INSTR(RSF.Y$,"E")>0 THEN RSF.X$=RSF.Y$ : RETURN
40150 '
40160 ' Apply correction to produce rounding rather than truncation
40170 RSF.ABSVAL = ABS(RSF.X)
40180 RSF.EXP=15
40190 WHILE 10^RSF.EXP > RSF.ABSVAL : RSF.EXP=RSF.EXP-1 : WEND
40200 RSF.EXP=RSF.EXP+1-RSF.N
40210 RSF.CORR = SGN(RSF.X) * .5 * 10^RSF.EXP
40220 RSF.Y$=STR$(RSF.X + RSF.CORR)
40230 '
40240 RSF.X$ = ""
40250 RSF.FIGCOUNT=0
40260 '
40270 ' Transfer digits into new string one by one
40280 IF RSF.FIGCOUNT = RSF.N THEN 40350
40290 RSF.PICK$ = LEFT$(RSF.Y$,1)   ' left most character
40300 RSF.Y$ = MID$(RSF.Y$,2)       ' remainder
40310 IF RSF.PICK$ = " " THEN 40280
40320 IF RSF.PICK$="." OR RSF.PICK$="-" THEN RSF.X$=RSF.X$+RSF.PICK$ : GOTO 40280
40330 RSF.X$=RSF.X$+RSF.PICK$ : RSF.FIGCOUNT=RSF.FIGCOUNT+1 : GOTO 40280
40340 '
40350 ' Right number of significant digits have now been processed.
40360 ' Do any trailing zeroes need to be added?
40370 RSF.ABSVAL = ABS(RSF.X + RSF.CORR)
40380 WHILE 10^RSF.FIGCOUNT <= RSF.ABSVAL
40390   RSF.X$=RSF.X$ + "0"
40400   RSF.FIGCOUNT = RSF.FIGCOUNT+1
40410 WEND
40420 '
40430 RETURN
