; QC2.COM, for crappy AMI BIOS - pops up in AutoCAD to edit text & attribs
; Goes with TEXTED.LSP & ATEDIT.LSP	Assembled with TASM 3.0.
; Intercepts INT 10h, 21h, and 2Fh.  ACAD sends 93h to screen for ALT-R.

; ACAD puts the text on the screen as  <the text>:
; Then this finds the < and >:, and 

cr	EQU	0Dh
lf	EQU	0Ah

CSEG	segment	byte public
	assume	CS:CSEG, DS:CSEG, ES:CSEG, SS:CSEG

	ORG	0100h

Start:	JMP	Install

	DB	'QC2 text and attribute editor for AutoCAD.',cr,lf
	DB	'Use it with TEXTED.LSP & ATEDIT.LSP',cr,lf,cr,lf
	DB	'mods by J. E. Arkay 6/89 and 11/00'
	DB	cr,lf,1Ah

		DB	'DEFAULT INS/OVERTYPE:'
;All the above may be overwritten when the program is in use.
;There must be at least 128 bytes used, up to here.
;This is the 2nd half of the text buffer, which starts at 80h in the PSP.

INSERTflag	DB	1
Attribute	DB	7
		DB	'ATTRIB FOR EDIT WINDOW:'
WindowAttrib	DB	47h		;white on red background
BlankScreenAttrib DB	7
OldINT10hOffset DW	0
OldINT10hSeg	DW	0
OldINT21hOffset DW	0
OldINT21hSeg	DW	0
OldINT2FhOffset DW	0
OldINT2FhSeg	DW	0
ENTERflag	DB	0
CurrCharPair	DW	0
TextStartFlag	DB	0
CharPointer	DW	0
CharCount	DW	0
DisplColumns	DB	1
H00199		DB	4Eh
DisplRow	DB	13h
VideoPage	DB	0
CursorLocn	DW	0
HigherCrsrPosn	DW	0
VideoMode	DB	0
RowTimes80d	DW	1920	;decimal - start of last line - set to 2000
ScanCount	DB	0


; - - - - - - - - - - - - - - - - - - - - - - - - - -
LFsAndScanScreen:
	MOV	WORD PTR DS:CurrCharPair,0
	MOV	BYTE PTR DS:TextStartFlag,0
	MOV	WORD PTR DS:CharCount,0
	CALL	SetAttrib

	MOV	DX,1800h	;Row 18h, column 0
	MOV	AH,2		;Set cursor position
	MOV	BH,BYTE PTR DS:VideoPage
	CALL	OldVideoINT

	MOV	AX,0E0Ah	;Write a LF
	MOV	BL,7		;Foreground attrib
	MOV	BH,BYTE PTR DS:VideoPage
	CALL	OldVideoINT

	MOV	AX,0E0Ah	;Write another LF
	MOV	BL,7
	MOV	BH,BYTE PTR DS:VideoPage
	CALL	OldVideoINT

	XOR	DX,DX		;Row 0, Column 0
	MOV	AH,2		;Set cursor position
	MOV	BH,BYTE PTR DS:VideoPage
	CALL	OldVideoINT

	MOV	CX,WORD PTR DS:RowTimes80d	;set to 2000
ScreenScanLoop:
	PUSH	CX
	PUSH	DX
	MOV	AH,8		;Read character & attrib
	MOV	BH,BYTE PTR DS:VideoPage
	CALL	OldVideoINT
	CALL	CheckFor_AnglBrkt	;only CALL
	POP	DX
	INC	DL
	CMP	DL,50h
	JC	SameLine
	XOR	DL,DL		;go to column 0
	INC	DH		;in next row
SameLine:
	MOV	AH,2		;Set cursor position
	MOV	BL,BYTE PTR DS:VideoPage
	PUSH	DX
	CALL	OldVideoINT
	POP	DX
	POP	CX
	LOOP	ScreenScanLoop
	RET

CheckFor_AnglBrkt:
	OR	AL,AL		;Character read from screen
	JNZ	CharReadNotZero
	MOV	AL,' '
CharReadNotZero:
	PUSH	BX
	MOV	BX,WORD PTR CS:CurrCharPair
	XCHG	BH,BL		;prev char to BL
	MOV	BH,AL		;this char to BH
	MOV	WORD PTR CS:CurrCharPair,BX
	POP	BX
	CMP	BYTE PTR CS:TextStartFlag,1
	JZ	ChkForEnd
	CMP	WORD PTR CS:CurrCharPair,3C20h	;Space, '<' found ?
	JNZ	ScanDone
	MOV	BYTE PTR CS:TextStartFlag,1
	MOV	WORD PTR CS:CharCount,0
	MOV	WORD PTR CS:CharPointer,0
	RET

ChkForEnd:
	PUSH	AX
	PUSH	DI
	PUSH	DS
	PUSHF
	PUSH	CS
	POP	DS
	CMP	WORD PTR DS:CurrCharPair,3A3Eh	;'>:' found ?
	JZ	EndOfText
	MOV	DI,WORD PTR DS:CharCount
	ADD	DI,80h
	MOV	BYTE PTR [DI],AL
	INC	WORD PTR DS:CharCount
	CMP	AL,' '
	JNZ	H00292
;a space has been encountered
	INC	BYTE PTR DS:ScanCount
	CMP	BYTE PTR DS:ScanCount,50h
	JNZ	H00297
	CMP	WORD PTR DS:CharCount,50h
	JC	H00297
	SUB	WORD PTR DS:CharPointer,50h
	SUB	WORD PTR DS:CharCount,50h
	JMP	SHORT H00297

H00292:	MOV	BYTE PTR DS:ScanCount,0
H00297:	CMP	WORD PTR DS:CharCount,0100h
	JC	PopAndScanDone
	XOR	AX,AX
	MOV	WORD PTR DS:CharCount,AX
	MOV	WORD PTR DS:CharPointer,AX
	JMP	SHORT PopAndScanDone

EndOfText:
	DEC	WORD PTR DS:CharCount
	MOV	BYTE PTR DS:TextStartFlag,0
PopAndScanDone:
	POPF
	POP	DS
	POP	DI
	POP	AX
ScanDone:
	RET
; - - - - - - - - - - - - - - - - - - - - - - - - - -

OldVideoINT:
	PUSHF
	CLI
	CALL	DWORD PTR CS:OldINT10hOffset
	RET

NewINT10h:
	CMP	AH,9		;Write char & attrib
	JZ	CheckForOurs
	CMP	AH,0Ah		;Write char only
	JZ	CheckForOurs
	CMP	AH,0Eh		;Write char as TTY
	JZ	CheckForOurs
ContinueINT10h:
	JMP	DWORD PTR CS:OldINT10hOffset

CheckForOurs:
	CMP	AL,93h		;=147d, ALT-R hot key
	JNZ	NotALT_R
	MOV	BYTE PTR CS:ALT_Rflag,1
NotALT_R:
	CMP	BYTE PTR CS:H008F7,0
	JZ	ContinueINT10h
	CMP	DL,92h		;=146d, ALT-E hot key
	JNZ	ContinueINT10h
	MOV	BYTE PTR CS:H008F9,0
	MOV	BYTE PTR CS:H008FA,0
	JMP	SHORT ContinueINT10h

ShowINSorOVERWRITE:
	MOV	AH,3		;Read cursor position
	MOV	BH,BYTE PTR DS:VideoPage
	PUSH	BX
	CALL	OldVideoINT
	PUSH	DX		;Row & Column
	MOV	DX,1143h	;Row 11h=17d, column 43h=67d
	MOV	BH,BYTE PTR DS:VideoPage
	MOV	AH,2		;Set cursor position
	CALL	OldVideoINT
	MOV	SI,OFFSET InsertMsg
	CMP	BYTE PTR DS:INSERTflag,1
	JZ	ModeDetermined
	ADD	SI,0Bh
	CLD
ModeDetermined:
	MOV	CX,0Bh		;characters in INSERT or OVERWRITE string
	CALL	DisplayLoop
	POP	DX
	POP	BX
	MOV	AH,2		;Set (restore) cursor position
	CALL	OldVideoINT
	RET

InsertMsg  DB	'  INSERT   '
InsPlus0Bh DB	' OVERWRITE '

DisplayLoop:
	PUSH	CX
	MOV	AH,9		;Write char & attrib
	LODSB
	MOV	BH,BYTE PTR DS:VideoPage
	MOV	BL,70h		;inverse, black on white
	MOV	CX,1
	CALL	OldVideoINT
	INC	DL
	MOV	AH,2		;Set cursor position
	MOV	BH,BYTE PTR DS:VideoPage
	CALL	OldVideoINT
	POP	CX
	LOOP	DisplayLoop

	RET

CursorUpIf:
	MOV	BX,WORD PTR DS:CharCount
	CMP	WORD PTR DS:CharPointer,BX
	JNC	RET1
	INC	WORD PTR DS:CharPointer
	CALL	MoveCursor
RET1:	RET

CursorBackIf:
	CMP	WORD PTR DS:CharPointer,0
	JZ	RET2
	DEC	WORD PTR DS:CharPointer
	CALL	MoveCrsr
RET2:	RET

Home:	MOV	CX,WORD PTR DS:CharCount
	SUB	CX,WORD PTR DS:CharPointer
	INC	CX
H0038C:	PUSH	CX
	CALL	CursorUpIf
	POP	CX
	LOOP	H0038C

	MOV	BX,WORD PTR DS:CharCount
	MOV	WORD PTR DS:CharPointer,BX
	RET

MoveCharsBack:
	MOV	CX,WORD PTR DS:CharCount
	SUB	CX,WORD PTR DS:CharPointer
	MOV	DI,WORD PTR DS:CharPointer
	ADD	DI,80h		;uses the DTA in the PSP
	MOV	SI,DI
	INC	SI
	CLD
	INC	CX
	REP	MOVSB
	MOV	BX,WORD PTR DS:CharPointer
	CMP	BX,WORD PTR DS:CharCount
	JZ	H003C1
	DEC	WORD PTR DS:CharCount
H003C1:	CALL	ShowTheLine
	RET

BackSpace:
	CMP	WORD PTR DS:CharPointer,0
	JZ	RET3
	CALL	CursorBackIf
	CALL	MoveCharsBack
RET3:	RET

RestoreCursorLocn:
	MOV	AH,2		;Set cursor position
	MOV	DL,BYTE PTR DS:DisplColumns
	MOV	DH,BYTE PTR DS:DisplRow
	MOV	WORD PTR DS:CursorLocn,DX
	MOV	BH,BYTE PTR DS:VideoPage
	CALL	OldVideoINT
	MOV	WORD PTR DS:CharPointer,0
	RET

ShowInsertedChar:
	MOV	CX,WORD PTR DS:CharCount
	SUB	CX,WORD PTR DS:CharPointer
	INC	CX
	MOV	DI,WORD PTR DS:CharCount
	ADD	DI,80h
	MOV	SI,DI
	INC	DI
	STD			;go backwards
	REP	MOVSB
	CLD
	INC	WORD PTR DS:CharCount
	CMP	WORD PTR DS:CharCount,0100h
	JC	ShowTheLine
	MOV	WORD PTR DS:CharCount,0FFh  ;if up to 256d chars
;This is CALLed several times...
ShowTheLine:
	MOV	DX,WORD PTR DS:CursorLocn
	PUSH	DX
	MOV	SI,WORD PTR DS:CharPointer
	MOV	CX,WORD PTR DS:CharCount
	OR	CX,CX
	JZ	WriteSpaceAndRET
	SUB	CX,SI		;chart count - char pointer = length past cursor
	OR	CX,CX
	JZ	WriteSpaceAndRET
	ADD	SI,80h		;128d
	CLD
ShowLoop:
	LODSB
	PUSH	CX
	PUSH	SI
	CALL	WriteAL
	CALL	MoveCursor
	POP	SI
	POP	CX
	LOOP	ShowLoop
WriteSpaceAndRET:
	MOV	AX,0920h	;Write a space
	MOV	BH,BYTE PTR DS:VideoPage
	MOV	BL,BYTE PTR DS:WindowAttrib
	MOV	CX,1
	CALL	OldVideoINT
	POP	DX
	MOV	WORD PTR DS:CursorLocn,DX
	MOV	AH,2		;Set cursor position
	MOV	BH,BYTE PTR DS:VideoPage
	CALL	OldVideoINT
	RET

Clear8lines:
	MOV	AH,6		;Scroll window up
	MOV	AL,8		;by 8 lines
	XOR	CX,CX		;Upper left=0,0
	MOV	DX,184Fh	;Lower Right=row 24, col 79
	MOV	BH,BYTE PTR DS:BlankScreenAttrib
	CALL	OldVideoINT
	MOV	AH,3		;Read cursor position
	MOV	BH,BYTE PTR DS:VideoPage
	CALL	OldVideoINT
	CMP	DH,9		;Row
	JC	NearTopOfScreen
	SUB	DH,8
	JMP	SHORT H0048B

NearTopOfScreen:
	XOR	DH,DH
H0048B:	MOV	WORD PTR DS:HigherCrsrPosn,DX
	RET

PaintBlankWindow:
	MOV	AX,0607h	;Scroll up, blank window **changed AL to 7
	MOV	CX,1100h	;Upper left=row 17d, col 0
	MOV	DX,174Fh	;Lower right=row 23d, col 79 (total 7 lines)
	MOV	BH,BYTE PTR DS:WindowAttrib
	CALL	OldVideoINT
;***this is not needed - - - -
	MOV	AH,2		;Set cursor position
	MOV	BH,BYTE PTR DS:VideoPage
	MOV	DX,1201h	;at row 18d, col 1
	CALL	OldVideoINT
;- - - - - - - - - - - - - - -
	CALL	ShowBanner
	CALL	ShowINSorOVERWRITE
	RET

ShowBanner:
	MOV	DX,1101h	;row 17d, col 1
	MOV	AH,2		;Set cursor position
	MOV	BH,BYTE PTR DS:VideoPage
	CALL	OldVideoINT
	MOV	CX,12		;characters in Banner, below - DECIMAL
	MOV	SI,OFFSET Banner
	CALL	DisplayLoop
;Write a horizontal line:
	MOV	AH,9		;Write char & attrib
	MOV	AL,205		;DECIMAL, ''
	MOV	CX,55		;chars to write, DECIMAL
	MOV	BH,BYTE PTR DS:VideoPage
	MOV	BL,BYTE PTR DS:WindowAttrib
	JMP	OldVideoINT

Banner	DB	' QC2   11/00'

SetAttrib:
	MOV	AH,0Fh		;get current video Mode
	CALL	OldVideoINT
	MOV	BYTE PTR DS:VideoPage,BH	;Page
	MOV	BYTE PTR DS:VideoMode,AL	;Mode
	CMP	AL,4
	JC	CGAtextModes
	MOV	BYTE PTR DS:Attribute,7		;for Mono
	RET

CGAtextModes:
	MOV	BYTE PTR DS:Attribute,47h
	RET

LowClockCount DW	0

WaitForKeyPress:
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DX
	MOV	CX,3
AwaitKey:
	MOV	AH,1		;Report char if available
	INT	16h		;KBD int
	JNZ	CharWaiting
	PUSH	CX
	MOV	AH,0		;Read the clock count
	INT	1Ah
	MOV	WORD PTR DS:LowClockCount,DX
	MOV	AH,0
WaitOneCount:
	INT	1Ah
	CMP	DX,WORD PTR DS:LowClockCount
	JZ	WaitOneCount
	POP	CX
	LOOP	AwaitKey

CharWaiting:
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	RET

WaitForChar:
;	CMP	BYTE PTR DS:VideoMode,4
;	JC	CGAtextOnly
;modes 4 & over, incl Mono
	MOV	AH,8		;Read char & attrib
	MOV	BH,BYTE PTR DS:VideoPage
	CALL	OldVideoINT
	PUSH	AX
	MOV	BL,BYTE PTR DS:Attribute
	MOV	AH,9		;Write char & attrib
	MOV	AL,0DBh		;'', the cursor
	MOV	BH,BYTE PTR DS:VideoPage
	MOV	CX,1		;one character to write
	PUSH	BX
	PUSH	CX
	CALL	OldVideoINT
	POP	CX
	POP	BX
	CALL	WaitForKeyPress
	POP	AX
	MOV	AH,9		;Write char & attrib
	MOV	BL,BYTE PTR DS:Attribute
	CALL	OldVideoINT
	CALL	WaitForKeyPress
	MOV	AH,1		;Report char if available
	INT	16h
	JZ	WaitForChar
CGAtextOnly:
	XOR	AX,AX		;wait for a keypress
	INT	16h
	OR	AL,AL		;Special character ?
	JZ	SplChar
	RET

SplChar:
	CMP	AX,5200h
	JNZ	NotInsert
	XOR	BYTE PTR DS:INSERTflag,00000001b ;toggle INSERT mode
	CALL	ShowINSorOVERWRITE
	JMP	SHORT WaitForChar

NotInsert:
	CMP	AX,5300h
	JNZ	NotDelete
	CALL	MoveCharsBack
	JMP	SHORT WaitForChar

NotDelete:
	CMP	AX,4D00h
	JNZ	NotCrsrRight
	CALL	CursorUpIf
	JMP	SHORT WaitForChar

NotCrsrRight:
	CMP	AX,4B00h
	JNZ	NotCrsrLeft
	CALL	CursorBackIf
	JMP	SHORT WaitForChar

NotCrsrLeft:
	CMP	AX,4700h
	JNZ	NotHome
	CALL	RestoreCursorLocn
	JMP	SHORT WaitForChar

NotHome:
	CMP	AX,4F00h
	JNZ	ToWFC
	CALL	Home
ToWFC:	JMP	WaitForChar

NewClearWindow:
	CALL	SetAttrib
	CALL	Clear8lines		;why? Next Call does same thing
	CALL	PaintBlankWindow
	CALL	RestoreCursorLocn
	CALL	ShowTheLine
	RET

ChkBksp:PUSH	AX
	CMP	AL,8		;backspace
	JNZ	NotBackSpace
	CALL	BackSpace
	JMP	SHORT PopAndRET

NotBackSpace:
	CMP	BYTE PTR DS:INSERTflag,0
	JZ	H00682
	MOV	BX,WORD PTR DS:CharCount
	INC	BX
	CMP	BX,WORD PTR DS:CharPointer
	PUSHF
	DEC	BX
	POPF
	JZ	H00682
	PUSH	AX
	CALL	ShowInsertedChar
	POP	AX
H00682:	CMP	WORD PTR DS:CharPointer,0100h	;256d chars max, req 4 lines
	JNC	PopAndRET
	MOV	DI,80h
	MOV	BX,WORD PTR DS:CharPointer
	MOV	BYTE PTR [BX+DI],AL
	CALL	WriteAL
	CALL	MoveCursor
	MOV	DX,WORD PTR DS:CharCount
	CMP	DX,WORD PTR DS:CharPointer
	JNZ	CharDone
	INC	WORD PTR DS:CharCount
	CMP	WORD PTR DS:CharCount,0100h
	JC	CharDone
	MOV	WORD PTR DS:CharCount,0FFh
CharDone:
	INC	WORD PTR DS:CharPointer
PopAndRET:
	POP	AX
	RET

WriteAL:
	PUSH	AX
	MOV	AH,9		;Write char & Attrib
	MOV	BH,BYTE PTR DS:VideoPage
	MOV	BL,BYTE PTR DS:Attribute
	MOV	CX,1		;just 1 char
	CALL	OldVideoINT
	POP	AX
	RET

MoveCursor:
	PUSH	AX
	MOV	DX,WORD PTR DS:CursorLocn
	INC	DL
	CMP	BYTE PTR DS:H00199,DL
	JNC	H006E1
	MOV	DL,BYTE PTR DS:DisplColumns
	INC	DH
H006E1:	MOV	WORD PTR DS:CursorLocn,DX
	MOV	AH,2		;Set cursor position
	MOV	BH,BYTE PTR DS:VideoPage
	CALL	OldVideoINT
	POP	AX
	RET

MoveCrsr:
	PUSH	AX
	MOV	DX,WORD PTR DS:CursorLocn
	CMP	DL,BYTE PTR DS:DisplColumns	;***WRONG, holds 1
	JG	ScreenEnds		;don't write past end of line
	MOV	DL,BYTE PTR DS:H00199
	DEC	DH
	JMP	SHORT H00705

ScreenEnds:
	DEC	DL
H00705:	MOV	WORD PTR DS:CursorLocn,DX
	MOV	AH,2		;Set cursor position
	MOV	BH,BYTE PTR DS:VideoPage
	CALL	OldVideoINT
	POP	AX
	RET

; - - - - - - - - - - - - - - - - - - - - - - - - - -
;this is the main editing routine
Editor:	CMP	BYTE PTR DS:TextStartFlag,0
	JZ	H0072D
	MOV	WORD PTR DS:CharCount,0
	MOV	WORD PTR DS:CharPointer,0
	MOV	WORD PTR DS:CurrCharPair,0
H0072D:	CALL	NewClearWindow
NextChar:
	CALL	WaitForChar
	CMP	AL,cr
	JZ	ENTERhit
	CMP	AX,0E7Fh
	JNZ	NotCTRL_BKSP

;CTRL-BKSP clears the text area
	MOV	WORD PTR DS:CharCount,0
	MOV	WORD PTR DS:CharPointer,0
	CALL	PaintBlankWindow
	CALL	RestoreCursorLocn
	CALL	ShowTheLine
	JMP	SHORT NextChar

NotCTRL_BKSP:
	CALL	ChkBksp
	JMP	SHORT NextChar

ENTERhit:
	MOV	WORD PTR DS:CharPointer,0
	OR	BYTE PTR DS:ENTERflag,00000001b
;undo the entire window
;*** why does this wipe the whole screen ?
	MOV	AX,0607h	;scroll up, blanks window **chganged AL to 7
	MOV	CX,1100h	;upper left = row 17d, col 0
	MOV	DX,174Fh	;lower right = row 23d, col 79
	MOV	BH,BYTE PTR DS:BlankScreenAttrib
	CALL	OldVideoINT
	MOV	DX,WORD PTR DS:HigherCrsrPosn
	MOV	BH,BYTE PTR DS:VideoPage
	MOV	AH,2		;Set cursor position
	CALL	OldVideoINT
	RET

; - - - - - - - - - - - - - - - - - - - - - - - - - -
DOSfunc	DB	0		;for debugging only

;The next time an INT 21h occurs, the text editor is displayed
;NOTE: INT does a PUSHF, then pushes CS, then IP
NewINT21h:
	PUSH	BP
	PUSH	AX
	MOV	BP,SP
	MOV	AX,WORD PTR [BP+8]	;2nd pushed before 2 pushes above
	PUSH	AX
	POPF				;gets 2nd push into Flags
	POP	AX
	POP	BP
;Stack unchanged, 2nd push (probably Flags) is in Flags
	CMP	BYTE PTR CS:H008F6,0
	JNZ	NotConsole
	CMP	AH,6			;Direct Console I/O
	JNZ	NotConsole
	CMP	BYTE PTR CS:ALT_Rflag,0
	JZ	H007F2
	DEC	BYTE PTR CS:ALT_Rflag
	CMP	BYTE PTR CS:ALT_Rflag,0	;was it 1 ?
	JNZ	H007F2
	MOV	BYTE PTR CS:ALT_Rflag,0
	MOV	BYTE PTR CS:ENTERflag,0
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	SI
	PUSH	DI
	PUSH	DS
	PUSH	ES
	MOV	AX,CS
	MOV	DS,AX
	MOV	ES,AX
;	MOV	AH,0Fh		;Get current video Mode
;	INT	10h
;	MOV	AH,3		;Read cursor position
;	INT	10h
;	INC	DH		;row
;	MOV	AL,50h
;	MUL	DH
;	MOV	WORD PTR DS:RowTimes80d,AX

	MOV	WORD PTR DS:RowTimes80d,2000

	CALL	LFsAndScanScreen	;only Call
	CALL	Editor
	POP	ES
	POP	DS
	POP	DI
	POP	SI
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	MOV	BYTE PTR CS:H008FA,1
	MOV	BYTE PTR CS:H008F9,1
	MOV	BYTE PTR CS:H008FD,1
	MOV	BYTE PTR CS:H008FB,0
	MOV	BYTE PTR CS:H008F8,0
	MOV	BYTE PTR CS:H008F7,0
H007F2:	CMP	AH,6
	JZ	H00802
NotConsole:
	CLI
	MOV	BYTE PTR CS:DOSfunc,AH	;for debugging
	JMP	DWORD PTR CS:OldINT21hOffset

H00802:	CMP	DL,0FFh		;DL=FFh means do Console Input
	JNZ	NotConsole
;We're doing Console Input
	CMP	BYTE PTR CS:H008F9,0
	JZ	H0081E
	MOV	BYTE PTR CS:H008F9,0
;Is this a delay ?  Sets the Flags ??
	MOV	AL,1
	OR	AL,AL		;set NZ, => AL=char from console
	MOV	AL,0
	JMP	EndINT21h

H0081E:	CMP	BYTE PTR CS:H008FA,0
	JZ	H00833
	MOV	BYTE PTR CS:H008FA,0
	MOV	AL,';'		;tell ACAD console input was 3Bh
	OR	AL,AL
	JMP	EndINT21h

H00833:	CMP	BYTE PTR CS:H008FB,0
	JZ	H0084C
	MOV	BYTE PTR CS:H008FB,0
	XOR	AL,AL
	MOV	BYTE PTR CS:ALT_Rflag,2
	JMP	EndINT21h

H0084C:	CMP	BYTE PTR CS:H008FD,0
	JZ	H00861
	MOV	BYTE PTR CS:H008FD,0
	MOV	AL,8		;tell ACAD console input was backspace
	OR	AL,AL
	JMP	EndINT21h

H00861:	CMP	BYTE PTR CS:ENTERflag,0
	JZ	H008A7
	PUSH	DS
	PUSH	SI
	PUSH	BX
	PUSHF
	CMP	WORD PTR CS:CharCount,0
	JZ	H0088E
	MOV	BX,CS
	MOV	DS,BX
	MOV	SI,WORD PTR DS:CharPointer
	CMP	SI,WORD PTR DS:CharCount
	JNC	H0088E
	ADD	SI,80h
	LODSB
	INC	WORD PTR DS:CharPointer
	JMP	SHORT H0089D

H0088E:	MOV	AL,cr
	AND	BYTE PTR CS:ENTERflag,0	;same as MOV xxxx,0 ?
	MOV	WORD PTR CS:CharCount,0
H0089D:	POPF
	POP	BX
	POP	SI
	POP	DS
	PUSH	AX
	OR	AH,AH		;must be used to set flag
	POP	AX
	JMP	SHORT EndINT21h

H008A7:	MOV	BYTE PTR CS:H008F6,1
	INT	21h
	MOV	BYTE PTR CS:H008F6,0
	JZ	EndINT21h
	CMP	BYTE PTR CS:H008F8,1
	JZ	H008CB
	OR	AL,AL
	JNZ	H008ED
	MOV	BYTE PTR CS:H008F8,1
	JMP	SHORT H008ED

H008CB:	MOV	BYTE PTR CS:H008F8,0
	CMP	AL,12h
	JNZ	H008ED
	MOV	BYTE PTR CS:H008F7,1
	MOV	BYTE PTR CS:H008FB,1
	MOV	BYTE PTR CS:H008F9,1
	MOV	BYTE PTR CS:H008FA,1
H008ED:	PUSH	AX
	MOV	AL,1
	OR	AL,AL	;sets flags
	POP	AX
EndINT21h:
	RETF	2	;same as IRET, but discard Flags

H008F6	DB	0
H008F7	DB	0
H008F8	DB	0
H008F9	DB	0
H008FA	DB	0
H008FB	DB	0
ALT_Rflag DB	0
H008FD	DB	0

NewINT2Fh:
	CMP	AH,93h	;'Multiplex' func, used just to check if installed
	JNZ	NotUs
	OR	AL,AL	;Get Installed State ?
	JNZ	KillIt
	MOV	AL,'Q'	;Signal we're installed
KillIt:	IRET

NotUs:	JMP	DWORD PTR CS:OldINT2FhOffset

; - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Install:
	MOV	AX,3510h
	INT	21h
	MOV	WORD PTR DS:OldINT10hOffset,BX
	MOV	WORD PTR DS:OldINT10hSeg,ES
	CALL	ShowInstallScreen
	CALL	ExitIfDOSbelow3_0
	CALL	ExitIfInstalled
	MOV	AX,3521h
	INT	21h
	MOV	WORD PTR DS:OldINT21hOffset,BX
	MOV	WORD PTR DS:OldINT21hSeg,ES
	MOV	DX,OFFSET NewINT21h
	MOV	AX,2521h
	INT	21h
	MOV	AX,3510h
	INT	21h
	MOV	WORD PTR DS:OldINT10hOffset,BX
	MOV	WORD PTR DS:OldINT10hSeg,ES
	MOV	DX,OFFSET NewINT10h
	MOV	AX,2510h
	INT	21h
	MOV	AX,352Fh
	INT	21h
	MOV	WORD PTR DS:OldINT2FhOffset,BX
	MOV	WORD PTR DS:OldINT2FhSeg,ES
	MOV	DX,OFFSET NewINT2Fh
	MOV	AX,252Fh
	INT	21h
	MOV	AH,49h			;Free allocated RAM
	MOV	ES,WORD PTR DS:2Ch	;In PSP, points to Environment
	INT	21h
	CALL	ShowMemUsed		;sets DX = length of pgm up to 'Install'
	INT	27h

ExitIfInstalled:
	MOV	AH,93h
	MOV	AL,0
	INT	2Fh		;INT 2Fh used to check if installed
	Cmp	AL,'Q'
	JNZ	NotInstalledYet
	MOV	DX,OFFSET AlreadyInstalledMsg
	MOV	AH,9
	INT	21h
	MOV	AX,4CFFh	;exit w/Errorlevel=FFh
	INT	21h
NotInstalledYet:
	RET

AlreadyInstalledMsg DB	cr,lf,' QC2 is already resident.',cr,lf,'$'

ExitIfDOSbelow3_0:
	MOV	AH,30h		;Get DOS version
	INT	21h
	CMP	AL,3
	JC	WrongDOS
	RET

WrongDOS:
	MOV	AH,9
	MOV	DX,OFFSET WrongDOSmsg
	INT	21h
	MOV	AX,4CFEh	;exit w/Errorlevel FEh
	INT	21h

WrongDOSmsg DB	cr,lf,'Wrong DOS version - 3.x + required.',cr,lf,'$'

InstallScreen DB	cr,lf,cr,lf
	DB	' QC2  version 0.70   Text & Attribute Editor for AutoCAD',cr,lf
	DB	' ALT-E pops it up in ACAD, or use TEXTED.LSP or ATEDIT.LSP.'
	DB	cr,lf,0

ShowInstallScreen:
	MOV	SI,OFFSET InstallScreen
	PUSH	AX
	PUSHF
	CLD
ScreenCharLoop:
	LODSB
	OR	AL,AL
	JZ	ScreenDone
	MOV	AH,0Eh
	XOR	BH,BH
	CALL	OldVideoINT
	JMP	SHORT ScreenCharLoop

ScreenDone:
	POPF
	POP	AX
	RET

ShowMemUsed:
	MOV	DX,OFFSET Install
	PUSH	DX
	PUSH	CS
	POP	ES
	PUSH	CS
	POP	DS
;round DX up to nearest para
	MOV	CL,4
	SHR	DX,CL
	INC	DX		;para's used, rounded UP
	SHL	DX,CL
	PUSHF
	CLI			;why ?
	STD			;Go backward
	MOV	BX,0Ah
	XOR	AX,AX
	MOV	DI,offset LastNo
MemUsedLoop:
	MOV	CX,DX
	XOR	DX,DX
	DIV	BX		;divide by 10d
	XCHG	AX,CX
	DIV	BX
	XCHG	AX,DX
	ADD	AL,30h		;make ASCII
	STOSB
	MOV	AX,CX
	OR	CX,DX
	JNZ	MemUsedLoop
	CLD
	POPF
	MOV	AH,9
	MOV	DX,OFFSET LoadedMsg
	INT	21h
	POP	DX
	RET

LoadedMsg DB	cr,lf,' Memory Used:    '
LastNo	DB	'  Bytes',cr,lf,'$'
	
CSEG	ends
	END	Start
