;  Unload this and QC2 with INT10MDA /U would be nice

; not done: bksp at start of line & row longer than 80 chars

; Why does banner appear at bottom of screen sometimes ???
; SHELL	then DIR /W shows with a few extra chars, goes to ACAD Command: prompt
;  Just DIR scrolls w/one char/line then crash
; If Func 0Fh returns Mono, lots of garbage on mono and no pic on graphics
;---------------------------------
; Int 10h Monochrome functions for the crappy AMI BIOS in the 7ZX mbd.  10/00
; For AutoCAD R10 to run in dual-screen mode.
; Must uninstall after exiting ACAD !
; Releases its Environment to use less RAM; TSR listers won't show its name.
; If you put it in your ACAD.BAT, it should be loaded first

;functions included are AH=
;  2	Set cursor position (DH, DL = row, column)
;  3	Read Cursor Position
;  6	Scroll Window
;  8	Read Character and Attrib
;  9	Display char in AL and attribute in BL (attrib not used)
; 0Ah	Display char in AL only
; 0Eh	Displ char in AL as TTY (CR, LF, BS, Bel acted on, move crsr)
; 13h	Display String TTY (ES:BP points to string, DX=cursor position)
;Note Int 21h Func 9 Display String$ uses Int 10h too

CR		Equ	0Dh
LF		Equ	0Ah
Bel		Equ	7
Bksp		Equ	8

CSEG	segment	byte public
	assume	CS:CSEG, DS:CSEG, ES:CSEG, SS:CSEG

	ORG	100h

Start:		JMP	Install

INT10hOffset	DW	0
INT10hSeg	DW	0

Column		DW	0		;actually col X 2
Row		DW	0		;both start at 0
StringFunc	DB	0
MoveCursorFlag	DB	0

NewInt10h:
; Useless to check for Mono mode, it's always 0Eh unless we set 410.
; So this assumes we want all text on Mono screen; must be easily uninstalled!

	CMP	AH,0Eh		;Display char in AL in TTY mode
	JNZ	TryOthers
	Cmp	AL,bel		;Let Bldp600I handle bel
	JNZ	ShowChars
	JMP	DWORD PTR CS:INT10hOffset

TryOthers:
	Cmp	AH,9		;Display char and attribute
	JZ	ShowChars
	Cmp	AH,0Ah		;Display character only
	JZ	ShowChars
	Cmp	AH,13h
	JNZ	TryMore
	Jmp	DisplayString

TryMore:Cmp	AH,6		;Scroll Up
	JNZ	Try2
	Jmp	ScrollUp

Try2:	Cmp	AH,2		;Set Cursor Position
	JNZ	Try3
	Jmp	SetCrsrPos

Try3:	Cmp	AH,3
	JNZ	Try8
	Jmp	GetCrsrPos

Try8:	Cmp	AH,8		;Read char and attrib at cursor
	JNZ	Try0F
	Jmp	ReadChar

Try0F:	Cmp	AH,0Fh		;get Video Mode
	JNZ	ChkSetMode
	IRET			;do nothing, BIOS is AFU

;This fixes graphics display totally.
;If you don't intercept switch to Mono, puts vertical blank lines 2 pixels
;wide on entire color screen. Guess ACAD switches to Mono with each text write.
ChkSetMode:
	Cmp	AH,0		;set mode
	JNZ	OldInt
	Cmp	AL,7		;to mode Mono ? (BIOS screws up Mono)
	JZ	Set400
	Cmp	AL,87h		;to mode Mono with CLS ?
	JZ	Set400
OldInt:	JMP	DWORD PTR CS:INT10hOffset

;This lets PMS find which screen it should be running on
Set400:	Push	AX
	Push	ES
	Xor	AX,AX
	Mov	ES,AX
	Mov	AX,ES:[410h]
	Or	AX,30h		;set bits 4 & 5 to indicate Mono
	Mov	ES:[410h],AX
	Pop	ES
	Pop	AX
DoNothing:
	IRET

ShowChars:
	Call	ShowEm
	IRET

; Used by DisplayString, which sets MoveCursorFlag as needed.
; Funcs 9 and 0Ah do not move cursor, 0Eh does.
ShowEm:	Push	ES
	Push	DX
	Push	DI
	Push	AX
	Push	CX
	Cmp	AH,0Eh
	JNZ	Not0E
	Mov	MoveCursorFlag,1
	Mov	CX,1		;0E only does 1 char
Not0E:	Cmp	CX,1
	JBE	NotOver1
	Mov	MoveCursorFlag,1
NotOver1:
	Mov	DX,0B000h	;Mono segment
	Mov	ES,DX
	CLD
NextChar:
	Cmp	AL,CR
	JZ	CarriageReturn
	Cmp	AL,LF
	JZ	LineFeed
	Push	AX
	Mov	AX,Row
	Mov	DI,160
	Mul	DI
	Add	AX,Column	;Column is position X 2
	Mov	DI,AX
;** should check for running off end of screen
	Pop	AX
	Mov	AH,7		;normal white on black (0Fh is hi-intens)
	Cmp	AL,Bksp
	JZ	BackSpace
ShowText:
	StosW
	Cmp	MoveCursorFlag,1  ;move cursor for Func 0Eh
	JNZ	OneDone
	Add	Column,2
OneDone:
	Loop	NextChar

ExitOne:Mov	MoveCursorFlag,0
	Pop	CX
	Pop	AX
	Pop	DI
	Pop	DX
	Pop	ES
	Ret

BackSpace:			;attrib in AH has been set
	Mov	AL,' '
	Sub	DI,2
;check for Bksp at start of line
	Cmp	Column,2
	JNB	SubIt
	Mov	Column,160
	Dec	Row
SubIt:	Sub	Column,2
	Stosw
	Jmp	Short OneDone

CarriageReturn:
	Mov	Column,0
	Jmp	Short OneDone

LineFeed:
	Cmp	Row,24
	JB	NoScroll
	Call	Scroll
	Jmp	Short OneDone

NoScroll:
	Inc	Row
	Jmp	Short OneDone

Scroll:	Push	DS
	Push	ES
	Push	DI
	Push	SI
	Push	CX
	Push	DX
	CLD
	Mov	DX,0B000h	;Mono segment
	Mov	ES,DX
	Mov	DS,DX
	Xor	DI,DI
	Mov	SI,160
	Mov	CX,80*24
	Rep	MovsW
	Mov	CX,80
	Mov	AX,0720h	;blank char
	Rep	StosW
	Pop	DX
	Pop	CX
	Pop	SI
	Pop	DI
	Pop	ES
	Pop	DS
	Ret

;***Rewriting this did not change QC2 or SHELL, DIR crash
; Appears not used by ACAD but is used by QC2 and may be used by DOS
; ES:BP points string, CX=count, DX=cursor posn, BH=page
; AL=0 => BL=attrib, no move
; AL=1 => BL=attrib, yes move cursor
; AL=2 => string is char-attrib, no move
; AL=3 => char-attrib, yes move cursor
; CR, LF, Bksp, bel are commands
DisplayString:
	Push	AX
	Push	BX
	Push	CX
	Push	DX
	Push	SI
	Push	DI
	Push	ES
	Push	DS
	Mov	StringFunc,AL	;save sub-function
	Cmp	CX,2000
	JBE	CXset
	Mov	CX,2000
CXset:	Push	AX
	Xor	AX,AX
	Mov	AL,DH		;AX=row
	Mov	Row,AX
	Mov	DI,160
	Mul	DI
	Xor	BX,BX
	Mov	BL,DL		;BX=column
	Add	BX,BX		;translate to our double columns
	Mov	Column,BX
	Add	AX,BX
	Mov	DI,AX
	Pop	AX
	Push	ES
	Pop	DS
	Mov	SI,BP		;now DS:SI points string
	Mov	BX,0B000h	;Mono segment
	Mov	ES,BX
	Mov	AH,0Eh		;use TTY routine, shows 1 char
StringLoop:
	Lodsb
	Test	StringFunc,00000010b	;char-attrib pairs ?
	JZ	Show1
	Inc	SI
Show1:	Mov	MoveCursorFlag,0
	Test	StringFunc,00000001b	;move cursor ?
	Mov	MoveCursorFlag,1
	Call	ShowEm
	Loop	StringLoop

	Pop	DS
	Pop	ES
	Pop	DI
	Pop	SI
	Pop	DX
	Pop	CX
	Pop	BX
	Pop	AX
	IRET

SetCrsrPos:
	Push	AX
	Xor	AH,AH
	Mov	AL,DH
	Mov	Row,AX
	Mov	AL,DL
	Add	AX,AX
	Mov	Column,AX
	Pop	AX
	IRET

GetCrsrPos:
	Mov	DX,Row
	XCHG	DH,DL
	Mov	BX,Column
	Shr	BX,1
	Mov	DL,BL
	IRET

ReadChar:
	Push	DI
	Push	ES
	Mov	AX,0B000h
	Mov	ES,AX
	Mov	AX,Row
	Mov	DI,160
	Mul	DI
	Add	AX,Column	;Column is position X 2
	Mov	DI,AX
	Mov	AL,ES:[DI]
	Pop	ES
	Pop	DI
	IRET			;with char in AL

;this is used by QC2 to clear the bottom 8 lines
ScrollUp:
	Mov	Column,0
	Push	CX
	Xor	CX,CX
	Mov	CL,AL		;lines to scroll
	Dec	CX
	Sub	Row,CX
	Inc	CX
	Or	CX,CX
	JNZ	ScrollLoop
	Mov	CX,25
	Mov	Row,0
ScrollLoop:
	Call	Scroll
	Loop	ScrollLoop

	Pop	CX
	IRET

;
Install:MOV	AH,93h
	MOV	AL,0
	INT	2Fh		;INT 2Fh used to check if installed
	Cmp	AL,'Q'		;if QC2 is installed, so are we
	JNZ	NotInstalledYet
	MOV	DX,OFFSET AlreadyInstalledMsg
	MOV	AH,9
	INT	21h
	MOV	AX,4CFFh	;exit w/Errorlevel=FFh
	INT	21h

AlreadyInstalledMsg DB	cr,lf,' INT10MDA is already resident.',cr,lf,'$'

NotInstalledYet:
	Push	ES
	Mov	AX,3510h		;get Int 10h vector
	Int	21h
	Mov	Int10hOffset,BX
	Mov	Int10hSeg,ES
	Mov	AX,2510h	
	Mov	DX,Offset NewInt10h
	Push	CS
	Pop	DS
	Int	21h
;De-allocate the Environment Block, we don't need it.
; This sometimes leaves a uselessly small unused Block
	Xor	ax,ax
	Xchg	ax,word ptr CS:2Ch	;Environment Block addr in the PSP
	Or	ax,ax
	JZ	GoRes			;skip it if there is no Env
	Mov	es,ax
	Mov	ah,49h			;free allocated RAM
	Int	21h
GoRes:	Mov	DX,OFFSET InstMsg	;show our banner (on the Mono screen)
	Mov	AH,9
	Int	21h
	Pop	ES
;go resident
	mov	dx,offset Install	;bytes to stay resident
	add	dx,15			;allow for fractional para
	mov	cl,4
	shr	dx,cl			;paras to stay resident
	mov	ax,3100h		;go TSR
	int	21h

InstMsg	DB	cr,lf,'Int 10h for MDA card installed$'

CSEG	ends
	END	Start
