/*
   Module:  adicodes.h
   Date:    3/9/92
   Version: 1.0b
   Author:  Dave Lutz
   Email:   lutz@psych.rochester.edu
   Copyright: 1992 University of Rochester, Psychology Dept.

   Disclaimer:  This software is distributed free of charge.  As such, it
                comes with ABSOLUTELY NO WARRANTY.  The user of the software
                assumes ALL RISKS associated with its use.

                Your rights to modify and/or distribute this software are
                outlined in the file ADI7221.DOC.

   Purpose: This module provides the code definitions for the ADI format
            output files created by AutoCad.  These codes can be used to
            interpret an ADI file and convert it to a file that can be
            sent directly to a plotting device.
   
   The codes in this file are based on the following chart in AutoCad's
   "Installation and Performance Guide" for IBM's and compatibles.
   (Release 10).

   Function      | Code | Type | Argument 1 | Argument 2
   ------------------------------------------------------
   Begin Plot    |  1   |  B   | File Level |
   ------------------------------------------------------
   End Plot      |  2   |  A   |            |
   ------------------------------------------------------
   Move          |  3   |  C   | X coord    | y coord
   ------------------------------------------------------
   Draw          |  4   |  C   | X coord    | y coord
   ------------------------------------------------------
   New Pen       |  5   |  B   | pen number |
   ------------------------------------------------------
   Select Speed  |  6   |  B   | speed code |
   ------------------------------------------------------
   Set Line Type |  7   |  B   | line type  |
   ------------------------------------------------------
   Pen Change    |  8   |  A   |            |
   ------------------------------------------------------
   Abort Plot    |  9   |  A   |            |
   ------------------------------------------------------


   Command types are as follows:
        Type A : command only
        Type B : command + 1 arg   (0 <= arg <= 127)
        Type B : command + 2 args  (0 <= arg1,arg2 <= 65535)

   Note: "New Pen" is a device command causing an automatic pen selection;
   "Pen Change" is meant to induce a pause while the operator manually
   changes the pen in the holder.
   
   In an ASCII file, each command is on a separate line, beginning in column
   zero.  If the command has arguments, they are separated with a comma.

   In a BINARY file, the command is written as a single byte.  Type B args
   are also written as a single byte, TYPE C args are written as 16 bits
   in standard 8086 format (least significant byte first (left) then most
   significant byte (right)).  There are no delimeters included in a BINARY
   file.
*/

#define ADIVERSION 1  /* the version of AutoCad ADI that program expects to
                         convert.
                      */

   /* If any of the following codes are changed, check retcodes.h to ensure
      that a conflict with those codes has not been created.
   */

#define BEGIN_PLOT 1
#define END_PLOT   2
#define MOVE       3  /* pen up, move */
#define DRAW       4  /* pen down, draw */
#define NEW_PEN    5  /* plotter selects pen */
#define SET_SPEED  6
#define LINE_TYPE  7
#define PEN_CHANGE 8  /* wait for manual pen change */
#define ABORT_PLOT 9  /* only needed for resident ADI driver */

