/*************************************************************************

	kb_test.c	Test Keyboard (KB) Subroutines
			for Bywater Software

			Copyright (c) 1991, Ted A. Campbell

			Bywater Software
			P. O. Box 4023 
			Duke Station 
			Durham, NC  27706

			email: tcamp@hercules.acpub.duke.edu

	Copyright and Permissions Information:

	All U.S. and international copyrights are claimed by the
	author. The author grants permission to use this code
	and software based on it under the following conditions:
	(a) in general, the code and software based upon it may be 
	used by individuals and by non-profit organizations; (b) it
	may also be utilized by governmental agencies in any country,
	with the exception of military agencies; (c) the code and/or
	software based upon it may not be sold for a profit without
	an explicit and specific permission from the author, except
	that a minimal fee may be charged for media on which it is
	copied, and for copying and handling; (d) the code must be 
	distributed in the form in which it has been released by the
	author; and (e) the code and software based upon it may not 
	be used for illegal activities. 

**************************************************************************/

#include "stdio.h"
#include "kb.h"

#define ESC     0x1b

main()
	{
	unsigned c;
	kb_init();

	printf( "Test of KB functions. \n" );
	printf( "Press ESCAPE to exit. \n" );

	c = 0;
	while( c != ESC )
		{
		c = kb_rx();
		switch ( c )
			{
			case KB_LEFT:
				printf( "Key:\tLEFT \n" );
				break;
			case KB_RIGHT:
				printf( "Key:\tRIGHT \n" );
				break;
			case KB_UP:
				printf( "Key:\tUP \n" );
				break;
			case KB_DOWN:
				printf( "Key:\tDOWN \n" );
				break;
			case KB_HOME:
				printf( "Key:\tHOME \n" );
				break;
			case KB_END:
				printf( "Key:\tEND \n" );
				break;
			case KB_P_UP:
				printf( "Key:\tPAGE UP \n" );
				break;
			case KB_P_DOWN:
				printf( "Key:\tPAGE DOWN \n" );
				break;
			case KB_INSERT:
				printf( "Key:\tINSERT \n" );
				break;
			case KB_DELETE:
				printf( "Key:\tDELETE \n" );
				break;
			case KB_FK0:
				printf( "Key:\tFK 10 \n" );
				break;
			case KB_FK1:
				printf( "Key:\tFK 1 \n" );
				break;
			case KB_FK2:
				printf( "Key:\tFK 2 \n" );
				break;
			case KB_FK3:
				printf( "Key:\tFK 3 \n" );
				break;
			case KB_FK4:
				printf( "Key:\tFK 4 \n" );
				break;
			case KB_FK5:
				printf( "Key:\tFK 5 \n" );
				break;
			case KB_FK6:
				printf( "Key:\tFK 6 \n" );
				break;
			case KB_FK7:
				printf( "Key:\tFK 7 \n" );
				break;
			case KB_FK8:
				printf( "Key:\tFK 8 \n" );
				break;
			case KB_FK9:
				printf( "Key:\tFK 9 \n" );
				break;
			default:
				if ( ( c & KB_ALT ) == 0 )
					{
					printf( "Key:\t%c \n", c );
					}
				else
					{
					printf( "Key:\tALT-%c \n", ( c & 127 ));
					}
				break;
			}
		}
	kb_deinit();
	}

