/***************************************************************

	sfs_ft.c        Forward Track Routines for
			Space Flight Simulator

			Copyright (c) 1991, Ted A. Campbell

			Bywater Software
			P. O. Box 4023 
			Duke Station 
			Durham, NC  27706

			email: tcamp@hercules.acpub.duke.edu

	Copyright and Permissions Information:

	All U.S. and international copyrights are claimed by the
	author. The author grants permission to use this code
	and software based on it under the following conditions:
	(a) in general, the code and software based upon it may be 
	used by individuals and by non-profit organizations; (b) it
	may also be utilized by governmental agencies in any country,
	with the exception of military agencies; (c) the code and/or
	software based upon it may not be sold for a profit without
	an explicit and specific permission from the author, except
	that a minimal fee may be charged for media on which it is
	copied, and for copying and handling; (d) the code must be 
	distributed in the form in which it has been released by the
	author; and (e) the code and software based upon it may not 
	be used for illegal activities. 

***************************************************************/

#include "stdio.h"
#include "ctype.h"
#include "bw.h"
#include "gr.h"
#include "kb.h"
#include "ui.h"
#include "as.h"
#include "sfs.h"

static double x_lat, x_lon;
static long x_r, x_n;

ft_init( sorbit_array, orbit, poll )
   struct sfs_orbit **sorbit_array;
   int orbit;
   int (*poll)();
   {
   register int c;

   sprintf( bw_ebuf, FT_NOTICE, orbit + 1 );
#ifdef OLD_DEBUG
   bw_debug( bw_ebuf );
#else
   bw_message( bw_ebuf );
#endif

   sorbit_array[ orbit ]->ft_inc = sorbit_array[ orbit ]->aorbit->period / (double) FT_POINTS;

   sorbit_array[ orbit ]->ft_t = sfs_insertion;
   sorbit_array[ orbit ]->last_time = sorbit_array[ orbit ]->ft_t;

   for ( c = 0; c < FT_POINTS;  ++c )
      {

      or_ssp( sorbit_array[ orbit ]->aorbit, sorbit_array[ orbit ]->ft_t, &x_lat, &x_lon, &x_r, &x_n );
      sorbit_array[ orbit ]->ft_buffer[ c ].latitude  = x_lat;
      sorbit_array[ orbit ]->ft_buffer[ c ].longitude = x_lon;
      sorbit_array[ orbit ]->ft_buffer[ c ].altitude  = x_r;
      sorbit_array[ orbit ]->ft_t += sorbit_array[ orbit ]->ft_inc;

      /* call poll function */

      (*poll) ();

      }

   sorbit_array[ orbit ]->ft_bufstart = 0;
   sorbit_array[ orbit ]->ft_bufpos   = FT_POINTS - 1;

   }

ft_calc( newtime, sorbit_array, orbit, poll )
   long newtime;
   struct sfs_orbit **sorbit_array;
   int orbit;
   int (*poll)();
   {
   register int c;
   int number;

   number = ( newtime - sorbit_array[ orbit ]->last_time )
      / sorbit_array[ orbit ]->ft_inc;

   sprintf( bw_ebuf, FT_CALC, orbit );
   bw_message( bw_ebuf );

   for ( c = 0; c < number; c++ )
      {

      or_ssp( sorbit_array[ orbit ]->aorbit, sorbit_array[ orbit ]->ft_t,
	 &x_lat, &x_lon, &x_r, &x_n );
      sorbit_array[ orbit ]->ft_buffer[ sorbit_array[ orbit ]->ft_bufpos ].latitude  = x_lat;
      sorbit_array[ orbit ]->ft_buffer[ sorbit_array[ orbit ]->ft_bufpos ].longitude = x_lon;
      sorbit_array[ orbit ]->ft_buffer[ sorbit_array[ orbit ]->ft_bufpos ].altitude  = x_r;
      sorbit_array[ orbit ]->last_time += sorbit_array[ orbit ]->ft_inc;
      sorbit_array[ orbit ]->ft_t += sorbit_array[ orbit ]->ft_inc;
      ++sorbit_array[ orbit ]->ft_bufpos;
      if ( sorbit_array[ orbit ]->ft_bufpos == FT_POINTS )
	 {
	 sorbit_array[ orbit ]->ft_bufpos = 0;
	 }
      ++sorbit_array[ orbit ]->ft_bufstart;
      if ( sorbit_array[ orbit ]->ft_bufstart == FT_POINTS )
	 {
	 sorbit_array[ orbit ]->ft_bufstart = 0;
	 }

#ifdef  OLD_DEBUG
      sprintf( bw_ebuf, "Calculating forward track for orbit %d, position %d of %d",
      orbit, c, number );
      bw_message( bw_ebuf );
#endif

      /* call poll function */

      (*poll) ();

      }
   }

ft_plot( sorbit_array, orbit )
   struct sfs_orbit **sorbit_array;
   int orbit;
   {
   register int c;

   c = sorbit_array[ orbit ]->ft_bufstart;
   while ( c != sorbit_array[ orbit ]->ft_bufpos )
      {

#ifdef  OLD_DEBUG
      sprintf( bw_ebuf, "Draw forward track, point %d, lat %.2lf, lon %.2lf",
	 c,
	 sorbit_array[ orbit ]->ft_buffer[ c ].latitude,
	 sorbit_array[ orbit ]->ft_buffer[ c ].longitude );
      bw_debug( bw_ebuf );
#endif

      /* Draw the point simply by displaying a line to itself */

      gt_line( sorbit_array[ orbit ]->ft_buffer[ c ].latitude,
	  sorbit_array[ orbit ]->ft_buffer[ c ].longitude,
	  sorbit_array[ orbit ]->ft_buffer[ c ].latitude,
	  sorbit_array[ orbit ]->ft_buffer[ c ].longitude,
	  cl_orbits[ orbit % 6 ], SOLID );

      ++c;
      if ( c == FT_POINTS )
	 {
	 c = 0;
	 }
      }
   }



