/***************************************************************

	map.h           Header file
			for SFS Map utility

			Copyright (c) 1991, Ted A. Campbell

			Bywater Software
			P. O. Box 4023
			Duke Station
			Durham, NC  27706

			tcamp@hercules.acpub.duke.edu

	Copyright and Permissions Information:

	All U.S. and international copyrights are claimed by the
	author. The author grants permission to use this code
	and software based on it under the following conditions:
	(a) in general, the code and software based upon it may be
	used by individuals and by non-profit organizations; (b) it
	may also be utilized by governmental agencies in any country,
	with the exception of military agencies; (c) the code and/or
	software based upon it may not be sold for a profit without
	an explicit and specific permission from the author, except
	that a minimal fee may be charged for media on which it is
	copied, and for copying and handling; (d) the code must be
	distributed in the form in which it has been released by the
	author; and (e) the code and software based upon it may not
	be used for illegal activities.

***************************************************************/


#define MAP_TITLE       "SFS Map Utility, version %s"
#define MAP_VERSION     "1.01"
#define MAP_DEFAULTDATA "test.spd"
#define MAP_DRAW	"Drawing Map..."
#define	MAP_HELP	"Press ESC or Click in Top Bar"
#define MAP_MM		"Main Menu -- Select Item"
#define MAP_SELECT	"Use Arrow Keys to Select Position, then RETURN"
#define MAP_SEQM	"SEQUENCE: Click points -- click top bar to end"

#define	MM_TITLE	"Main Menu"
#define MM_POSITION     "Change Position"
#define MM_ENTITLE      "Enter Title or Comment"
#define	MM_SEQUENCE	"Begin Sequence"
#define	MM_ALTITUDE	"Set Default Altitude"
#define	MM_EXIT		"Exit"

#define ALT_TITLE	"Set Default Altitude"
#define ALT_TEXT	"Enter the altitude for subsequent sequence points in kilometers."
#define ALT_PROMPT	"Altitude: "
#define ALT_MEMERR      "Cannot allocate memory for dialogue box"

#define ENT_TITLE       "Enter Title or Comment"
#define ENT_TEXT        "Enter a title or comment line."
#define ENT_PROMPT      "Title/Comment: "

#define SEQ_QUIT        "QUIT"
#define SEQ_BACKUP      "BACKUP"

#define ERR_PROMPT      "ERROR:  %s; Do you want to continue? "
#define ERRP_NO         "N - ABORT"
#define ERRP_YES        "Y - Continue"
#define ERR_MATH        "Mathematics error, %s"
#define ERR_MOUSE	"You must have a pointer device to enter points"

#define	MEMERR_ESC	"Cannot allocate memory for ESCAPE menu"
#define MEMERR_ERR	"Cannot allocate memory for ERROR screen"
#define MEMERR_SEQ	"Cannot allocate memory for next point"

#define MM_TITLES       5

extern int dr_xsize;            /* Size of ground track map, x */
extern int dr_ysize;            /* Size of ground track map, y */
extern int dr_mapbase;          /* Bottom of gt map */
extern int dr_mapedge;          /* Left edge of groundtrack map */

/***    Colors */

extern int   cl_mback;      /* Main background color   */
extern int   cl_mfore;      /* Main foreground color   */
extern int   cl_marker;      /* Color for prompt markers   */
extern int   cl_grid;      /* Color for planetary grid   */
extern int   cl_surface;      /* Color for planetary surface   */

extern int map_pos[ 10 ][ 4 ];

