; This program is made by Daniel Horchner.
; email: dbjh@gmx.net

        .386p
        locals

code32  segment para public use32
        assume cs:code32, ds:code32, ss:code32

include raw32.inc
LOADER          =       0
include loader\raw32mod.inc
extrn   DPMImem:dword, VCPImem:dword, XMSmem:dword

;32-bit data
BUFFERSIZE      =       60*1024         ; 64K-1 -> problems with CWSDPMI (?)
defaultname     db      'MODULE.RX',0
modulename      dd      defaultname
filehandle      dw      0
buffer          dd      0               ; ptr to file buffer
module          dd      0               ; ptr to module in memory
image           dd      0               ; ptr to image in memory (module+hdr)
orgstack        label   fword
                dd      0
                dw      0
noflat_esp      dd      0

msg0            db      'RAW32 module loader (R3).',13,10,'$'
msg1            db      'Not enough memory free.','$'
msg2            db      'An error occurred. Press a key to continue.','$'
msg3            db      13,10,'Shutting down...','$'

;32-bit code
main:
        mov edx,offset msg0
        call dosprint

        mov eax,himembase               ; Ensure himembase is aligned on
        add eax,0fh                     ;  para. Needed by reloc code and
        and al,0f0h                     ;  modules assume their code32 is
        sub eax,himembase               ;  aligned on para ('normal' code32
        call gethimem                   ;  is aligned on paragraph boundary)

        push lomembase
        movzx eax,byte ptr es:[80h]     ; psp[80h]=length of command tail
        cmp eax,0
        je @@filenamedone               ; No argument, use default filename
        dec eax
        je @@filenamedone               ; Only a space -> default filename
        mov ecx,eax                     ; Save length for copying
        call getlomem
        mov modulename,eax

        mov edi,eax
        mov esi,82h                     ; Name starts after space
        mov es,data32sel
        mov ds,pspsel
        rep movsb                       ; Copy argument to filename string
        mov ds,cs:data32sel
        mov byte ptr es:[edi],0
@@filenamedone:

        mov eax,BUFFERSIZE              ; Allocate file buffer
        call getlomem
        jc notenoughmem
        mov buffer,eax

        mov v86r_ah,3dh                 ; ah=3dh -> Open file using handle
        mov v86r_al,2                   ; ah=open access mode; 2=read/write
        mov eax,modulename
        add eax,code32a                 ; eax=linear address of filename
        mov dl,al
        and edx,0fh
        shr eax,4
        mov v86r_ds,ax
        mov v86r_dx,dx                  ; ds:dx=pointer to ASCII-z path name
        mov al,21h
        int RMCALL_VECT
        test v86r_flags,1
        jnz errexit
        mov ax,v86r_ax
        mov filehandle,ax

        mov v86r_ah,42h                 ; ah=42h -> Move file pointer
        mov v86r_al,2                   ; al=origin of move; 2=eof + offset
        mov v86r_bx,ax                  ; bx=file handle
        mov v86r_cx,0                   ; MSW of offset
        mov v86r_dx,0                   ; LSW of offset
        mov al,21h
        int RMCALL_VECT
        test v86r_flags,1
        jnz errexit
        mov ax,v86r_dx
        shl eax,16
        mov ax,v86r_ax                  ; dx:ax=new file pointer=file size
        call gethimem                   ; eax=file size
        jc notenoughmem
        mov module,eax
                                        ; Restore file ptr to start of file
        mov v86r_ah,42h
        mov v86r_al,0                   ; 0=beginning of file + offset
        mov ax,filehandle
        mov v86r_bx,ax
        mov v86r_cx,0
        mov v86r_dx,0
        mov al,21h
        int RMCALL_VECT
        test v86r_flags,1
        jnz errexit
                                        ; Read the module
        mov es,data32sel
        mov edi,module
        mov ax,filehandle
        mov v86r_bx,ax                  ; bx=file handle
        mov v86r_cx,BUFFERSIZE          ; cx=number of bytes to read
        mov eax,buffer
        add eax,code32a
        mov dl,al
        and edx,0fh
        shr eax,4
        mov v86r_ds,ax
        mov v86r_dx,dx                  ; ds:dx=pointer to read buffer
        mov al,21h
readmodule:
        mov v86r_ah,3fh                 ; ah=3fh -> Read from file using hndl
        int RMCALL_VECT
        test v86r_flags,1
        jnz errexit
        movzx ecx,v86r_ax               ; ax=number of bytes actually read
        cmp ecx,0
        je moduleloaded
        mov esi,buffer
        rep movsb                       ; Copy buffer to memory for module
        jmp readmodule

moduleloaded:
        mov v86r_ah,3eh                 ; 3eh -> Close file using handle
        mov al,21h
        int RMCALL_VECT
        test v86r_flags,1
        jnz errexit

        pop lomembase                   ; Free memory for file buffer
;
        mov ebx,module                  ; ebx=ptr to module
        mov edi,ebx
        movzx eax,word ptr [ebx+8]      ; [8]=size of header in 16 byte paras
        shl eax,4
        add edi,eax                     ; edi=ptr to image (module - header)
        mov image,edi

        movzx ecx,word ptr [ebx+6]      ; [6]=number of relocation items
        jecxz relocation_done
        movzx eax,word ptr [ebx+18h]    ; [18h]=offset in module of first
        add ebx,eax                     ;  relocation item
        mov esi,image
        add esi,code32a
        shr esi,4
do_relocation:                          ; A reloc item contains the seg:off
        movzx edx,word ptr [ebx+2]      ;  addr of a word in image to which
        shl edx,4                       ;  the real mode cs must be added.
        movzx eax,word ptr [ebx]        ;  This loader adds a '32-bit RM seg'
        add edx,eax                     ;  to a _dword_ -> ALWAYS use a
        add [edi+edx],esi               ;  32-bit reg when loading seg names!
        add ebx,4                       ; ebx=ptr to next relocation item
        dec ecx
        jnz do_relocation
relocation_done:

; Compatibility issue; modules can't use current stack because of DPMI
; servers that don't allow a flat memory model. Linux dosemu and Windows NT
; are such servers.
; Memory must be allocated before the value of himembase is filled in in the
; module.
        mov eax,200h
        call gethimem
        add eax,200h                    ; Stack grows down...
        sub eax,edi
        mov noflat_esp,eax
;
        mov ax,code32sel                ; Initialize RAW32 vars in module
        mov edx,edi
        add edx,code32a
        call make_dsc_alias
        jc errexit
        mov [edi+code32selOFF],ax
        mov ax,data32sel
        call make_dsc_alias
        jc errexit
        mov [edi+data32selOFF],ax

        mov ax,zerosel
        mov [edi+zeroselOFF],ax
        mov ax,code16sel
        mov [edi+code16selOFF],ax
        mov ax,data16sel
        mov [edi+data16selOFF],ax
        mov ax,pspsel
        mov [edi+pspselOFF],ax
        mov ax,envsel
        mov [edi+envselOFF],ax

        mov al,IRQ0_vect
        mov [edi+IRQ0_vectOFF],al
        mov al,IRQ8_vect
        mov [edi+IRQ8_vectOFF],al

        mov eax,code16a
        mov [edi+code16aOFF],eax
        mov eax,code32a
        add eax,edi
        mov [edi+code32aOFF],eax
        mov eax,lomembase
        sub eax,edi
        mov [edi+lomembaseOFF],eax
        mov eax,lomemtop
        sub eax,edi
        mov [edi+lomemtopOFF],eax
        mov eax,himembase
        sub eax,edi
        mov [edi+himembaseOFF],eax
        mov eax,himemtop
        sub eax,edi
        mov [edi+himemtopOFF],eax
        mov eax,totalextmem
        mov [edi+totalextmemOFF],eax
        mov al,systemtype
        mov [edi+systemtypeOFF],al
        mov al,windows
        mov [edi+windowsOFF],al
        mov al,returncode
        mov [edi+returncodeOFF],al

        push edi
        mov ecx,16/4
        mov esi,offset hextbl
        mov edi,hextblOFF
        add edi,image
        rep movsd
        pop edi
;
                                        ; Initialize ptrs to RAW32 functions
        mov dword ptr [edi+exitOFF],offset @exit
        mov word ptr [edi+exitOFF+4],cs

        mov dword ptr [edi+getmemOFF],offset modulegetmem
        mov word ptr [edi+getmemOFF+4],cs

        mov dword ptr [edi+getlomemOFF],offset modulegetlomem
        mov word ptr [edi+getlomemOFF+4],cs

        mov dword ptr [edi+gethimemOFF],offset modulegethimem
        mov word ptr [edi+gethimemOFF+4],cs

        mov dword ptr [edi+lomemsizeOFF],offset modulelomemsize
        mov word ptr [edi+lomemsizeOFF+4],cs

        mov dword ptr [edi+himemsizeOFF],offset modulehimemsize
        mov word ptr [edi+himemsizeOFF+4],cs

        mov dword ptr [edi+getdscOFF],offset modulegetdsc
        mov word ptr [edi+getdscOFF+4],cs

        mov dword ptr [edi+setdscOFF],offset modulesetdsc
        mov word ptr [edi+setdscOFF+4],cs

        mov dword ptr [edi+getvectOFF],offset modulegetvect
        mov word ptr [edi+getvectOFF+4],cs

        mov dword ptr [edi+setvectOFF],offset modulesetvect
        mov word ptr [edi+setvectOFF+4],cs

        mov dword ptr [edi+map_phys_addrOFF],offset modulemap_phys_addr
        mov word ptr [edi+map_phys_addrOFF+4],cs

        mov dword ptr [edi+dosshellOFF],offset moduledosshell
        mov word ptr [edi+dosshellOFF+4],cs

        mov dword ptr [edi+dosprintOFF],offset moduledosprint
        mov word ptr [edi+dosprintOFF+4],cs

        mov dword ptr [edi+putstrOFF],offset moduleputstr
        mov word ptr [edi+putstrOFF+4],cs
;
        mov bl,RMCALL_VECT+1            ; Module RM int calls must go through
        mov cx,cs                       ;  this routine, because the register
        mov edx,offset moduleRMint      ;  structure of the module is only a
        call setvect                    ;  copy of the real register struc
        jc errexit                      ;  that is used for a RM int

        mov dword ptr orgstack,esp
        mov word ptr orgstack+4,ss

        mov ax,[edi+data32selOFF]
        mov ss,ax                       ; RAW32 programs assume ss=ds
;       sub esp,edi                     ; Works only under flat memory model
        mov esp,noflat_esp

        push DPMImem
        push VCPImem
        push XMSmem

        mov ds,ax
        mov fs,ax
        mov es,cs:pspsel
        mov gs,cs:zerosel
        movzx eax,word ptr cs:[edi+code32selOFF]
        push eax                        ; cs must be on stack as dword
        mov ebx,cs:module
        movzx eax,word ptr cs:[ebx+14h] ; [14h]=program entry point
        push eax
        retf                            ; Jump to module

@exit:
        mov ax,cs:data32sel
        mov ds,ax
        mov es,ax
        mov fs,ax
        mov gs,zerosel
        lss esp,orgstack

        mov edi,image
        mov al,[edi+returncodeOFF]
        mov returncode,al
        mov edx,offset msg3
        call dosprint
        jmp exit                        ; Return to real/V86 mode

;
notenoughmem:
        mov edx,offset msg1  
        call dosprint
        mov v86r_ah,0
        mov al,16h
        int RMCALL_VECT
        jmp exit                        ; Return to real/V86 mode

;
errexit:
        mov edx,offset msg2    
        call dosprint
        mov v86r_ah,0                   ; ah=0 -> Wait for key and read char
        mov al,16h
        int RMCALL_VECT
        jmp exit                        ; Return to real/V86 mode

;
; Make an alias of a descriptor
; In:
;   ax = selector of a descriptor of which an alias is wanted
;   edx = linear base address of alias descriptor
; Out:
;   CF=0 -> No error
;     ax = selector of alias descriptor
;   CF=1 -> Error
;     ax = ?
;
; Note:
;   This function makes a copy of the descriptor but changes the base address
;   of the descriptor copy to the address specified in edx.
;
make_dsc_alias:
        cmp systemtype,3
        je DPMImake_dsc_alias

        push ebx ecx edx esi edi es
        sub esp,6
        sgdt [esp]
        mov ebx,[esp+2]                 ; Get GDT base address
        add esp,6
        mov esi,eax
        and esi,0fff8h                  ; Clear high word, TI (should be 0!)
        mov es,zerosel                  ;  and RPL -> right offset in GDT
        mov cx,1                        ; Allocate 1 descriptor
        call getdsc
        jc @@errexit
        movzx edi,ax
        mov ecx,es:[ebx+esi]            ; Copy descriptor
        mov es:[ebx+edi],ecx
        mov ecx,es:[ebx+esi+4]
        mov es:[ebx+edi+4],ecx

        mov es:[ebx+edi+2],dx           ; Set descriptor's base
        shr edx,16
        mov es:[ebx+edi+4],dl
        mov es:[ebx+edi+7],dh
        pop es edi esi edx ecx ebx
        clc
        ret

@@errexit:
        pop es edi esi edx ecx ebx
        stc
        ret

DPMImake_dsc_alias:
        push ebx edx edi es
        sub esp,8                       ; Reserve 8 bytes temp space on stack
        mov bx,ax                       ; bx=selector of descriptor to copy
        mov ax,ss
        mov es,ax                       ; es:edi=ptr to buffer to store dsc
        mov edi,esp
        mov ax,0bh                      ; ax=0bh -> Get descriptor
        int 31h
        jc @@errexit

        mov cx,1
        call getdsc                     ; Allocate 1 descriptor
        jc @@errexit

        mov [esp+2],dx                  ; Set descriptor's base
        shr edx,16
        mov [esp+4],dl
        mov [esp+7],dh
        mov bx,ax                       ; Set descriptor just allocated
        mov ax,0ch                      ; ax=0ch -> Set descriptor
        int 31h
        jc @@errexit
        mov ax,bx                       ; ax=selector of new dsc on return
        add esp,8                       ; Restore stack
        pop es edi edx ebx
        clc
        ret

@@errexit:
        add esp,8
        pop es edi edx ebx
        stc
        ret

; Wrapper functions
;
moduleRMint:
        push ecx esi edi ds es
        pushfd
        mov ds,cs:data32sel
        mov es,cs:data32sel
        mov esi,image
        add esi,REGSTRUCOFF
        mov edi,offset v86r_edi
        mov ecx,25                      ; reg structure is 50 bytes in size
        cld
        rep movsw
        int RMCALL_VECT
        mov esi,offset v86r_edi
        mov edi,image
        add edi,REGSTRUCOFF
        mov ecx,25
        rep movsw
        popfd
        pop es ds edi esi ecx
        iretd

;
modulegetmem:
        push edi ds
        mov ds,cs:data32sel
        mov edi,image
        push eax
        mov eax,[edi+lomembaseOFF]
        add eax,edi
        mov lomembase,eax
        mov eax,[edi+himembaseOFF]
        add eax,edi
        mov himembase,eax
        pop eax
        call getmem
        pushfd                          ; "sub eax,edi" modifies CF
        push eax
        mov eax,lomembase
        sub eax,edi
        mov [edi+lomembaseOFF],eax
        mov eax,himembase
        sub eax,edi
        mov [edi+himembaseOFF],eax
        pop eax
        sub eax,edi
        popfd
        pop ds edi
        retf

;
modulegetlomem:
        push edi ds
        mov ds,cs:data32sel
        mov edi,image
        push eax
        mov eax,[edi+lomembaseOFF]
        add eax,edi
        mov lomembase,eax
        pop eax
        call getlomem
        pushfd
        push eax
        mov eax,lomembase
        sub eax,edi
        mov [edi+lomembaseOFF],eax
        pop eax
        sub eax,edi
        popfd
        pop ds edi
        retf

;
modulegethimem:
        push edi ds
        mov ds,cs:data32sel
        mov edi,image
        push eax
        mov eax,[edi+himembaseOFF]
        add eax,edi
        mov himembase,eax
        pop eax
        call gethimem
        pushfd
        push eax
        mov eax,himembase
        sub eax,edi
        mov [edi+himembaseOFF],eax
        pop eax
        sub eax,edi
        popfd
        pop ds edi
        retf

;
modulelomemsize:
        push edi ds
        mov ds,cs:data32sel
        mov edi,image
        push eax
        mov eax,[edi+lomembaseOFF]
        add eax,edi
        mov lomembase,eax
        mov eax,[edi+lomemtopOFF]
        add eax,edi
        mov lomemtop,eax
        pop eax
        call lomemsize
        pop ds edi
        retf

;
modulehimemsize:
        push edi ds
        mov ds,cs:data32sel
        mov edi,image
        push eax
        mov eax,[edi+himembaseOFF]
        add eax,edi
        mov himembase,eax
        mov eax,[edi+himemtopOFF]
        add eax,edi
        mov himemtop,eax
        pop eax
        call himemsize
        pop ds edi
        retf

;
modulegetdsc:
        push ds
        mov ds,cs:data32sel
        call getdsc
        pop ds
        retf

;
modulesetdsc:
        push ds
        mov ds,cs:data32sel
        call setdsc
        pop ds
        retf

;
modulegetvect:
        push ds
        mov ds,cs:data32sel
        call getvect
        pop ds
        retf

;
modulesetvect:
        push ds
        mov ds,cs:data32sel
        call setvect
        pop ds
        retf

;
modulemap_phys_addr:
        push edi ds
        mov ds,cs:data32sel
        mov edi,image
        push eax
        mov eax,[edi+himembaseOFF]
        add eax,edi
        mov himembase,eax
        pop eax
        call map_phys_addr
        pushfd
        push eax
        mov eax,himembase
        sub eax,edi
        mov [edi+himembaseOFF],eax
        pop eax
        popfd
        pop ds edi
        retf

;
moduledosshell:
        push eax edi ds
        mov ds,cs:data32sel
        mov edi,image
        mov eax,[edi+lomembaseOFF]
        add eax,edi
        mov lomembase,eax
        cmp esi,0
        mov eax,0
        je @@preok
        add esi,edi
        mov eax,-1
@@preok:
        call dosshell
        pushfd
        cmp eax,0
        je @@postok
        sub esi,edi
@@postok:
        mov eax,lomembase
        sub eax,edi
        mov [edi+lomembaseOFF],eax
        popfd
        pop ds edi eax
        retf

;
moduledosprint:
        push ds
        mov ds,cs:data32sel
        add edx,image
        call dosprint
        sub edx,image
        pop ds
        retf

;
moduleputstr:
        call putstr
        retf

code32  ends
        end
