program playcode;

var
f : text;
line : string[255];
playf0 : array [1..192] of string[8];
playf1 : array [1..192] of string[8];
playf2 : array [1..192] of string[8];
lines  : integer;
maxlines : integer;
filename : string[255];
i,j : integer;
bstr : string[8];

procedure makecodes;
begin
  line:=line+'                        ';
  (* playf0 = 01-08 *)
  bstr:='';
  for i:=8 downto 1 do
    if (line[i]='x') then bstr:=bstr+'1' else bstr:=bstr+'0';
  playf0[lines]:=bstr;

  (* playf1 = 09-16 *)
  bstr:='00000000';
  for i:=16 downto 9 do
    if (line[i]='x') then bstr[i-8]:='1' else bstr[i-8]:='0';
  playf1[lines]:=bstr;

  (* playf2 = 17-24 *)
  bstr:='';
  for i:=24 downto 17 do
    if (line[i]='x') then bstr:=bstr+'1' else bstr:=bstr+'0';
  playf2[lines]:=bstr;

end;

procedure outputcodes;
begin
  assign(f,'playcode.out');
  rewrite(f);
  write(f,'playf0');
  for i:=lines downto 1 do
    writeln(f,'        .byte %',playf0[i]);
  write(f,'playf1');
  for i:=lines downto 1 do
    writeln(f,'        .byte %',playf1[i]);
  write(f,'playf2');
  for i:=lines downto 1 do
    writeln(f,'        .byte %',playf2[i]);
  writeln(f,'        org $FFFC');
  writeln(f,'        .word start');
  writeln(f,'        .word start');
  close(f);
end;

begin
  write('Input File Name: ');
  readln(filename);
  write('Number of lines: ');
  readln(maxlines);
  assign(f,filename);
  reset(f);
  lines:=0;
  writeln('----- processing of file started: ',filename,' with lines: ',maxlines);
  while (not(eof(f))) and (lines<=maxlines) do
  begin
    readln(f,line);
    writeln(line);
    lines:=lines+1;
    makecodes;
    (*readln;*)
  end;
  close(f);
  writeln('----- processing of file ended: ',filename);
  outputcodes;
end.