								      COMMENT ~
 STDIO.ASM -- I/O PROCEDURES
 
   From `BLUEBOOK of ASSEMBLY ROUTINES for the IBM PC & XT'
         by Christopher L. Morgan
         Copyright (C) 1984 by The Waite Group, Inc.
 
   Function: These routines perform fundamental input/output functions for the
     keyboard, screen, and communication lines.  The standard I/O routines
     can be redirected.  The communications routines alleviate some of the
     problems encountered in DOS and BIOS serial communications handling.
 
   See STDIO.DOC for complete information on the routines.
 _____________________________________________________________________________
 
   Contains:
   ---------
   COM_INCK	--  Communications line check
   COM_INIT	--  Initialize communications line
   COM_OFF	--  Communications line off
   COM_ON	--  Communications line on
   COM_OUT	--  Communications line output
   STD_CRLF	--  Standard output with carriage return & linefeed
   STD_IN	--  Standard input with echo
   STD_INCK	--  Standard input check
   STD_INNE	--  Standard input with no echo
   STD_MSGOUT	--  Standard output of a message
   STD_OUT	--  Standard output
   STD_OUTDR	--  Direct standard output
   STD_SPACE	--  Standard output of a space	
 _____________________________________________________________________________
                                                                              ~
CODES	SEGMENT
	PUBLIC	STD_IN,STD_INNE,STD_INCK,STD_OUT,STD_OUTDR,STD_CRLF,STD_SPACE
	PUBLIC	STD_MSGOUT,COM_INIT,COM_INCK,COM_OUT,COM_ON,COM_OFF
ASSUME CS:CODES
;____________________________ I/O ROUTINES ___________________________________
;Routine for standard input with echo
;
STD_IN	PROC	FAR
	MOV	AH,1				;Standard input
	INT	21H				; DOS call
	RET					;Return
STD_IN	ENDP
;------------------------------------------------------------------------------
;Routine for standard input with NO echo
;
STD_INNE	PROC	FAR
	MOV	AH,8				;Standard input without echo
	INT	21H				; DOS call
	RET					;Return
STD_INNE ENDP
;------------------------------------------------------------------------------
;Routine for standard input check
STD_INCK	PROC	FAR
	PUSH	DX				;Save register
	MOV	DL,0FFH				;Direct console input
	MOV	AH,06H				;Check std direct input status
	INT	21H				; DOS call
	POP	DX				;Restore register
	RET					;Return
STD_INCK	ENDP
;------------------------------------------------------------------------------
;Routine for standard output
;
STD_OUT	PROC	FAR
	PUSH	DX				;Save register
	MOV	DL,AL				;In DL for DOS call 
	MOV	AH,2				;Standard output
	INT	21H				; DOS call
	POP	DX				;Restore register	
	RET					;Return
STD_OUT	ENDP
;------------------------------------------------------------------------------
;Routine for direct standard output
;
STD_OUTDR	PROC	FAR
	PUSH	DX				;Save register
	CMP	AL,0FFH				;Check for the 1 case of input
	JE	STD_OUTDRXIT			;If so, go
	MOV	DL,AL				;Else in DL for DOS call
	MOV	AH,6				;Direct console output
	INT	21H				; DOS call
STD_OUTDRXIT:
	POP	DX				;Restore register
	RET					;Return
STD_OUTDR	ENDP
;------------------------------------------------------------------------------
;Routine to send a CRLF sequence to standard output
;
STD_CRLF	PROC	FAR
	PUSH	AX				;Save register
	MOV	AL,13				;ASCII carriage return
	CALL	STD_OUT				;Send it out
	MOV	AL,10				;ASCII line feed
	CALL	STD_OUT				;Send it out
	POP	AX				;Restore register
	RET					;Return
STD_CRLF	ENDP
;------------------------------------------------------------------------------
;Routine to send a space to standard output
;
STD_SPACE	PROC	FAR
	PUSH	AX				;Save register
	MOV	AL,32				;ASCII space
	CALL	STD_OUT				;Send it out
	POP	AX				;Restore register
	RET
STD_SPACE	ENDP
;------------------------------------------------------------------------------
;Routine to send message to standard output
;
STD_MSGOUT	PROC	FAR
	PUSH	SI				;Save registers
	PUSH	AX
STD_MSGOUT1:
	MOV	AL,[SI]				;Get byte
	INC	SI				;Point to next byte
	CMP	AL,0				;Done?
	JE	STD_MSGOUTXIT			;If so, go
	CALL	STD_OUT				;Else send it out
	JMP	STD_MSGOUT1			;Loop for more
STD_MSGOUTXIT:
	POP	AX				;Restore registers
	POP	SI
	RET					;Return
STD_MSGOUT	ENDP
;------------------------------------------------------------------------------
;Routine to initialize a communications line
;
COM_INIT	PROC	FAR
	MOV	AH,0				;Initialize
	INT	14H				;RS232 BIOS call
	RET					;Return
COM_INIT	ENDP
;------------------------------------------------------------------------------
;Routine to check for input from a communications line
;
COM_INCK	PROC	FAR
	PUSH	DS				;Save registers
	PUSH	DX
	PUSH	SI
	MOV	SI,DX				;Look up address of com line
	ADD	SI,SI				;Double to index into table
	MOV	DX,40H				;Segment of system I/O table
	MOV	DS,DX				;Set data seg to this table
	MOV	DX,[SI]				;Now get it
	ADD	DX,5				;Line status
	IN	AL,DX				;Get it
	TEST	AL,1				;Receive buffer full?
	JZ	COM_INCKXIT			;If so, go
	MOV	DX,[SI]				;Data register
	IN	AL,DX				;Get it
COM_INCKXIT:
	POP	SI				;Restore registers
	POP	DX
	POP	DS
	RET
COM_INCK	ENDP
;------------------------------------------------------------------------------
;Routine to send output to a communications line
;
COM_OUT	PROC	FAR
	MOV	AH,1				;Send it out
	INT	14H				;RS232 BIOS call
	RET					;Return
COM_OUT	ENDP
;------------------------------------------------------------------------------
;Routine to turn on input from a communications line
;
COM_ON	PROC	FAR
	PUSH	DS				;Save registers
	PUSH	DX
	PUSH	SI
	MOV	SI,DX				;Look up address of com line
	ADD	SI,SI				;Double to index into table
	MOV	DX,40H				;Segment of system I/O table
	MOV	DS,DX				;Set data seg to this table
	MOV	DX,[SI]				;Now get it
	ADD	DX,4				;Modem control register
	MOV	AL,3				;Set DTR & RTS
	OUT	DX,AL				;Send out control byte
	POP	SI				;Restore registers
	POP	DX
	POP	DS
	RET
COM_ON	ENDP
;------------------------------------------------------------------------------
;Routine to turn off input from a communications line
;
COM_OFF	PROC	FAR
	PUSH	DS				;Save registers
	PUSH	DX
	PUSH	SI
	MOV	SI,DX				;Look up address of com line
	ADD	SI,SI				;Double to index into table
	MOV	DX,40H				;Segment of system I/O table
	MOV	DS,DX				;Set data seg to this table
	MOV	DX,[SI]				;Now get it
	ADD	DX,4				;Modem control register
	MOV	AL,2				;Clear DTR (line 20)
	OUT	DX,AL				;Send out control byte
	POP	SI				;Restore registers
	POP	DX
	POP	DS
	RET
COM_OFF  ENDP
;-----------------------------------------------------------------------------
CODES	ENDS
;
	END
;_____________________________________________________________________________
;>>>>> Physical EOF STDIO.ASM <<<<
