;********************************************************;
;* NEWPAL.ASM -- Displays three 256-color palettes, the *;
;* first one is [value = rrrgggbb], the second has the  *;
;* first 64 colors as rrggbb and the last 192 are a rgb *;
;* 3-color spectrum, and the third has the first 64 as  *;
;* rrggbb, the next 64 as grayscale and the next 126 a  *;
;* rygcbm 6-color spectrum.  This is public domain.     *;
;********************************************************;

Ideal
Model Tiny
CodeSeg
Org 100h

Proc        Prog

            mov ax,13h
            int 10h
            mov ax,0A000h
            mov es,ax
            xor ah,ah
            xor di,di
            mov si,8
TLineLoop:  mov bx,25
LineLoop:   mov al,ah
            mov dx,32
BlkLoop:    mov cx,10
            rep stosb
            inc al
            dec dx
            jnz BlkLoop
            dec bx
            jnz LineLoop
            add ah,32
            dec si
            jnz TLineLoop
            xor ah,ah
            int 16h
            mov ax,1012h
            xor bx,bx
            mov cx,256
            push cs
            pop es
            lea dx,[Palette1]
            int 10h
            xor ah,ah
            int 16h
            mov ax,1012h
            lea dx,[Palette2]
            int 10h
            xor ah,ah
            int 16h
            mov ax,1012h
            lea dx,[Palette3]
            int 10h
            xor ah,ah
            int 16h
            mov ax,13h
            int 10h
            mov ax,0A000h
            mov es,ax
            mov di,32
            mov dx,200
LineLoop1:  mov cx,256
            xor al,al
PixLoop:    stosb
            inc al
            loop PixLoop
            add di,64
            dec dx
            jnz LineLoop1
            xor ah,ah
            int 16h
            mov ax,1012h
            xor bx,bx
            mov cx,256
            push cs
            pop es
            lea dx,[Palette1]
            int 10h
            xor ah,ah
            int 16h
            mov ax,1012h
            lea dx,[Palette2]
            int 10h
            xor ah,ah
            int 16h
            mov ax,1012h
            lea dx,[Palette3]
            int 10h
            xor ah,ah
            int 16h
            mov ax,3
            int 10h
            ret

EndP        Prog

Palette1:
     dw 0,0,5376,0,42,16128,2304,0,5385,2304,42,16137,4608,0,5394,4608
     dw 42,16146,6912,0,5403,6912,42,16155,9216,0,5412,9216,42,16164
     dw 11520,0,5421,11520,42,16173,13824,0,5430,13824,42,16182,16128
     dw 0,5439,16128,42,16191,9,2304,5376,9,2346,16128,2313,2304,5385
     dw 2313,2346,16137,4617,2304,5394,4617,2346,16146,6921,2304,5403
     dw 6921,2346,16155,9225,2304,5412,9225,2346,16164,11529,2304,5421
     dw 11529,2346,16173,13833,2304,5430,13833,2346,16182,16137,2304
     dw 5439,16137,2346,16191,18,4608,5376,18,4650,16128,2322,4608,5385
     dw 2322,4650,16137,4626,4608,5394,4626,4650,16146,6930,4608,5403
     dw 6930,4650,16155,9234,4608,5412,9234,4650,16164,11538,4608,5421
     dw 11538,4650,16173,13842,4608,5430,13842,4650,16182,16146,4608
     dw 5439,16146,4650,16191,27,6912,5376,27,6954,16128,2331,6912,5385
     dw 2331,6954,16137,4635,6912,5394,4635,6954,16146,6939,6912,5403
     dw 6939,6954,16155,9243,6912,5412,9243,6954,16164,11547,6912,5421
     dw 11547,6954,16173,13851,6912,5430,13851,6954,16182,16155,6912
     dw 5439,16155,6954,16191,36,9216,5376,36,9258,16128,2340,9216,5385
     dw 2340,9258,16137,4644,9216,5394,4644,9258,16146,6948,9216,5403
     dw 6948,9258,16155,9252,9216,5412,9252,9258,16164,11556,9216,5421
     dw 11556,9258,16173,13860,9216,5430,13860,9258,16182,16164,9216
     dw 5439,16164,9258,16191,45,11520,5376,45,11562,16128,2349,11520
     dw 5385,2349,11562,16137,4653,11520,5394,4653,11562,16146,6957,11520
     dw 5403,6957,11562,16155,9261,11520,5412,9261,11562,16164,11565
     dw 11520,5421,11565,11562,16173,13869,11520,5430,13869,11562,16182
     dw 16173,11520,5439,16173,11562,16191,54,13824,5376,54,13866,16128
     dw 2358,13824,5385,2358,13866,16137,4662,13824,5394,4662,13866,16146
     dw 6966,13824,5403,6966,13866,16155,9270,13824,5412,9270,13866,16164
     dw 11574,13824,5421,11574,13866,16173,13878,13824,5430,13878,13866
     dw 16182,16182,13824,5439,16182,13866,16191,63,16128,5376,63,16170
     dw 16128,2367,16128,5385,2367,16170,16137,4671,16128,5394,4671,16170
     dw 16146,6975,16128,5403,6975,16170,16155,9279,16128,5412,9279,16170
     dw 16164,11583,16128,5421,11583,16170,16173,13887,16128,5430,13887
     dw 16170,16182,16191,16128,5439,16191,16170,16191

Palette2:
     dw 0,0,5376,0,42,16128,5376,0,5397,5376,42,16149,10752,0,5418,10752
     dw 42,16170,16128,0,5439,16128,42,16191,21,5376,5376,21,5418,16128
     dw 5397,5376,5397,5397,5418,16149,10773,5376,5418,10773,5418,16170
     dw 16149,5376,5439,16149,5418,16191,42,10752,5376,42,10794,16128
     dw 5418,10752,5397,5418,10794,16149,10794,10752,5418,10794,10794
     dw 16170,16170,10752,5439,16170,10794,16191,63,16128,5376,63,16170
     dw 16128,5439,16128,5397,5439,16170,16149,10815,16128,5418,10815
     dw 16170,16170,16191,16128,5439,16191,16170,16191,63,15872,1,573
     dw 15360,3,1083,14848,5,1593,14336,7,2103,13824,9,2613,13312,11
     dw 3123,12800,13,3633,12288,15,4143,11776,17,4653,11264,19,5163
     dw 10752,21,5673,10240,23,6183,9728,25,6693,9216,27,7203,8704,29
     dw 7713,8192,31,8223,7680,33,8733,7168,35,9243,6656,37,9753,6144
     dw 39,10263,5632,41,10773,5120,43,11283,4608,45,11793,4096,47,12303
     dw 3584,49,12813,3072,51,13323,2560,53,13833,2048,55,14343,1536
     dw 57,14853,1024,59,15363,512,61,15873,0,63,16128,0,318,15616,2
     dw 828,15104,4,1338,14592,6,1848,14080,8,2358,13568,10,2868,13056
     dw 12,3378,12544,14,3888,12032,16,4398,11520,18,4908,11008,20,5418
     dw 10496,22,5928,9984,24,6438,9472,26,6948,8960,28,7458,8448,30
     dw 7968,7936,32,8478,7424,34,8988,6912,36,9498,6400,38,10008,5888
     dw 40,10518,5376,42,11028,4864,44,11538,4352,46,12048,3840,48,12558
     dw 3328,50,13068,2816,52,13578,2304,54,14088,1792,56,14598,1280
     dw 58,15108,768,60,15618,256,62,16128,0,319,15872,2,829,15360,4
     dw 1339,14848,6,1849,14336,8,2359,13824,10,2869,13312,12,3379,12800
     dw 14,3889,12288,16,4399,11776,18,4909,11264,20,5419,10752,22,5929
     dw 10240,24,6439,9728,26,6949,9216,28,7459,8704,30,7969,8192,32
     dw 8479,7680,34,8989,7168,36,9499,6656,38,10009,6144,40,10519,5632
     dw 42,11029,5120,44,11539,4608,46,12049,4096,48,12559,3584,50,13069
     dw 3072,52,13579,2560,54,14089,2048,56,14599,1536,58,15109,1024
     dw 60,15619,512,62,16129,0

Palette3:
     dw 0,0,5376,0,42,16128,5376,0,5397,5376,42,16149,10752,0,5418,10752
     dw 42,16170,16128,0,5439,16128,42,16191,21,5376,5376,21,5418,16128
     dw 5397,5376,5397,5397,5418,16149,10773,5376,5418,10773,5418,16170
     dw 16149,5376,5439,16149,5418,16191,42,10752,5376,42,10794,16128
     dw 5418,10752,5397,5418,10794,16149,10794,10752,5418,10794,10794
     dw 16170,16170,10752,5439,16170,10794,16191,63,16128,5376,63,16170
     dw 16128,5439,16128,5397,5439,16170,16149,10815,16128,5418,10815
     dw 16170,16170,16191,16128,5439,16191,16170,16191,0,256,257,514
     dw 770,771,1028,1284,1285,1542,1798,1799,2056,2312,2313,2570,2826
     dw 2827,3084,3340,3341,3598,3854,3855,4112,4368,4369,4626,4882,4883
     dw 5140,5396,5397,5654,5910,5911,6168,6424,6425,6682,6938,6939,7196
     dw 7452,7453,7710,7966,7967,8224,8480,8481,8738,8994,8995,9252,9508
     dw 9509,9766,10022,10023,10280,10536,10537,10794,11050,11051,11308
     dw 11564,11565,11822,12078,12079,12336,12592,12593,12850,13106,13107
     dw 13364,13620,13621,13878,14134,14135,14392,14648,14649,14906,15162
     dw 15163,15420,15676,15677,15934,16190,16191,63,16128,3,1599,16128
     dw 9,3135,16128,15,4671,16128,21,6207,16128,27,7743,16128,33,9279
     dw 16128,39,10815,16128,45,12351,16128,51,13887,16128,57,15423,16128
     dw 63,16188,14592,63,16182,13056,63,16176,11520,63,16170,9984,63
     dw 16164,8448,63,16158,6912,63,16152,5376,63,16146,3840,63,16140
     dw 2304,63,16134,768,63,16128,0,831,16128,6,2367,16128,12,3903,16128
     dw 18,5439,16128,24,6975,16128,30,8511,16128,36,10047,16128,42,11583
     dw 16128,48,13119,16128,54,14655,16128,60,16191,15360,63,16185,13824
     dw 63,16179,12288,63,16173,10752,63,16167,9216,63,16161,7680,63
     dw 16155,6144,63,16149,4608,63,16143,3072,63,16137,1536,63,16131
     dw 0,831,16128,6,2367,16128,12,3903,16128,18,5439,16128,24,6975
     dw 16128,30,8511,16128,36,10047,16128,42,11583,16128,48,13119,16128
     dw 54,14655,16128,60,16191,16128,63,16188,14592,63,16182,13056,63
     dw 16176,11520,63,16170,9984,63,16164,8448,63,16158,6912,63,16152
     dw 5376,63,16146,3840,63,16140,2304,63,16134,768,0,0,0

End Prog

