;------------------
; Unsigned integer square root of unsigned integer.
; Derived from code on page 143 of "Assembly Language Magic" Copyright
; by William H. Murray and Chris H. Pappas.

_AOFF EQU 6d

SQURT_TEXT   SEGMENT byte public 'CODE'
        ASSUME  cs:SQURT_TEXT, ds:_DATA
        PUBLIC  _squrt

; This function not callable from C. Takes unsigned long integer in
; AX:BX and returns approximate square root in AX.
unt_squrt PROC FAR
        PUSH    BX
        PUSH    CX
        PUSH    DX
        PUSH    DI
        CMP     AX,0000h        ; 0 and 1 are their own answers - return.
        JNE     us_do
        CMP     BX,0000h
        JE      us_done
us_do:  MOV     DI,0000h        ; Counter = 0.
        MOV     CX,0001h        ; First value to subtract.
        MOV     DX,0000h        ; MSW of value.
us_rep: SUB     BX,CX           ; Subtract odd integer.
        SBB     AX,DX           ; 2nd part of subtraction.
        JB      us_all          ; Finished if less than zero.
        INC     DI              ; Increment square-root value.
        ADD     CX,0002h        ; Next odd number.
        ADC     DX,0000h        ; Carry.
        JMP     us_rep          ; Loop.
us_all: MOV     AX,DI           ; Return answer.
us_done:
        POP     DI
        POP     DX
        POP     CX
        POP     BX
        RET
unt_squrt ENDP

; C prototype:
; unsigned int far squrt(unsigned long);
_squrt  PROC    FAR
        PUSH    BP
        MOV     BP,SP
        MOV     AX,[BP+_AOFF+2] ; Fetch number to take root of.
        MOV     BX,[BP+_AOFF+0] ; LSW of number.
        CALL    unt_squrt       ; Get answer.
        POP     BP
        RET
_squrt  ENDP

SQURT_TEXT      ENDS

_DATA   SEGMENT WORD PUBLIC 'DATA'

_DATA   ENDS

        END

