;------------------------
;From: GERTJAN KLEIN
;Subj: Mem Allocation Problems.

        .MODEL  SMALL
.CODE

main            proc    far

        mov     ah,4ah                  ;DOS change memory allocation funtion
        mov     bx,paras                ;Number of paragraphs to keep
        int     21h
        mov     ax,@data                ;Get data segment
        mov     ds,ax                   ; ... in ds
        mov     ah,9                    ;DOS display string function
        mov     dx,offset signon        ;Say "Hello"
        int     21h
        mov     ax,4c00h                ;Back to DOS, errorlevel 0
        int     21h

main            endp

sgsiz__ =       ($-main)                ;Number of bytes used in segment
IF              (sgsiz__ MOD 2)         ;Round up to next word since .DATA
sgsiz__ =       sgsiz__ + 1             ; segment is word aligned
ENDIF
total   =       sgsiz__

.DATA ;##############################################################

signon  db      "Hello, world...",13,10,'$'

sgsiz__ =       ($-signon)              ;Number of bytes used in segment
total   =       total + sgsiz__         ;Add size of this segment to total
IF              (total MOD 2)           ;Round up to next word since .DATA?
total   =       total + 1               ; segment is word aligned
ENDIF

.DATA? ;#############################################################

buffer  db      512 dup (?)

sgsiz__ =       ($-buffer)              ;Number of bytes used in segment
total   =       total + sgsiz__         ;Add size of this segment to total
IF              (total MOD 16)          ;Round up to next paragraph since
total   =       (((total / 16)+1)*16)   ; .STACK segment is paragraph aligned
ENDIF

.STACK  100h ;#######################################################

sgsiz__ =       100h                    ;Number of bytes used in segments
total   =       total + sgsiz__         ;Add size of this segment to total
IF              (total MOD 16)          ;If division leaves remainder...
paras   equ     (total / 16) + 1        ; this is how many paragraphs we use
ELSE                                    ; else...
paras   equ     (total / 16)            ; this is how many paragraphs we use
ENDIF

        END     main

